/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.KillTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.executor.jpa.BundleActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionsGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class BundleKillXCommand
extends KillTransitionXCommand {
    private final String jobId;
    private BundleJobBean bundleJob;
    private List<BundleActionBean> bundleActions;
    private JPAService jpaService = null;

    public BundleKillXCommand(String jobId) {
        super("bundle_kill", "bundle_kill", 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.bundleJob = this.jpaService.execute(new BundleJobGetJPAExecutor(this.jobId));
            this.bundleActions = this.jpaService.execute(new BundleActionsGetJPAExecutor(this.jobId));
            LogUtils.setLogInfo(this.bundleJob, this.logInfo);
            super.setJob((Job)this.bundleJob);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.bundleJob.getStatus() == Job.Status.SUCCEEDED || this.bundleJob.getStatus() == Job.Status.FAILED || this.bundleJob.getStatus() == Job.Status.DONEWITHERROR) {
            this.LOG.info("BundleKillXCommand not killed - job either finished SUCCEEDED, FAILED or DONEWITHERROR, job id = " + this.jobId + ", status = " + this.bundleJob.getStatus());
            throw new PreconditionException(ErrorCode.E1020, this.jobId);
        }
    }

    @Override
    public void killChildren() throws CommandException {
        if (this.bundleActions != null) {
            for (BundleActionBean action : this.bundleActions) {
                if (action.getCoordId() != null) {
                    this.queue(new CoordKillXCommand(action.getCoordId()));
                    this.updateBundleAction(action);
                    this.LOG.debug("Killed bundle action = [{0}], new status = [{1}], pending = [{2}] and queue CoordKillXCommand for [{3}]", action.getBundleActionId(), action.getStatus(), action.getPending(), action.getCoordId());
                    continue;
                }
                this.updateBundleAction(action);
                this.LOG.debug("Killed bundle action = [{0}], current status = [{1}], pending = [{2}]", action.getBundleActionId(), action.getStatus(), action.getPending());
            }
        }
        this.LOG.debug("Killed coord jobs for the bundle=[{0}]", this.jobId);
    }

    private void updateBundleAction(BundleActionBean action) throws CommandException {
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        action.setStatus(Job.Status.KILLED);
        try {
            this.jpaService.execute(new BundleActionUpdateJPAExecutor(action));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void notifyParent() {
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }

    @Override
    public void updateJob() throws CommandException {
        try {
            this.jpaService.execute(new BundleJobUpdateJPAExecutor(this.bundleJob));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }
}

