/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.List;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.BundleActionsDeleteForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class BundlePurgeXCommand
extends XCommand<Void> {
    private JPAService jpaService = null;
    private final int olderThan;
    private final int limit;
    private List<BundleJobBean> jobList = null;

    public BundlePurgeXCommand(int olderThan, int limit) {
        super("bundle_purge", "bundle_purge", 0);
        this.olderThan = olderThan;
        this.limit = limit;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.jobList = this.jpaService.execute(new BundleJobsGetForPurgeJPAExecutor(this.olderThan, this.limit));
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED Bundle-Purge to purge Jobs older than [{0}] days.", this.olderThan);
        int actionDeleted = 0;
        if (this.jobList != null && this.jobList.size() != 0) {
            for (BundleJobBean bundle : this.jobList) {
                String jobId = bundle.getId();
                try {
                    this.jpaService.execute(new BundleJobDeleteJPAExecutor(jobId));
                    actionDeleted += this.jpaService.execute(new BundleActionsDeleteForPurgeJPAExecutor(jobId)).intValue();
                }
                catch (JPAExecutorException e) {
                    throw new CommandException(e);
                }
            }
            this.LOG.debug("ENDED Bundle-Purge deleted jobs :" + this.jobList.size() + " and actions " + actionDeleted);
        } else {
            this.LOG.debug("ENDED Bundle-Purge no Bundle job to be deleted");
        }
        return null;
    }

    @Override
    protected String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

