/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.executor.jpa.CoordActionRemoveJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionByActionNumberJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class CoordChangeCommand
extends CoordinatorCommand<Void> {
    private String jobId;
    private Date newEndTime = null;
    private Integer newConcurrency = null;
    private Date newPauseTime = null;
    private boolean resetPauseTime = false;
    private static final XLog LOG = XLog.getLog(CoordChangeCommand.class);
    private static final Set<String> ALLOWED_CHANGE_OPTIONS = new HashSet<String>();

    public CoordChangeCommand(String id, String changeValue) throws CommandException {
        super("coord_change", "coord_change", 0, 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
        ParamChecker.notEmpty(changeValue, "value");
        this.validateChangeValue(changeValue);
    }

    private void validateChangeValue(String changeValue) throws CommandException {
        String value;
        Map<String, String> map = JobUtils.parseChangeValue(changeValue);
        if (map.size() > ALLOWED_CHANGE_OPTIONS.size()) {
            throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (!ALLOWED_CHANGE_OPTIONS.contains(key)) {
                throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime");
            }
            if (key.equals("pausetime") || !value2.equalsIgnoreCase("")) continue;
            throw new CommandException(ErrorCode.E1015, changeValue, "value on " + key + " can not be empty");
        }
        if (map.containsKey("endtime")) {
            value = map.get("endtime");
            try {
                this.newEndTime = DateUtils.parseDateUTC(value);
            }
            catch (Exception ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
            }
        }
        if (map.containsKey("concurrency")) {
            value = map.get("concurrency");
            try {
                this.newConcurrency = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid integer");
            }
        }
        if (map.containsKey("pausetime")) {
            value = map.get("pausetime");
            if (value.equals("")) {
                this.resetPauseTime = true;
            } else {
                try {
                    this.newPauseTime = DateUtils.parseDateUTC(value);
                }
                catch (Exception ex) {
                    throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
                }
            }
        }
    }

    private void checkEndTime(CoordinatorJobBean coordJob, Date newEndTime) throws CommandException {
        Date d;
        Date startTime = coordJob.getStartTime();
        if (newEndTime.before(startTime)) {
            throw new CommandException(ErrorCode.E1015, newEndTime, "cannot be before coordinator job's start time [" + startTime + "]");
        }
        Date lastActionTime = coordJob.getLastActionTime();
        if (lastActionTime != null && !newEndTime.after(d = new Date(lastActionTime.getTime() - (long)(coordJob.getFrequency() * 60 * 1000)))) {
            throw new CommandException(ErrorCode.E1015, newEndTime, "must be after coordinator job's last action time [" + d + "]");
        }
    }

    private void checkPauseTime(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
        Date d = new Date();
        if (newPauseTime.before(d)) {
            throw new CommandException(ErrorCode.E1015, newPauseTime, "must be a non-past time");
        }
    }

    private void processLookaheadActions(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
        Date lastActionTime = coordJob.getLastActionTime();
        if (lastActionTime != null) {
            Date d = new Date(lastActionTime.getTime() - (long)(coordJob.getFrequency() * 60 * 1000));
            int lastActionNumber = coordJob.getLastActionNumber();
            boolean hasChanged = false;
            while (!newPauseTime.after(d)) {
                this.deleteAction(coordJob.getId(), lastActionNumber);
                d = new Date(d.getTime() - (long)(coordJob.getFrequency() * 60 * 1000));
                --lastActionNumber;
                hasChanged = true;
            }
            if (hasChanged) {
                coordJob.setLastActionNumber(lastActionNumber);
                Date d1 = new Date(d.getTime() + (long)(coordJob.getFrequency() * 60 * 1000));
                coordJob.setLastActionTime(d1);
                coordJob.setNextMaterializedTime(d1);
                if (coordJob.getStatus() == Job.Status.SUCCEEDED) {
                    coordJob.setStatus(Job.Status.RUNNING);
                }
            }
        }
    }

    private void deleteAction(String jobId, int lastActionNum) throws CommandException {
        JPAService jpaService = Services.get().get(JPAService.class);
        if (jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            CoordinatorActionBean actionBean = jpaService.execute(new CoordJobGetActionByActionNumberJPAExecutor(jobId, lastActionNum));
            jpaService.execute(new CoordActionRemoveJPAExecutor(actionBean.getId()));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    private void check(CoordinatorJobBean coordJob, Date newEndTime, Integer newConcurrency, Date newPauseTime) throws CommandException {
        if (coordJob.getStatus() == Job.Status.KILLED) {
            throw new CommandException(ErrorCode.E1016, new Object[0]);
        }
        if (newEndTime != null) {
            this.checkEndTime(coordJob, newEndTime);
        }
        if (newPauseTime != null) {
            this.checkPauseTime(coordJob, newPauseTime);
        }
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        try {
            CoordinatorJobBean coordJob = store.getCoordinatorJob(this.jobId, false);
            this.setLogInfo(coordJob);
            this.check(coordJob, this.newEndTime, this.newConcurrency, this.newPauseTime);
            if (this.newEndTime != null) {
                coordJob.setEndTime(this.newEndTime);
                if (coordJob.getStatus() == Job.Status.SUCCEEDED) {
                    coordJob.setStatus(Job.Status.RUNNING);
                }
            }
            if (this.newConcurrency != null) {
                coordJob.setConcurrency(this.newConcurrency);
            }
            if (this.newPauseTime != null || this.resetPauseTime) {
                coordJob.setPauseTime(this.newPauseTime);
                if (!this.resetPauseTime) {
                    this.processLookaheadActions(coordJob, this.newPauseTime);
                }
            }
            store.updateCoordinatorJob(coordJob);
            return null;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        block6: {
            LOG.info("STARTED CoordChangeCommand for jobId=" + this.jobId);
            try {
                if (this.lock(this.jobId)) {
                    this.call(store);
                    break block6;
                }
                throw new CommandException(ErrorCode.E0606, "job " + this.jobId + " has been locked and cannot change value, please retry later");
            }
            catch (InterruptedException e) {
                throw new CommandException(ErrorCode.E0606, "acquiring lock for job " + this.jobId + " failed " + " with exception " + e.getMessage());
            }
            finally {
                LOG.info("ENDED CoordChangeCommand for jobId=" + this.jobId);
            }
        }
        return null;
    }

    static {
        ALLOWED_CHANGE_OPTIONS.add("endtime");
        ALLOWED_CHANGE_OPTIONS.add("concurrency");
        ALLOWED_CHANGE_OPTIONS.add("pausetime");
    }
}

