/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobUpdateJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.db.SLADbXOperations;

public class ActionKillXCommand
extends ActionXCommand<Void> {
    private String actionId;
    private String jobId;
    private WorkflowJobBean wfJob;
    private WorkflowActionBean wfAction;
    private JPAService jpaService = null;

    public ActionKillXCommand(String actionId, String type) {
        super("action.kill", type, 0);
        this.actionId = actionId;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    public ActionKillXCommand(String actionId) {
        this(actionId, "action.kill");
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJob = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.jobId));
            this.wfAction = this.jpaService.execute(new WorkflowActionGetJPAExecutor(this.actionId));
            LogUtils.setLogInfo(this.wfJob, this.logInfo);
            LogUtils.setLogInfo(this.wfAction, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfAction.getStatus() != WorkflowAction.Status.KILLED) {
            throw new PreconditionException(ErrorCode.E0726, this.wfAction.getId());
        }
    }

    @Override
    protected Void execute() throws CommandException {
        ActionExecutor executor;
        this.LOG.debug("STARTED WorkflowActionKillXCommand for action " + this.actionId);
        if (this.wfAction.isPending() && (executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType())) != null) {
            try {
                boolean isRetry = false;
                boolean isUserRetry = false;
                ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
                this.incrActionCounter(this.wfAction.getType(), 1);
                Instrumentation.Cron cron = new Instrumentation.Cron();
                cron.start();
                executor.kill(context, this.wfAction);
                cron.stop();
                this.addActionCron(this.wfAction.getType(), cron);
                this.wfAction.resetPending();
                this.wfAction.setStatus(WorkflowAction.Status.KILLED);
                this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(this.wfAction));
                this.jpaService.execute(new WorkflowJobUpdateJPAExecutor(this.wfJob));
                SLADbXOperations.writeStausEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.KILLED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                this.queue(new NotificationXCommand(this.wfJob, this.wfAction));
            }
            catch (ActionExecutorException ex) {
                this.wfAction.resetPending();
                this.wfAction.setStatus(WorkflowAction.Status.FAILED);
                this.wfAction.setErrorInfo(ex.getErrorCode().toString(), "KILL COMMAND FAILED - exception while executing job kill");
                this.wfJob.setStatus(WorkflowJob.Status.KILLED);
                try {
                    this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(this.wfAction));
                    this.jpaService.execute(new WorkflowJobUpdateJPAExecutor(this.wfJob));
                }
                catch (JPAExecutorException je) {
                    throw new CommandException(je);
                }
                SLADbXOperations.writeStausEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                this.LOG.warn("Exception while executing kill(). Error Code [{0}], Message[{1}]", ex.getErrorCode(), ex.getMessage(), ex);
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        this.LOG.debug("ENDED WorkflowActionKillXCommand for action " + this.actionId);
        return null;
    }
}

