/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class SLAEventsGetForSeqIdJPAExecutor
implements JPAExecutor<List<SLAEventBean>> {
    private long seqId = 0L;
    private int limitLen = 100;
    private long[] lastSeqId;

    public SLAEventsGetForSeqIdJPAExecutor(long seqId, int limitLen, long[] lastSeqId) {
        this.seqId = seqId;
        this.limitLen = limitLen;
        this.lastSeqId = lastSeqId;
        this.lastSeqId[0] = seqId;
    }

    @Override
    public String getName() {
        return "SLAEventsGetForSeqIdJPAExecutor";
    }

    @Override
    public List<SLAEventBean> execute(EntityManager em) throws JPAExecutorException {
        List seBeans;
        try {
            Query q = em.createNamedQuery("GET_SLA_EVENT_NEWER_SEQ_LIMITED");
            q.setParameter("id", (Object)this.seqId);
            q.setMaxResults(this.limitLen);
            seBeans = q.getResultList();
            for (SLAEventBean j : seBeans) {
                this.lastSeqId[0] = Math.max(this.lastSeqId[0], j.getEvent_id());
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return seBeans;
    }
}

