/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class WorkflowActionSubsetGetJPAExecutor
implements JPAExecutor<List<WorkflowActionBean>> {
    private final String wfId;
    private final int start;
    private final int length;

    public WorkflowActionSubsetGetJPAExecutor(String wfId, int start, int length) {
        ParamChecker.notNull(wfId, "wfJobId");
        this.wfId = wfId;
        this.start = start;
        this.length = length;
    }

    @Override
    public List<WorkflowActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<WorkflowActionBean> actionList = new ArrayList<WorkflowActionBean>();
        try {
            Query q = em.createNamedQuery("GET_ACTIONS_FOR_WORKFLOW");
            OpenJPAPersistence.cast((Query)q);
            q.setParameter("wfId", (Object)this.wfId);
            q.setFirstResult(this.start - 1);
            q.setMaxResults(this.length);
            List actions = q.getResultList();
            for (WorkflowActionBean a : actions) {
                WorkflowActionBean aa = this.getBeanForRunningAction(a);
                actionList.add(aa);
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0605, e);
        }
        return actionList;
    }

    @Override
    public String getName() {
        return "WorkflowActionSubsetGetJPAExecutor";
    }

    private WorkflowActionBean getBeanForRunningAction(WorkflowActionBean a) throws SQLException {
        if (a != null) {
            WorkflowActionBean action = new WorkflowActionBean();
            action.setId(a.getId());
            action.setConf(a.getConf());
            action.setConsoleUrl(a.getConsoleUrl());
            action.setData(a.getData());
            action.setErrorInfo(a.getErrorCode(), a.getErrorMessage());
            action.setExternalId(a.getExternalId());
            action.setExternalStatus(a.getExternalStatus());
            action.setName(a.getName());
            action.setCred(a.getCred());
            action.setRetries(a.getRetries());
            action.setTrackerUri(a.getTrackerUri());
            action.setTransition(a.getTransition());
            action.setType(a.getType());
            action.setEndTime(a.getEndTime());
            action.setExecutionPath(a.getExecutionPath());
            action.setLastCheckTime(a.getLastCheckTime());
            action.setLogToken(a.getLogToken());
            if (a.getPending()) {
                action.setPending();
            }
            action.setPendingAge(a.getPendingAge());
            action.setSignalValue(a.getSignalValue());
            action.setSlaXml(a.getSlaXml());
            action.setStartTime(a.getStartTime());
            action.setStatus(a.getStatus());
            action.setJobId(a.getWfId());
            return action;
        }
        return null;
    }
}

