/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class RequestSynchronizer {
    private static final String WEBKEY = "requestSynchronizer";
    private static Logger logger = Logger.getLogger((Class)RequestSynchronizer.class);
    private String resultURI = null;
    private Thread currentThread = null;

    RequestSynchronizer() {
    }

    public static synchronized RequestSynchronizer instance(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        RequestSynchronizer rsync = (RequestSynchronizer)session.getAttribute(WEBKEY);
        if (rsync == null) {
            rsync = new RequestSynchronizer();
            session.setAttribute(WEBKEY, (Object)rsync);
        }
        return rsync;
    }

    private synchronized boolean startNormalRequest(Handler handler) {
        if (this.currentThread == null) {
            this.logInfo("normal request");
            return true;
        }
        return false;
    }

    private synchronized void endNormalRequest() {
        this.currentThread = null;
    }

    private synchronized boolean startRecursiveRequest(Handler handler) {
        if (Thread.currentThread().equals(this.currentThread)) {
            this.logInfo("recursive request");
            return true;
        }
        return false;
    }

    private synchronized void endRecursiveRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Handler handler) throws Exception {
        if (handler.isBusyPage()) {
            handler.showBusyPage(false);
            this.logInfo("handle-busy-false");
            return;
        }
        if (this.startNormalRequest(handler)) {
            try {
                this.resultURI = handler.getResultURI();
                this.logInfo("handle-normal");
                handler.normalRequest();
            }
            finally {
                this.endNormalRequest();
            }
            this.resultURI = handler.getResultURI();
            return;
        }
        if (this.startRecursiveRequest(handler)) {
            try {
                this.logInfo("handle-recursive");
                handler.recursiveRequest();
            }
            finally {
                this.endRecursiveRequest();
            }
            return;
        }
        this.logInfo("handle-busy-true");
        handler.showBusyPage(true);
    }

    public String getResultURI() {
        return this.resultURI;
    }

    private void logInfo(String id) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Log " + id + " Thread = " + Thread.currentThread().getName() + ", resultURI = " + this.resultURI + ", currentThread = " + this.currentThread));
        }
    }

    public static interface Handler {
        public void normalRequest() throws Exception;

        public void recursiveRequest() throws Exception;

        public void showBusyPage(boolean var1) throws Exception;

        public String getResultURI();

        public boolean isBusyPage();
    }
}

