/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.form;

import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentTag;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.form.FormDocument;
import com.tonbeller.wcf.utils.ResourceLocator;
import com.tonbeller.wcf.utils.XmlUtils;
import com.tonbeller.wcf.wizard.WizardComponent;
import com.tonbeller.wcf.wizard.WizardComponentTag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class FormComponentTag
extends ComponentTag {
    String xmlUri;
    String model;
    boolean bookmarkable = false;
    boolean finishButton = true;
    String bundle;
    private static Logger logger = Logger.getLogger((Class)FormComponentTag.class);

    public Component createComponent(RequestContext context) throws JspException {
        try {
            Document doc = this.parseDocument(context, this.getXmlUri());
            Object bean = null;
            if (this.model != null) {
                bean = context.getModelReference(this.model);
            }
            FormComponent fc = this.createFormComponent(context, this.id, doc, bean);
            fc.setBookmarkable(this.bookmarkable);
            fc.setFinishButton(this.finishButton);
            this.registerWithWizard(fc);
            return fc;
        }
        catch (MalformedURLException e) {
            logger.error(null, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    private void registerWithWizard(FormComponent fc) {
        WizardComponentTag wt = (WizardComponentTag)FormComponentTag.findAncestorWithClass((Tag)this, (Class)WizardComponentTag.class);
        if (wt == null) {
            return;
        }
        WizardComponent wc = (WizardComponent)wt.getComponent();
        wc.addPage(fc);
    }

    protected FormComponent createFormComponent(RequestContext context, String id, Document doc, Object bean) {
        return new FormComponent(id, null, doc, bean);
    }

    protected Document parseDocument(RequestContext context, String xmlUri) throws MalformedURLException, MissingResourceException {
        Locale loc = context.getLocale();
        URL url = ResourceLocator.getResource(context.getServletContext(), loc, xmlUri);
        Document document = XmlUtils.parse(url);
        FormDocument.replaceI18n(context, document, this.getBundle());
        return document;
    }

    public String getXmlUri() {
        return this.xmlUri;
    }

    public void setXmlUri(String xmlUri) {
        this.xmlUri = xmlUri;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setBookmarkable(boolean b) {
        this.bookmarkable = b;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(boolean finishButton) {
        this.finishButton = finishButton;
    }

    public String getBundle() {
        return this.bundle;
    }
}

