/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.cda;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryEntry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.ui.datasources.cda.Messages;

public class QueriesTableModel
extends AbstractTableModel
implements Cloneable {
    private ArrayList<QueryData> queries = new ArrayList();

    public Object clone() {
        try {
            QueriesTableModel queriestablemodel = (QueriesTableModel)super.clone();
            queriestablemodel.queries = (ArrayList)this.queries.clone();
            return queriestablemodel;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    public void add(QueryData query) {
        if (this.queries.contains(query)) {
            throw new IllegalStateException();
        }
        this.queries.add(query);
        this.fireTableDataChanged();
    }

    public int size() {
        return this.queries.size();
    }

    public QueryData get(int index) {
        return this.queries.get(index);
    }

    public QueryData getQueryById(String name) {
        for (QueryData query : this.queries) {
            if (!ObjectUtilities.equal((Object)name, (Object)query.getQueryEntry().getId())) continue;
            return query;
        }
        return null;
    }

    public void clear() {
        this.queries.clear();
        this.fireTableDataChanged();
    }

    public String getName(int row) {
        return (String)this.getValueAt(row, 0);
    }

    public String getQuery(int row) {
        return (String)this.getValueAt(row, 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString("QueriesTableModel.Query", new Object[0]);
        }
        if (column == 1) {
            return Messages.getString("QueriesTableModel.CdaId", new Object[0]);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.queries.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        QueryData queryData = this.queries.get(rowIndex);
        CdaQueryEntry query = queryData.getQueryEntry();
        if (columnIndex == 0) {
            return query.getName();
        }
        if (columnIndex == 1) {
            return query.getId();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        QueryData queryData = this.queries.get(rowIndex);
        CdaQueryEntry query = queryData.getQueryEntry();
        if (columnIndex == 0) {
            query.setName((String)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public static class QueryData {
        private CdaQueryEntry queryEntry;
        private String[] declaredParameter;

        public QueryData(CdaQueryEntry queryEntry, String[] declaredParameter) {
            if (queryEntry == null) {
                throw new NullPointerException();
            }
            this.queryEntry = queryEntry;
            this.declaredParameter = declaredParameter;
        }

        public CdaQueryEntry getQueryEntry() {
            return this.queryEntry;
        }

        public String[] getDeclaredParameter() {
            return this.declaredParameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryData queryData = (QueryData)o;
            return this.queryEntry.equals((Object)queryData.queryEntry);
        }

        public int hashCode() {
            return this.queryEntry != null ? this.queryEntry.hashCode() : 0;
        }
    }
}

