/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.handlers;

import com.amazonaws.AmazonClientException;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.util.ClassLoaderHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainFactory {
    public List<RequestHandler2> newRequestHandlerChain(String resource) {
        return this.createRequestHandlerChain(resource, RequestHandler.class);
    }

    public List<RequestHandler2> newRequestHandler2Chain(String resource) {
        return this.createRequestHandlerChain(resource, RequestHandler2.class);
    }

    private List<RequestHandler2> createRequestHandlerChain(String resource, Class<?> handlerApiClass) {
        ArrayList<RequestHandler2> handlers;
        block17: {
            handlers = new ArrayList<RequestHandler2>();
            BufferedReader reader = null;
            try {
                String requestHandlerClassName;
                block18: {
                    InputStream input = this.getClass().getResourceAsStream(resource);
                    if (input == null) {
                        ArrayList<RequestHandler2> arrayList = handlers;
                        return arrayList;
                    }
                    reader = new BufferedReader(new InputStreamReader(input));
                    while (true) {
                        Object h;
                        if ((requestHandlerClassName = reader.readLine()) == null) {
                            break block17;
                        }
                        if ((requestHandlerClassName = requestHandlerClassName.trim()).equals("")) continue;
                        Class<?> requestHandlerClass = ClassLoaderHelper.loadClass(requestHandlerClassName, handlerApiClass, this.getClass());
                        Object requestHandlerObject = requestHandlerClass.newInstance();
                        if (!handlerApiClass.isInstance(requestHandlerObject)) break block18;
                        if (handlerApiClass == RequestHandler2.class) {
                            h = (RequestHandler2)requestHandlerObject;
                            handlers.add((RequestHandler2)h);
                            continue;
                        }
                        if (handlerApiClass != RequestHandler.class) break;
                        h = (RequestHandler)requestHandlerObject;
                        handlers.add(RequestHandler2.adapt((RequestHandler)h));
                    }
                    throw new IllegalStateException();
                }
                throw new AmazonClientException("Unable to instantiate request handler chain for client.  Listed request handler ('" + requestHandlerClassName + "') " + "does not implement the " + handlerApiClass + " API.");
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to instantiate request handler chain for client: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return handlers;
    }
}

