/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.core;

import com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncTaskInfo {
    private final StackTraceElement[] asyncStackTrace;
    private final boolean daemon;
    private final Promise<?>[] waitingFor;
    private final String name;

    public AsyncTaskInfo(String name, StackTraceElement[] asyncStackTrace, boolean daemon, Promise<?>[] waitFor) {
        this.name = name;
        this.asyncStackTrace = asyncStackTrace;
        this.daemon = daemon;
        this.waitingFor = waitFor;
    }

    public String getName() {
        return this.name;
    }

    public StackTraceElement[] getAsyncStackTrace() {
        return this.asyncStackTrace;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public Promise<?>[] getWaitingFor() {
        return this.waitingFor;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.name != null) {
            result.append("\"");
            result.append(this.name);
            result.append("\"");
        }
        if (this.daemon) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append("daemon");
        }
        if (this.waitingFor != null) {
            HashMap<Integer, String> waitingOnArguments = new HashMap<Integer, String>();
            for (int i = 0; i < this.waitingFor.length; ++i) {
                Promise<?> promise = this.waitingFor[i];
                if (promise == null || promise.isReady()) continue;
                if (promise instanceof AndPromise) {
                    AndPromise andPromise = (AndPromise)promise;
                    Promise[] elements = andPromise.getValues();
                    StringBuilder description = new StringBuilder();
                    description.append("PromiseCollection[");
                    boolean first = true;
                    for (int j = 0; j < elements.length; ++j) {
                        Promise e = elements[j];
                        if (e == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            description.append(" ");
                        }
                        description.append(j);
                        String d = e.getDescription();
                        if (d == null) continue;
                        description.append(":\"");
                        description.append(d);
                        description.append("\"");
                    }
                    description.append("]");
                    waitingOnArguments.put(i + 1, description.toString());
                    continue;
                }
                String quotedDescription = promise.getDescription() == null ? null : "\"" + promise.getDescription() + "\"";
                waitingOnArguments.put(i + 1, quotedDescription);
            }
            if (waitingOnArguments.size() > 0) {
                if (result.length() > 0) {
                    result.append(" ");
                }
                result.append("waiting on argument");
                if (waitingOnArguments.size() > 1) {
                    result.append("s");
                }
                result.append(" (starting from 1)");
                for (Map.Entry pair : waitingOnArguments.entrySet()) {
                    result.append(" ");
                    result.append(pair.getKey());
                    String description = (String)pair.getValue();
                    if (description == null) continue;
                    result.append(":");
                    result.append(description);
                }
            }
        }
        if (result.length() > 0) {
            result.append("\n");
        }
        if (this.asyncStackTrace != null) {
            for (int i = 0; i < this.asyncStackTrace.length; ++i) {
                result.append("\tat ");
                result.append(this.asyncStackTrace[i]);
                result.append("\n");
            }
        } else {
            result.append("Async Trace is Disabled.");
        }
        return result.toString();
    }
}

