/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul;

import java.awt.Component;
import java.awt.Window;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.libraries.designtime.swing.settings.DefaultLocaleSettings;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class DefaultWizardDesignTimeContext
implements DesignTimeContext {
    private static final Log logger = LogFactory.getLog(DefaultWizardDesignTimeContext.class);
    private WizardEditorModel editorModel;
    private Window parentWindow;
    private DesignTimeContext parentContext;
    private LocaleSettings localeSettings;

    public DefaultWizardDesignTimeContext(WizardEditorModel editorModel, Window parentWindow) {
        this(editorModel, parentWindow, null);
    }

    public DefaultWizardDesignTimeContext(WizardEditorModel editorModel, Window parentWindow, DesignTimeContext parentContext) {
        this.editorModel = editorModel;
        this.parentWindow = parentWindow;
        this.parentContext = parentContext;
        this.localeSettings = parentContext != null ? parentContext.getLocaleSettings() : new DefaultLocaleSettings();
    }

    public LocaleSettings getLocaleSettings() {
        return this.localeSettings;
    }

    public AbstractReportDefinition getReport() {
        return this.editorModel.getReportDefinition();
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public DataSchemaModel getDataSchemaModel() {
        return this.editorModel.getDataSchema();
    }

    public void error(Exception e) {
        ExceptionDialog.showExceptionDialog((Component)this.parentWindow, (String)"Error", (String)e.getMessage(), (Exception)e);
        logger.error((Object)"Context received fatal error", (Throwable)e);
    }

    public void userError(Exception e) {
        ExceptionDialog.showExceptionDialog((Component)this.parentWindow, (String)"Non-Fatal Error", (String)e.getMessage(), (Exception)e);
        logger.info((Object)"Context received user error", (Throwable)e);
    }

    public boolean isShowExpertItems() {
        if (this.parentContext != null) {
            return this.parentContext.isShowExpertItems();
        }
        return true;
    }

    public boolean isShowDeprecatedItems() {
        if (this.parentContext != null) {
            return this.parentContext.isShowDeprecatedItems();
        }
        return true;
    }

    public DataFactoryContext getDataFactoryContext() {
        if (this.parentContext != null) {
            return this.parentContext.getDataFactoryContext();
        }
        return new DesignTimeDataFactoryContext();
    }

    public MaturityLevel getMaturityLevel() {
        return this.parentContext.getMaturityLevel();
    }
}

