/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul.components;

import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.Messages;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulImage;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;

public abstract class AbstractWizardStep
extends XulEventSourceAdapter
implements WizardStep {
    protected static final Messages messages = Messages.getInstance();
    public static final String VALID_PROPERTY_NAME = "valid";
    public static final String PREVIEWABLE_PROPERTY_NAME = "previewable";
    public static final String FINISHABLE_PROPERTY_NAME = "finishable";
    public static final String STEP_CONTAINER = "step_container";
    public static final String XUL_HBOX_TYPE = "hbox";
    public static final String XUL_IMAGE_TYPE = "image";
    public static final String XUL_LABEL_TYPE = "label";
    public static final String STEP_IMAGE_SRC = "images/24x24_chevron_green.png";
    public static final String SPACER_IMAGE_SRC = "images/empty_spacer.png";
    private boolean valid;
    private boolean previewable;
    private boolean finishable;
    private WizardEditorModel editorModel;
    private DesignTimeContext designTimeContext;
    private BindingFactory bf;
    private Document document;
    private XulImage stepImage;
    private XulLabel stepLabel;

    protected AbstractWizardStep() {
    }

    public DataAttributeContext getAttributeContext() {
        return this.editorModel.getAttributeContext();
    }

    public void setEditorModel(WizardEditorModel editorModel) {
        this.editorModel = editorModel;
    }

    public WizardEditorModel getEditorModel() {
        return this.editorModel;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        boolean oldValid = this.valid;
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY_NAME, oldValid, this.valid);
    }

    @Override
    public void setPreviewable(boolean previewable) {
        boolean oldValue = this.previewable;
        this.previewable = previewable;
        this.firePropertyChange(PREVIEWABLE_PROPERTY_NAME, oldValue, this.previewable);
    }

    @Override
    public boolean isPreviewable() {
        return this.previewable;
    }

    @Override
    public void setFinishable(boolean finishable) {
        boolean oldValue = this.finishable;
        this.finishable = finishable;
        this.firePropertyChange(FINISHABLE_PROPERTY_NAME, oldValue, this.finishable);
    }

    @Override
    public boolean isFinishable() {
        return this.isPreviewable();
    }

    @Override
    public void setDesignTimeContext(DesignTimeContext designTimeContext) {
        this.designTimeContext = designTimeContext;
    }

    public DesignTimeContext getDesignTimeContext() {
        return this.designTimeContext;
    }

    @Override
    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        XulVbox stepContainer = (XulVbox)mainWizardContainer.getDocumentRoot().getElementById(STEP_CONTAINER);
        XulHbox row = (XulHbox)mainWizardContainer.getDocumentRoot().createElement(XUL_HBOX_TYPE);
        this.stepImage = (XulImage)mainWizardContainer.getDocumentRoot().createElement(XUL_IMAGE_TYPE);
        this.stepImage.setSrc(STEP_IMAGE_SRC);
        this.stepImage.setId(this.getStepName());
        this.stepImage.setVisible(false);
        row.addChild((Element)this.stepImage);
        this.stepLabel = (XulLabel)mainWizardContainer.getDocumentRoot().createElement(XUL_LABEL_TYPE);
        this.stepLabel.setValue(this.getStepName());
        this.stepLabel.setFlex(1);
        this.stepLabel.setDisabled(true);
        row.addChild((Element)this.stepLabel);
        stepContainer.addChild((Element)row);
    }

    @Override
    public void stepActivating() {
        this.stepImage.setVisible(true);
        this.stepLabel.setDisabled(false);
        DebugLog.log((Object)("Activating: Step - " + this.getStepName()));
    }

    @Override
    public boolean stepDeactivating() {
        DebugLog.log((Object)("Deactivating: Step - " + this.getStepName()));
        this.stepImage.setVisible(false);
        this.stepLabel.setDisabled(true);
        return true;
    }
}

