/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db.netezza;

import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.io.NamedFifo;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaJDBCStatementRunner;
import org.apache.sqoop.util.PerfCounters;
import org.apache.sqoop.util.TaskId;

public abstract class NetezzaExternalTableImportMapper<K, V>
extends AutoProgressMapper<Integer, NullWritable, K, V> {
    private Configuration conf;
    private DBConfiguration dbc;
    private File fifoFile;
    private int numMappers;
    private Connection con;
    private BufferedReader recordReader;
    public static final Log LOG = LogFactory.getLog((String)NetezzaExternalTableImportMapper.class.getName());
    private NetezzaJDBCStatementRunner extTableThread;
    private PerfCounters counter;
    private File taskAttemptDir = null;

    private String getSqlStatement(int myId) throws IOException {
        char fd = (char)this.conf.getInt("sqoop.output.field.delim", 44);
        char qc = (char)this.conf.getInt("sqoop.output.enclosed.by", 0);
        char ec = (char)this.conf.getInt("sqoop.output.escaped.by", 0);
        String nullValue = this.conf.get("netezza.exttable.null.value");
        int errorThreshold = this.conf.getInt("netezza.error.threshold", 1);
        String logDir = this.conf.get("netezza.log.dir");
        String[] cols = this.dbc.getInputFieldNames();
        String inputConds = this.dbc.getInputConditions();
        StringBuilder sqlStmt = new StringBuilder(2048);
        sqlStmt.append("CREATE EXTERNAL TABLE '");
        sqlStmt.append(this.fifoFile.getAbsolutePath());
        sqlStmt.append("' USING (REMOTESOURCE 'JDBC' ");
        sqlStmt.append(" BOOLSTYLE 'T_F' ");
        sqlStmt.append(" CRINSTRING FALSE ");
        sqlStmt.append(" DELIMITER ");
        sqlStmt.append(Integer.toString(fd));
        sqlStmt.append(" ENCODING 'internal' ");
        if (ec > '\u0000') {
            sqlStmt.append(" ESCAPECHAR '\\' ");
        }
        sqlStmt.append(" FORMAT 'Text' ");
        sqlStmt.append(" INCLUDEZEROSECONDS TRUE ");
        sqlStmt.append(" NULLVALUE '");
        if (nullValue != null) {
            sqlStmt.append(nullValue);
        } else {
            sqlStmt.append("null");
        }
        sqlStmt.append("' ");
        if (qc > '\u0000') {
            switch (qc) {
                case '\'': {
                    sqlStmt.append(" QUOTEDVALUE SINGLE ");
                    break;
                }
                case '\"': {
                    sqlStmt.append(" QUOTEDVALUE DOUBLE ");
                    break;
                }
                default: {
                    LOG.warn((Object)("Unsupported enclosed by character: " + qc + " - ignoring."));
                }
            }
        }
        sqlStmt.append(" MAXERRORS ").append(errorThreshold);
        sqlStmt.append(") AS SELECT ");
        if (cols == null || cols.length == 0) {
            sqlStmt.append('*');
        } else {
            sqlStmt.append(cols[0]).append(' ');
            for (int i = 1; i < cols.length; ++i) {
                sqlStmt.append(',').append(cols[i]);
            }
        }
        sqlStmt.append(" FROM ").append(this.dbc.getInputTableName()).append(' ');
        sqlStmt.append("WHERE (DATASLICEID % ");
        sqlStmt.append(this.numMappers).append(") = ").append(myId);
        if (inputConds != null && inputConds.length() > 0) {
            sqlStmt.append(" AND ( ").append(inputConds).append(')');
        }
        String stmt = sqlStmt.toString();
        LOG.debug((Object)("SQL generated for external table import for data slice " + myId + "=" + stmt));
        return stmt;
    }

    private void initNetezzaExternalTableImport(int myId) throws IOException {
        NamedFifo nf;
        this.taskAttemptDir = TaskId.getLocalWorkPath(this.conf);
        this.fifoFile = new File(this.taskAttemptDir, "nzexttable-" + myId + ".txt");
        String filename = this.fifoFile.toString();
        try {
            nf = new NamedFifo(this.fifoFile);
            nf.create();
        }
        catch (IOException ioe) {
            LOG.error((Object)("Could not create FIFO file " + filename));
            this.fifoFile = null;
            throw new IOException("Could not create FIFO for netezza external table import", ioe);
        }
        String sqlStmt = this.getSqlStatement(myId);
        boolean cleanup = false;
        try {
            this.con = this.dbc.getConnection();
            this.extTableThread = new NetezzaJDBCStatementRunner(Thread.currentThread(), this.con, sqlStmt);
        }
        catch (SQLException sqle) {
            cleanup = true;
            throw new IOException(sqle);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            if (this.con != null && cleanup) {
                try {
                    this.con.close();
                }
                catch (Exception e) {
                    LOG.debug((Object)("Exception closing connection " + e.getMessage()));
                }
            }
            this.con = null;
        }
        this.extTableThread.start();
        String encoding = this.conf.get("netezza.table.encoding");
        this.recordReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nf.getFile()), null == encoding ? "UTF-8" : encoding));
    }

    protected abstract void writeRecord(Text var1, Mapper.Context var2) throws IOException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(Integer dataSliceId, NullWritable val, Mapper.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.dbc = new DBConfiguration(this.conf);
        this.numMappers = ConfigurationHelper.getConfNumMaps(this.conf);
        char rd = (char)this.conf.getInt("sqoop.output.record.delim", 10);
        this.initNetezzaExternalTableImport(dataSliceId);
        this.counter = new PerfCounters();
        this.counter.startClock();
        Text outputRecord = new Text();
        if (this.extTableThread.isAlive()) {
            try {
                String inputRecord = this.recordReader.readLine();
                while (inputRecord != null) {
                    if (Thread.interrupted() && !this.extTableThread.isAlive()) {
                        break;
                    }
                    outputRecord.set(inputRecord + rd);
                    this.writeRecord(outputRecord, context);
                    this.counter.addBytes(1 + inputRecord.length());
                    inputRecord = this.recordReader.readLine();
                }
            }
            finally {
                this.recordReader.close();
                this.extTableThread.join();
                this.counter.stopClock();
                LOG.info((Object)("Transferred " + this.counter.toString()));
                if (this.extTableThread.hasExceptions()) {
                    this.extTableThread.printException();
                    throw new IOException(this.extTableThread.getException());
                }
            }
        }
    }
}

