/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public abstract class AbstractSecurityExpressionHandler<T>
implements SecurityExpressionHandler<T>,
ApplicationContextAware {
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private BeanResolver br;
    private ApplicationContext context;
    private RoleHierarchy roleHierarchy;
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();
    private boolean roleHierarchySet = false;
    private boolean permissionEvaluatorSet = false;

    @Override
    public final ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public final void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"expressionParser cannot be null");
        this.expressionParser = expressionParser;
    }

    @Override
    public final EvaluationContext createEvaluationContext(Authentication authentication, T invocation) {
        SecurityExpressionOperations root = this.createSecurityExpressionRoot(authentication, invocation);
        StandardEvaluationContext ctx = this.createEvaluationContextInternal(authentication, invocation);
        ctx.setBeanResolver(this.br);
        ctx.setRootObject((Object)root);
        return ctx;
    }

    protected StandardEvaluationContext createEvaluationContextInternal(Authentication authentication, T invocation) {
        return new StandardEvaluationContext();
    }

    protected abstract SecurityExpressionOperations createSecurityExpressionRoot(Authentication var1, T var2);

    private boolean roleHerarchyNotSetForValidContext() {
        return !this.roleHierarchySet && this.context != null;
    }

    protected RoleHierarchy getRoleHierarchy() {
        if (this.roleHerarchyNotSetForValidContext()) {
            RoleHierarchy contextRoleHierarchy = this.getSingleBeanOrNull(RoleHierarchy.class);
            if (contextRoleHierarchy != null) {
                this.roleHierarchy = contextRoleHierarchy;
            }
            this.roleHierarchySet = true;
        }
        return this.roleHierarchy;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchySet = true;
        this.roleHierarchy = roleHierarchy;
    }

    protected PermissionEvaluator getPermissionEvaluator() {
        if (!this.permissionEvaluatorSet && this.context != null) {
            PermissionEvaluator contextPermissionEvaluator = this.getSingleBeanOrNull(PermissionEvaluator.class);
            if (contextPermissionEvaluator != null) {
                this.permissionEvaluator = contextPermissionEvaluator;
            }
            this.permissionEvaluatorSet = true;
        }
        return this.permissionEvaluator;
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        this.permissionEvaluatorSet = true;
        this.permissionEvaluator = permissionEvaluator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.br = new BeanFactoryResolver((BeanFactory)applicationContext);
        this.context = applicationContext;
    }

    private <T> T getSingleBeanOrNull(Class<T> type) {
        String[] beanNamesForType = this.context.getBeanNamesForType(type);
        if (beanNamesForType == null || beanNamesForType.length != 1) {
            return null;
        }
        return (T)this.context.getBean(beanNamesForType[0], type);
    }
}

