/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class Messages {
    private static final Log logger = LogFactory.getLog(Messages.class);
    private static final Map<Locale, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());

    private static ResourceBundle getBundle() {
        Locale locale = CdfEngine.getEnvironment().getLocale();
        ResourceBundle bundle = locales.get(locale);
        if (bundle == null) {
            try {
                IReadAccess access = CdfEngine.getPluginSystemReader(null);
                if (access.fileExists(" messages.properties")) {
                    InputStream in = access.getFileInputStream(" messages.properties");
                    bundle = new PropertyResourceBundle(in);
                    locales.put(locale, bundle);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not get localization bundle", (Throwable)e);
            }
        }
        return bundle;
    }

    public static String getEncodedString(String rawValue) {
        if (rawValue == null) {
            return "";
        }
        StringBuffer value = new StringBuffer();
        for (int n = 0; n < rawValue.length(); ++n) {
            char charValue = rawValue.charAt(n);
            if (charValue >= '\u0080') {
                value.append("&#x");
                value.append(Integer.toString(charValue, 16));
                value.append(";");
                continue;
            }
            value.append(charValue);
        }
        return value.toString();
    }

    public static String getXslString(String key) {
        String rawValue = Messages.getString(key);
        return Messages.getEncodedString(rawValue);
    }

    public static String getString(String key) {
        try {
            return Messages.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String param1) {
        return Messages.getString(Messages.getBundle(), key, param1);
    }

    public static String getString(String key, String param1, String param2) {
        return Messages.getString(Messages.getBundle(), key, param1, param2);
    }

    public static String getString(String key, String param1, String param2, String param3) {
        return Messages.getString(Messages.getBundle(), key, param1, param2, param3);
    }

    public static String getString(String key, String param1, String param2, String param3, String param4) {
        return Messages.getString(Messages.getBundle(), key, param1, param2, param3, param4);
    }

    public static String getErrorString(String key) {
        return Messages.formatErrorMessage(key, Messages.getString(key));
    }

    public static String getErrorString(String key, String param1) {
        return Messages.getErrorString(Messages.getBundle(), key, param1);
    }

    public static String getErrorString(String key, String param1, String param2) {
        return Messages.getErrorString(Messages.getBundle(), key, param1, param2);
    }

    public static String getErrorString(String key, String param1, String param2, String param3) {
        return Messages.getErrorString(Messages.getBundle(), key, param1, param2, param3);
    }

    private static String formatErrorMessage(String key, String msg) {
        int end = key.indexOf(".ERROR_");
        end = end < 0 ? key.length() : Math.min(end + ".ERROR_0000".length(), key.length());
        return key.substring(0, end) + " - " + msg;
    }

    private static String getString(ResourceBundle bundle, String key, Object ... params) {
        try {
            return MessageFormat.format(bundle.getString(key), params);
        }
        catch (Exception e) {
            return '!' + key + '!';
        }
    }

    private static String getErrorString(ResourceBundle bundle, String key, Object ... params) {
        return Messages.formatErrorMessage(key, Messages.getString(bundle, key, params));
    }
}

