/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.packager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.environment.packager.ICdfHeadersProvider;
import org.pentaho.cdf.packager.StaticDependenciesPackage;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.DependenciesPackage;
import pt.webdetails.cpf.packager.StringFilter;
import pt.webdetails.cpf.packager.dependencies.Dependency;
import pt.webdetails.cpf.packager.dependencies.FileDependency;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class CdfHeadersProvider
implements ICdfHeadersProvider {
    private static final String BASE_DIR = "";
    private static final String BASE_DEPENDENCIES = "resources.properties";
    private static final String CDF_DASHBOARD_DEPENDENCIES = "resources.cdf.dashboards.properties";
    private static final String SUFFIX_SCRIPT = ".script";
    private static final String SUFFIX_STYLE = ".link";
    private static final String SUFFIX_MAP = ".map";
    private static final String SUFFIX_IE8_STYLE = ".ie8link";
    private static final String SUFFIX_IE8_SCRIPT = ".ie8script";
    private static final String SUFFIX_IE8_SCRIPT_AFTER_STYLE = ".ie8scriptAfterLink";
    private static final String SUFFIX_IE8_SCRIPT_BEFORE_SCRIPT = ".ie8scriptBeforeScript";
    private static final String BASE_SCRIPTS_PROPERTY = "script";
    private static final String BASE_STYLES_PROPERTY = "link";
    private static final String BASE_STYLEMAP_PROPERTY = "map";
    private static final List<String> acceptedDashboardTypes = new ArrayList<String>(3);
    private static final String DEFAULT_DASHBOARD_TYPE = "blueprint";
    private Properties baseProperties;
    private Properties extraProperties;
    private List<? extends DependenciesPackage> extraIncludes;
    private Map<String, List<? extends DependenciesPackage>> dashboardIncludes = new HashMap<String, List<? extends DependenciesPackage>>();

    public CdfHeadersProvider() {
        IReadAccess reader = this.getContentAccess().getPluginSystemReader(BASE_DIR);
        this.baseProperties = new Properties();
        this.loadProperties(reader, BASE_DEPENDENCIES, this.baseProperties);
        this.extraProperties = this.loadProperties(reader, CDF_DASHBOARD_DEPENDENCIES, new Properties());
        PathSet pathSet = new PathSet();
        this.addCustomDependencies(pathSet, this.extraProperties);
        this.extraIncludes = this.createDependenciesPackages("cdf-dashboard", pathSet);
        for (String dashboardType : acceptedDashboardTypes) {
            try {
                this.dashboardIncludes.put(dashboardType, this.createDependenciesPackages(dashboardType));
            }
            catch (Exception e) {
                this.logError("Unable to load headers for " + dashboardType, e);
            }
        }
    }

    @Override
    public String getHeaders(String dashboardType, boolean isDebugMode, List<String> componentTypes) {
        return this.getHeaders(dashboardType, isDebugMode, null, componentTypes);
    }

    @Override
    public String getHeaders(String dashboardType, boolean isDebugMode, String absRoot, List<String> componentTypes) {
        if (!this.isAcceptedDashboardType(dashboardType)) {
            this.getLog().error((Object)(dashboardType + " is not a valid dashboard type. Defaulting to " + DEFAULT_DASHBOARD_TYPE));
            dashboardType = DEFAULT_DASHBOARD_TYPE;
        }
        StringBuilder deps = new StringBuilder();
        for (DependenciesPackage dependenciesPackage : this.getDependenciesPackages(dashboardType)) {
            deps.append(String.format("<!-- %s -->", dependenciesPackage.getName()));
            try {
                this.appendDependencies(deps, dependenciesPackage, !isDebugMode, absRoot);
            }
            catch (Exception e) {
                this.logError("Error with dependencies package '" + dependenciesPackage.getName() + "'.", e);
            }
        }
        if (componentTypes != null && !componentTypes.isEmpty()) {
            for (DependenciesPackage dependenciesPackage : this.extraIncludes) {
                deps.append(String.format("<!-- %s -->", dependenciesPackage.getName()));
                ArrayList<String> filePaths = new ArrayList<String>(componentTypes.size());
                switch (dependenciesPackage.getType()) {
                    case JS: {
                        String[] value;
                        String tmp;
                        for (String name : componentTypes) {
                            tmp = name.concat(SUFFIX_IE8_SCRIPT_BEFORE_SCRIPT);
                            if (this.extraProperties.containsKey(tmp)) {
                                value = this.extraProperties.getProperty(tmp).split(",");
                                filePaths.addAll(Arrays.asList(value));
                            }
                            if (this.extraProperties.containsKey(tmp = name.concat(SUFFIX_SCRIPT))) {
                                value = this.extraProperties.getProperty(tmp).split(",");
                                filePaths.addAll(Arrays.asList(value));
                            }
                            if (this.extraProperties.containsKey(tmp = name.concat(SUFFIX_IE8_SCRIPT))) {
                                value = this.extraProperties.getProperty(tmp).split(",");
                                filePaths.addAll(Arrays.asList(value));
                            }
                            if (!this.extraProperties.containsKey(tmp = name.concat(SUFFIX_IE8_SCRIPT_AFTER_STYLE))) continue;
                            value = this.extraProperties.getProperty(tmp).split(",");
                            filePaths.addAll(Arrays.asList(value));
                        }
                        break;
                    }
                    case CSS: {
                        String[] value;
                        String tmp;
                        for (String name : componentTypes) {
                            tmp = name.concat(SUFFIX_STYLE);
                            if (this.extraProperties.containsKey(tmp)) {
                                value = this.extraProperties.getProperty(tmp).split(",");
                                filePaths.addAll(Arrays.asList(value));
                            }
                            if (!this.extraProperties.containsKey(tmp = name.concat(SUFFIX_IE8_STYLE))) continue;
                            value = this.extraProperties.getProperty(tmp).split(",");
                            filePaths.addAll(Arrays.asList(value));
                        }
                        break;
                    }
                }
                if (filePaths.isEmpty()) continue;
                this.appendDependencies(deps, dependenciesPackage, false, absRoot, filePaths);
            }
        }
        return deps.toString();
    }

    protected void appendDependencies(StringBuilder deps, DependenciesPackage pkg, boolean minify, String absRoot, ArrayList<String> files) {
        if (absRoot != null) {
            AbsolutizingStringFilter filter = new AbsolutizingStringFilter(absRoot, pkg.getDefaultFilter());
            deps.append(pkg.getDependencies((StringFilter)filter, minify, (DependenciesPackage.IDependencyInclusionFilter)new CdfDependencyInclusionFilter(files)));
        } else {
            deps.append(pkg.getDependencies(minify, (DependenciesPackage.IDependencyInclusionFilter)new CdfDependencyInclusionFilter(files)));
        }
    }

    protected void appendDependencies(StringBuilder deps, DependenciesPackage pkg, boolean minify, String absRoot) {
        if (absRoot != null) {
            AbsolutizingStringFilter filter = new AbsolutizingStringFilter(absRoot, pkg.getDefaultFilter());
            deps.append(pkg.getDependencies((StringFilter)filter, minify));
        } else {
            deps.append(pkg.getDependencies(minify));
        }
    }

    private static List<String> getProperty(Properties properties, String propertyName) {
        return Arrays.asList(properties.getProperty(propertyName, BASE_DIR).split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(IReadAccess reader, String filePath, Properties properties) {
        InputStream propertiesFile;
        block5: {
            propertiesFile = null;
            try {
                if (!reader.fileExists(filePath)) {
                    this.getLog().warn((Object)String.format("Dependencies file %s not found.", filePath));
                    break block5;
                }
                propertiesFile = reader.getFileInputStream(filePath);
                properties.load(propertiesFile);
            }
            catch (Exception e) {
                try {
                    this.logError(String.format("Error reading resource definitions form file %s.", filePath), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(propertiesFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)propertiesFile);
            }
        }
        IOUtils.closeQuietly((InputStream)propertiesFile);
        return properties;
    }

    private Iterable<? extends DependenciesPackage> getDependenciesPackages(String dashboardType) {
        if (!this.dashboardIncludes.containsKey(dashboardType)) {
            this.getLog().error((Object)("Dependencies for type " + dashboardType + " were not loaded correctly."));
            return Collections.emptyList();
        }
        return this.dashboardIncludes.get(dashboardType);
    }

    private boolean isAcceptedDashboardType(String dashboardType) {
        return acceptedDashboardTypes.contains(dashboardType);
    }

    private List<StaticDependenciesPackage> createDependenciesPackages(String dashboardType) {
        IReadAccess reader = this.getContentAccess().getPluginSystemReader(BASE_DIR);
        String fileName = String.format("resources.%s.properties", dashboardType);
        Properties dtProperties = new Properties(this.getBaseProperties());
        if (reader.fileExists(fileName)) {
            this.loadProperties(reader, fileName, dtProperties);
        }
        PathSet pathSet = new PathSet();
        this.addBaseDependencies(pathSet, dtProperties);
        this.addCustomDependencies(pathSet, dtProperties);
        return this.createDependenciesPackages(dashboardType, pathSet);
    }

    private Properties getBaseProperties() {
        return this.baseProperties;
    }

    private void addBaseDependencies(PathSet pathSet, Properties properties) {
        pathSet.scripts.addAll(CdfHeadersProvider.getProperty(properties, BASE_SCRIPTS_PROPERTY));
        pathSet.styles.addAll(CdfHeadersProvider.getProperty(properties, BASE_STYLES_PROPERTY));
        pathSet.styleMaps.addAll(CdfHeadersProvider.getProperty(properties, BASE_STYLEMAP_PROPERTY));
    }

    private void addCustomDependencies(PathSet pathSet, Properties properties) {
        for (String name : properties.stringPropertyNames()) {
            if (name.endsWith(SUFFIX_IE8_SCRIPT_BEFORE_SCRIPT)) {
                pathSet.ie8ScriptsBeforeScripts.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.endsWith(SUFFIX_SCRIPT)) {
                pathSet.scripts.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.endsWith(SUFFIX_IE8_SCRIPT)) {
                pathSet.ie8Scripts.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.endsWith(SUFFIX_STYLE)) {
                pathSet.styles.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.endsWith(SUFFIX_MAP)) {
                pathSet.styleMaps.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.endsWith(SUFFIX_IE8_STYLE)) {
                pathSet.ie8Styles.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.endsWith(SUFFIX_IE8_SCRIPT_AFTER_STYLE)) {
                pathSet.ie8ScriptsAfterStyles.addAll(CdfHeadersProvider.getProperty(properties, name));
                continue;
            }
            if (name.equals(BASE_SCRIPTS_PROPERTY) || name.equals(BASE_STYLES_PROPERTY)) continue;
            this.getLog().error((Object)String.format("Type of include property '%s' not recognized. Property name must end in one of ( '%s' )", name, StringUtils.join((Object[])new String[]{SUFFIX_SCRIPT, SUFFIX_STYLE, SUFFIX_IE8_STYLE, SUFFIX_IE8_SCRIPT, SUFFIX_IE8_SCRIPT_AFTER_STYLE, SUFFIX_IE8_SCRIPT_BEFORE_SCRIPT}, (String)"', '")));
        }
    }

    private List<StaticDependenciesPackage> createDependenciesPackages(String pkgBaseName, PathSet pathSet) {
        Object name;
        ArrayList<StaticDependenciesPackage> dependencies = new ArrayList<StaticDependenciesPackage>();
        PathOrigin origin = this.getDefaultOrigin();
        String PKG_NAME = "cdf-%s-%s-includes";
        if (!pathSet.ie8ScriptsBeforeScripts.isEmpty()) {
            name = String.format("cdf-%s-%s-includes", pkgBaseName, "ie8scriptBeforeScript");
            dependencies.add(new IE8Dependencies((String)name, DependenciesPackage.PackageType.JS, this.getContentAccess(), this.getUrlProvider(), origin, pathSet.ie8ScriptsBeforeScripts));
        }
        if (!pathSet.scripts.isEmpty()) {
            name = String.format("cdf-%s-%s-includes", pkgBaseName, BASE_SCRIPTS_PROPERTY);
            dependencies.add(this.createDependencyPackage((String)name, DependenciesPackage.PackageType.JS, origin, pathSet.scripts));
        }
        if (!pathSet.ie8Scripts.isEmpty()) {
            name = String.format("cdf-%s-%s-includes", pkgBaseName, "ie8script");
            dependencies.add(new IE8Dependencies((String)name, DependenciesPackage.PackageType.JS, this.getContentAccess(), this.getUrlProvider(), origin, pathSet.ie8Scripts));
        }
        if (!pathSet.styles.isEmpty()) {
            name = String.format("cdf-%s-%s-includes", pkgBaseName, "style");
            dependencies.add(this.createDependencyPackage((String)name, DependenciesPackage.PackageType.CSS, origin, pathSet.styles));
        }
        if (!pathSet.styleMaps.isEmpty()) {
            for (String map : pathSet.styleMaps) {
                if (!StringUtils.isNotEmpty((String)map)) continue;
                dependencies.add(this.createStyleMap(map));
            }
        }
        if (!pathSet.ie8Styles.isEmpty()) {
            name = String.format("cdf-%s-%s-includes", pkgBaseName, "ie8style");
            dependencies.add(new IE8Dependencies((String)name, DependenciesPackage.PackageType.CSS, this.getContentAccess(), this.getUrlProvider(), origin, pathSet.ie8Styles));
        }
        if (!pathSet.ie8ScriptsAfterStyles.isEmpty()) {
            name = String.format("cdf-%s-%s-includes", pkgBaseName, "ie8scriptAfterLink");
            dependencies.add(new IE8Dependencies((String)name, DependenciesPackage.PackageType.JS, this.getContentAccess(), this.getUrlProvider(), origin, pathSet.ie8ScriptsAfterStyles));
        }
        return dependencies;
    }

    private StaticDependenciesPackage createStyleMap(String map) {
        return new StaticDependenciesPackage(FilenameUtils.getName((String)map), DependenciesPackage.PackageType.MAP, this.getContentAccess(), this.getUrlProvider(), this.getDefaultOrigin(), new String[]{map});
    }

    private PathOrigin getDefaultOrigin() {
        return new StaticSystemOrigin(BASE_DIR);
    }

    private StaticDependenciesPackage createDependencyPackage(String name, DependenciesPackage.PackageType pkgType, PathOrigin origin, List<String> fileNames) {
        return new StaticDependenciesPackage(name, pkgType, this.getContentAccess(), this.getUrlProvider(), origin, fileNames.toArray(new String[fileNames.size()]));
    }

    protected IUrlProvider getUrlProvider() {
        return PluginEnvironment.env().getUrlProvider();
    }

    protected IContentAccessFactory getContentAccess() {
        return PluginEnvironment.repository();
    }

    protected Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    protected void logError(String msg, Throwable error) {
        Log log = this.getLog();
        if (log.isDebugEnabled() && error != null) {
            log.error((Object)msg, error);
        } else {
            log.error((Object)msg);
        }
    }

    static {
        acceptedDashboardTypes.add(DEFAULT_DASHBOARD_TYPE);
        acceptedDashboardTypes.add("mobile");
        acceptedDashboardTypes.add("bootstrap");
        acceptedDashboardTypes.add("clean");
    }

    private static class IE8Dependencies
    extends StaticDependenciesPackage {
        public IE8Dependencies(String name, DependenciesPackage.PackageType type, IContentAccessFactory factory, IUrlProvider urlProvider, PathOrigin origin, List<String> fileList) {
            super(name, type, factory, urlProvider, origin, fileList.toArray(new String[fileList.size()]));
        }

        public String getDependencies(StringFilter format, boolean isPackaged) {
            StringBuilder include = new StringBuilder();
            include.append("<!--[if lte IE 8]>");
            include.append(super.getDependencies(format, false));
            include.append("<![endif]-->\n");
            return include.toString();
        }
    }

    private static class AbsolutizingStringFilter
    implements StringFilter {
        private StringFilter delegate;
        private String absRoot;

        public AbsolutizingStringFilter(String absRoot, StringFilter delegate) {
            assert (delegate != null);
            this.delegate = delegate;
            this.absRoot = absRoot;
        }

        public String filter(String input) {
            return this.delegate.filter(input, this.absRoot);
        }

        public String filter(String input, String absRoot) {
            return this.delegate.filter(input, absRoot);
        }
    }

    private static class PathSet {
        public List<String> ie8ScriptsBeforeScripts = new ArrayList<String>();
        public List<String> scripts = new ArrayList<String>();
        public List<String> styles = new ArrayList<String>();
        public List<String> styleMaps = new ArrayList<String>();
        public List<String> ie8Styles = new ArrayList<String>();
        public List<String> ie8Scripts = new ArrayList<String>();
        public List<String> ie8ScriptsAfterStyles = new ArrayList<String>();

        private PathSet() {
        }
    }

    private class CdfDependencyInclusionFilter
    implements DependenciesPackage.IDependencyInclusionFilter {
        private List<String> filePaths;

        public CdfDependencyInclusionFilter(List<String> filePaths) {
            this.filePaths = filePaths;
        }

        public boolean include(Dependency dependency) {
            if (this.filePaths == null) {
                return false;
            }
            for (String filePath : this.filePaths) {
                if (!dependency.getClass().isAssignableFrom(FileDependency.class) || !((FileDependency)dependency).getUrlFilePath().endsWith(filePath)) continue;
                return true;
            }
            return false;
        }
    }
}

