/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.render;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;

public class HtmlDashboardRenderer {
    private static final Log logger = LogFactory.getLog(HtmlDashboardRenderer.class);

    public static IBasicFile getDashboardTemplate(String solution, String path, String templateName) {
        templateName = FilenameUtils.separatorsToUnix((String)templateName);
        String fullTemplatePath = null;
        if (!StringUtils.isEmpty((String)templateName)) {
            fullTemplatePath = templateName.startsWith("/") ? templateName : Util.joinPath((String[])new String[]{solution, path, templateName});
        }
        return HtmlDashboardRenderer.getDashboardTemplate(fullTemplatePath);
    }

    public static IBasicFile getDashboardTemplate(String templatePath) {
        templatePath = FilenameUtils.separatorsToUnix((String)templatePath);
        IUserContentAccess repoAccess = CdfEngine.getUserContentReader(null);
        IReadAccess systemAccess = CdfEngine.getPluginSystemReader(null);
        IBasicFile dashboardTemplateFile = null;
        if (!StringUtils.isEmpty((String)templatePath) && repoAccess.fileExists(templatePath)) {
            if (repoAccess.hasAccess(templatePath, FileAccess.EXECUTE)) {
                dashboardTemplateFile = repoAccess.fetchFile(templatePath);
            } else {
                logger.error((Object)("Access Denied to " + templatePath));
            }
        } else {
            dashboardTemplateFile = systemAccess.fetchFile("default-dashboard-template.html");
        }
        return dashboardTemplateFile;
    }
}

