/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.render;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IUserContentAccess;
import pt.webdetails.cpf.utils.XmlDom4JUtils;

public class XcdfRenderer {
    private static final Log logger = LogFactory.getLog(XcdfRenderer.class);
    private static final String NODE_TEMPLATE = "/cdf/template";
    private static final String NODE_MESSAGES = "/cdf/messages";
    private static final String NODE_STYLES = "/cdf/style";
    private static final String NODE_REQUIRE = "/cdf/require";
    private String style;
    private String template;
    private String messagesBaseFilename;
    private boolean isRequire;

    public boolean determineDashboardTemplating(String solution, String path, String action, String defaultTemplate) throws InvalidCdfOperationException {
        return this.determineDashboardTemplating(FilenameUtils.separatorsToUnix((String)Util.joinPath((String[])new String[]{solution, path, action})), defaultTemplate);
    }

    public boolean determineDashboardTemplating(String dashboard, String defaultTemplate) throws InvalidCdfOperationException {
        boolean success = false;
        IUserContentAccess access = this.getUserContentAccess(null);
        if (access.fileExists(dashboard)) {
            if (!access.hasAccess(dashboard, FileAccess.EXECUTE)) {
                throw new InvalidCdfOperationException("Access denied");
            }
            try {
                Document doc = this.getDocument(access.fetchFile(dashboard));
                this.template = doc.selectSingleNode(NODE_TEMPLATE) != null ? this.getNodeText(NODE_TEMPLATE, (Node)doc, "") : defaultTemplate;
                if (doc.selectSingleNode(NODE_MESSAGES) != null) {
                    this.messagesBaseFilename = this.getNodeText(NODE_MESSAGES, (Node)doc);
                }
                this.style = doc.selectSingleNode(NODE_STYLES) != null ? this.getNodeText(NODE_STYLES, (Node)doc) : "mantle";
                success = true;
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new InvalidCdfOperationException(e);
            }
        }
        return success;
    }

    public boolean determineRequireDashboard(String solution, String path, String action) throws InvalidCdfOperationException {
        return this.determineRequireDashboard(FilenameUtils.separatorsToUnix((String)Util.joinPath((String[])new String[]{solution, path, action})));
    }

    public boolean determineRequireDashboard(String dashboard) throws InvalidCdfOperationException {
        boolean success = false;
        IUserContentAccess access = this.getUserContentAccess(null);
        if (access.fileExists(dashboard)) {
            if (!access.hasAccess(dashboard, FileAccess.EXECUTE)) {
                throw new InvalidCdfOperationException("Access denied");
            }
            try {
                Document doc = this.getDocument(access.fetchFile(dashboard));
                if (doc.selectSingleNode(NODE_REQUIRE) != null) {
                    this.isRequire = new Boolean(this.getNodeText(NODE_REQUIRE, (Node)doc, "false"));
                }
                success = true;
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new InvalidCdfOperationException(e);
            }
        }
        return success;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getStyle() {
        return this.style;
    }

    public String getMessagesBaseFilename() {
        return this.messagesBaseFilename;
    }

    public boolean getIsRequire() {
        return this.isRequire;
    }

    protected IUserContentAccess getUserContentAccess(String path) {
        return CdfEngine.getUserContentReader(path);
    }

    protected Document getDocument(IBasicFile file) throws IOException {
        return XmlDom4JUtils.getDocumentFromFile((IBasicFile)file);
    }

    protected String getNodeText(String xpath, Node node) {
        return XmlDom4JUtils.getNodeText((String)xpath, (Node)node, null);
    }

    protected String getNodeText(String xpath, Node node, String defaultValue) {
        return XmlDom4JUtils.getNodeText((String)xpath, (Node)node, (String)defaultValue);
    }
}

