/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;

public class ReplaceLabelsOnNodeRequestPBImpl
extends ReplaceLabelsOnNodeRequest {
    YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto proto = YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.getDefaultInstance();
    YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Map<NodeId, Set<String>> nodeIdToLabels;

    public ReplaceLabelsOnNodeRequestPBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.newBuilder();
    }

    public ReplaceLabelsOnNodeRequestPBImpl(YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void initNodeToLabels() {
        if (this.nodeIdToLabels != null) {
            return;
        }
        YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getNodeToLabelsList();
        this.nodeIdToLabels = new HashMap<NodeId, Set<String>>();
        for (YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto c : list) {
            this.nodeIdToLabels.put(new NodeIdPBImpl(c.getNodeId()), Sets.newHashSet((Iterable)c.getNodeLabelsList()));
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto.newBuilder((YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    private void addNodeToLabelsToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeToLabels();
        if (this.nodeIdToLabels == null) {
            return;
        }
        Iterable<YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto> iterable = new Iterable<YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto>(){

            @Override
            public Iterator<YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto> iterator() {
                return new Iterator<YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto>(){
                    Iterator<Map.Entry<NodeId, Set<String>>> iter;
                    {
                        this.iter = ReplaceLabelsOnNodeRequestPBImpl.this.nodeIdToLabels.entrySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto next() {
                        Map.Entry<NodeId, Set<String>> now = this.iter.next();
                        return YarnServerResourceManagerServiceProtos.NodeIdToLabelsNameProto.newBuilder().setNodeId(ReplaceLabelsOnNodeRequestPBImpl.this.convertToProtoFormat(now.getKey())).clearNodeLabels().addAllNodeLabels((Iterable)now.getValue()).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllNodeToLabels((Iterable)iterable);
    }

    private void mergeLocalToBuilder() {
        if (this.nodeIdToLabels != null) {
            this.addNodeToLabelsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public synchronized YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public Map<NodeId, Set<String>> getNodeToLabels() {
        this.initNodeToLabels();
        return this.nodeIdToLabels;
    }

    public void setNodeToLabels(Map<NodeId, Set<String>> map) {
        this.initNodeToLabels();
        this.nodeIdToLabels.clear();
        this.nodeIdToLabels.putAll(map);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ReplaceLabelsOnNodeRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }
}

