/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpitlite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.apps.cockpitlite.CockpitLite;
import org.jets3t.service.model.S3Object;

public class CLObjectTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 8570725021470237261L;
    private static final Log log = LogFactory.getLog(CLObjectTableModel.class);
    private ArrayList objectList = new ArrayList();
    private String usersPath = "";

    public CLObjectTableModel() {
        super(new String[]{"File", "Size", "Last Modified", "Public?"}, 0);
    }

    public void setUsersPath(String usersPath) {
        this.usersPath = usersPath;
    }

    private void sanitizeObjectKey(S3Object object) {
        if (object.getKey().startsWith(this.usersPath)) {
            object.setKey(object.getKey().substring(this.usersPath.length()));
        }
    }

    public int addObject(S3Object object) {
        this.sanitizeObjectKey(object);
        int insertRow = Collections.binarySearch(this.objectList, object, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((S3Object)o1).getKey().compareToIgnoreCase(((S3Object)o2).getKey());
            }
        });
        String aclStatus = null;
        if (insertRow >= 0) {
            aclStatus = (String)this.getValueAt(insertRow, 3);
            this.objectList.remove(insertRow);
            this.removeRow(insertRow);
        } else {
            insertRow = -insertRow - 1;
        }
        if (object.getAcl() != null || aclStatus == null) {
            aclStatus = CockpitLite.getAclDescription(object.getAcl());
        }
        this.objectList.add(insertRow, object);
        this.insertRow(insertRow, new Object[]{object.getKey(), new Long(object.getContentLength()), object.getLastModifiedDate(), aclStatus});
        return insertRow;
    }

    public int updateObjectAclStatus(S3Object objectWithAcl, String aclStatus) {
        this.sanitizeObjectKey(objectWithAcl);
        int updateRow = Collections.binarySearch(this.objectList, objectWithAcl, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((S3Object)o1).getKey().compareToIgnoreCase(((S3Object)o2).getKey());
            }
        });
        if (updateRow >= 0) {
            this.setValueAt(aclStatus, updateRow, 3);
        } else {
            log.warn((Object)("Cannot find object named '" + objectWithAcl.getKey() + "' in objects table"));
        }
        return updateRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectAclStatus(S3Object objectWithAcl) {
        ArrayList arrayList = this.objectList;
        synchronized (arrayList) {
            int updateRow = Collections.binarySearch(this.objectList, objectWithAcl, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((S3Object)o1).getKey().compareToIgnoreCase(((S3Object)o2).getKey());
                }
            });
            if (updateRow >= 0) {
                return (String)this.getValueAt(updateRow, 3);
            }
            return null;
        }
    }

    public void addObjects(S3Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.addObject(objects[i]);
        }
    }

    public void removeObject(S3Object object) {
        this.sanitizeObjectKey(object);
        int row = Collections.binarySearch(this.objectList, object, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((S3Object)o1).getKey().compareToIgnoreCase(((S3Object)o2).getKey());
            }
        });
        if (row >= 0) {
            this.removeRow(row);
            this.objectList.remove(row);
        }
    }

    public void removeAllObjects() {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.removeRow(0);
        }
        this.objectList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Object getObject(int row) {
        ArrayList arrayList = this.objectList;
        synchronized (arrayList) {
            return (S3Object)this.objectList.get(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Object[] getObjects() {
        ArrayList arrayList = this.objectList;
        synchronized (arrayList) {
            return this.objectList.toArray(new S3Object[this.objectList.size()]);
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return Long.class;
        }
        if (columnIndex == 2) {
            return Date.class;
        }
        return String.class;
    }
}

