/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.audit;

import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.AuditHelper;

public class CpfAuditHelper {
    private static final Log log = LogFactory.getLog(CpfAuditHelper.class);

    public static UUID startAudit(String processId, String actionName, String objectName, IPentahoSession userSession, ILogger logger, IParameterProvider requestParams) {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        if (requestParams != null) {
            Iterator iter = requestParams.getParameterNames();
            while (iter.hasNext()) {
                String paramName = (String)iter.next();
                sb.append(paramName).append("=").append(requestParams.getStringParameter(paramName, "novalue")).append(";");
            }
        }
        try {
            AuditHelper.audit((String)userSession.getId(), (String)userSession.getName(), (String)actionName, (String)objectName, (String)processId, (String)"instance_start", (String)uuid.toString(), (String)sb.toString(), (float)0.0f, (ILogger)logger);
        }
        catch (Exception e) {
            log.warn((Object)"Exception while writing to audit log. Returning null as audit event ID but will continue execution ", (Throwable)e);
            return null;
        }
        return uuid;
    }

    public static void endAudit(String processId, String actionName, String objectName, IPentahoSession userSession, ILogger logger, long start, UUID uuid, long end) {
        try {
            AuditHelper.audit((String)userSession.getId(), (String)userSession.getName(), (String)actionName, (String)objectName, (String)processId, (String)"instance_end", (String)uuid.toString(), (String)"", (float)((float)(end - start) / 1000.0f), (ILogger)logger);
        }
        catch (Exception e) {
            log.warn((Object)"Exception while writing to audit log. Returning null as audit event ID but will continue execution ", (Throwable)e);
        }
    }
}

