/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.clock;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.clock.Timespan;

public class Chronos {
    private final PrintWriter _str;
    private long _tick = 0L;
    private long _startTime;
    private final Clock _clock;

    public Chronos() {
        this((PrintWriter)null);
    }

    public Chronos(PrintWriter str) {
        this((Clock)new SystemClock(), str);
    }

    public Chronos(OutputStream str) {
        this(new PrintWriter(str));
    }

    public Chronos(Clock clock) {
        this(clock, (PrintWriter)null);
    }

    public Chronos(Clock clock, PrintWriter str) {
        this._str = str;
        this._clock = clock;
        this._startTime = this._clock.currentTimeMillis();
        this.tick();
    }

    public Chronos(Clock clock, OutputStream str) {
        this(clock, new PrintWriter(str));
    }

    public long tick() {
        long tick = this._clock.currentTimeMillis();
        long diff = tick - this._tick;
        this._tick = tick;
        return diff;
    }

    public long getTotalTime() {
        return this._clock.currentTimeMillis() - this._startTime;
    }

    public void displayElapsedTime() {
        this.displayElapsedTime("");
    }

    public void displayElapsedTime(String mess) {
        if (this._str != null) {
            this._str.println(mess + this.getElapsedTime());
        }
    }

    public String getElapsedTime() {
        StringBuilder sb = new StringBuilder("Time: ");
        sb.append(this.tick());
        sb.append(" ms");
        return sb.toString();
    }

    public String getElapsedTimeAsHMS() {
        return new Timespan(this.tick()).getCanonicalString();
    }

    public void flush() {
        if (this._str != null) {
            this._str.flush();
        }
    }
}

