/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BlockStoragePolicy
implements BlockStoragePolicySpi {
    public static final Logger LOG = LoggerFactory.getLogger(BlockStoragePolicy.class);
    private final byte id;
    private final String name;
    private final StorageType[] storageTypes;
    private final StorageType[] creationFallbacks;
    private final StorageType[] replicationFallbacks;
    private boolean copyOnCreateFile;

    @VisibleForTesting
    public BlockStoragePolicy(byte id, String name, StorageType[] storageTypes, StorageType[] creationFallbacks, StorageType[] replicationFallbacks) {
        this(id, name, storageTypes, creationFallbacks, replicationFallbacks, false);
    }

    @VisibleForTesting
    public BlockStoragePolicy(byte id, String name, StorageType[] storageTypes, StorageType[] creationFallbacks, StorageType[] replicationFallbacks, boolean copyOnCreateFile) {
        this.id = id;
        this.name = name;
        this.storageTypes = storageTypes;
        this.creationFallbacks = creationFallbacks;
        this.replicationFallbacks = replicationFallbacks;
        this.copyOnCreateFile = copyOnCreateFile;
    }

    public List<StorageType> chooseStorageTypes(short replication) {
        LinkedList<StorageType> types = new LinkedList<StorageType>();
        int i = 0;
        for (int j = 0; i < replication && j < this.storageTypes.length; ++j) {
            if (this.storageTypes[j].isTransient()) continue;
            types.add(this.storageTypes[j]);
            ++i;
        }
        StorageType last = this.storageTypes[this.storageTypes.length - 1];
        if (!last.isTransient()) {
            while (i < replication) {
                types.add(last);
                ++i;
            }
        }
        return types;
    }

    public List<StorageType> chooseStorageTypes(short replication, Iterable<StorageType> chosen) {
        return this.chooseStorageTypes(replication, chosen, null);
    }

    private List<StorageType> chooseStorageTypes(short replication, Iterable<StorageType> chosen, List<StorageType> excess) {
        List<StorageType> types = this.chooseStorageTypes(replication);
        BlockStoragePolicy.diff(types, chosen, excess);
        return types;
    }

    public List<StorageType> chooseStorageTypes(short replication, Iterable<StorageType> chosen, EnumSet<StorageType> unavailables, boolean isNewBlock) {
        LinkedList<StorageType> excess = new LinkedList<StorageType>();
        List<StorageType> storageTypes = this.chooseStorageTypes(replication, chosen, excess);
        int expectedSize = storageTypes.size() - excess.size();
        LinkedList<StorageType> removed = new LinkedList<StorageType>();
        for (int i = storageTypes.size() - 1; i >= 0; --i) {
            StorageType fallback;
            StorageType t = storageTypes.get(i);
            if (!unavailables.contains(t)) continue;
            StorageType storageType = fallback = isNewBlock ? this.getCreationFallback(unavailables) : this.getReplicationFallback(unavailables);
            if (fallback == null) {
                removed.add(storageTypes.remove(i));
                continue;
            }
            storageTypes.set(i, fallback);
        }
        BlockStoragePolicy.diff(storageTypes, excess, null);
        if (storageTypes.size() < expectedSize) {
            LOG.warn("Failed to place enough replicas: expected size is " + expectedSize + " but only " + storageTypes.size() + " storage types can be selected " + "(replication=" + replication + ", selected=" + storageTypes + ", unavailable=" + unavailables + ", removed=" + removed + ", policy=" + this + ")");
        }
        return storageTypes;
    }

    private static void diff(List<StorageType> t, Iterable<StorageType> c, List<StorageType> e) {
        for (StorageType storagetype : c) {
            int i = t.indexOf(storagetype);
            if (i >= 0) {
                t.remove(i);
                continue;
            }
            if (e == null) continue;
            e.add(storagetype);
        }
    }

    public List<StorageType> chooseExcess(short replication, Iterable<StorageType> chosen) {
        List<StorageType> types = this.chooseStorageTypes(replication);
        LinkedList<StorageType> excess = new LinkedList<StorageType>();
        BlockStoragePolicy.diff(types, chosen, excess);
        return excess;
    }

    public StorageType getCreationFallback(EnumSet<StorageType> unavailables) {
        return BlockStoragePolicy.getFallback(unavailables, this.creationFallbacks);
    }

    public StorageType getReplicationFallback(EnumSet<StorageType> unavailables) {
        return BlockStoragePolicy.getFallback(unavailables, this.replicationFallbacks);
    }

    public int hashCode() {
        return Byte.valueOf(this.id).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BlockStoragePolicy)) {
            return false;
        }
        BlockStoragePolicy that = (BlockStoragePolicy)obj;
        return this.id == that.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.name + ":" + this.id + ", storageTypes=" + Arrays.asList(this.storageTypes) + ", creationFallbacks=" + Arrays.asList(this.creationFallbacks) + ", replicationFallbacks=" + Arrays.asList(this.replicationFallbacks) + "}";
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public StorageType[] getCreationFallbacks() {
        return this.creationFallbacks;
    }

    public StorageType[] getReplicationFallbacks() {
        return this.replicationFallbacks;
    }

    private static StorageType getFallback(EnumSet<StorageType> unavailables, StorageType[] fallbacks) {
        for (StorageType fb : fallbacks) {
            if (unavailables.contains(fb)) continue;
            return fb;
        }
        return null;
    }

    public boolean isCopyOnCreateFile() {
        return this.copyOnCreateFile;
    }
}

