/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.connection;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;

public class DriverConnectionDefinition
extends JdbcConnectionDefinition {
    private static final Log log = LogFactory.getLog(DriverConnectionDefinition.class);
    private String driverClass;
    private String connectionString;
    private Properties properties;

    public DriverConnectionDefinition(String name, String driverClass, String connectionString, String username, String password) {
        super(name);
        if (driverClass == null) {
            throw new NullPointerException();
        }
        if (connectionString == null) {
            throw new NullPointerException();
        }
        this.driverClass = driverClass;
        this.connectionString = connectionString;
        this.properties = new Properties();
        if (username != null) {
            this.properties.setProperty("user", username);
        }
        if (password != null) {
            this.properties.setProperty("password", password);
        }
        if (name != null) {
            this.properties.setProperty("::pentaho-reporting::name", name);
        }
    }

    public DriverConnectionDefinition(String name, String driverClass, String connectionString, String username, String password, String hostName, String dbName, String dbType, String port, Properties properties) {
        this(name, driverClass, connectionString, username, password);
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties.putAll((Map<?, ?>)properties);
        this.setHostName(hostName);
        this.setDatabaseName(dbName);
        this.setDatabaseType(dbType);
        this.setPort(port);
    }

    public String getPort() {
        return this.properties.getProperty("::pentaho-reporting::port");
    }

    public void setPort(String port) {
        if (port == null) {
            this.properties.remove("::pentaho-reporting::port");
        } else {
            this.properties.setProperty("::pentaho-reporting::port", port);
        }
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUsername() {
        return this.properties.getProperty("user");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DriverConnectionDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DriverConnectionDefinition that = (DriverConnectionDefinition)o;
        if (!this.connectionString.equals(that.connectionString)) {
            return false;
        }
        if (!this.driverClass.equals(that.driverClass)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.driverClass.hashCode();
        result = 31 * result + this.connectionString.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    public String getDatabaseName() {
        return this.properties.getProperty("::pentaho-reporting::database-name");
    }

    public void setDatabaseName(String databaseName) {
        if (databaseName == null) {
            this.properties.remove("::pentaho-reporting::database-name");
        } else {
            this.properties.setProperty("::pentaho-reporting::database-name", databaseName);
        }
    }

    public String getHostName() {
        return this.properties.getProperty("::pentaho-reporting::hostname");
    }

    public void setHostName(String hostName) {
        if (hostName == null) {
            this.properties.remove("::pentaho-reporting::hostname");
        } else {
            this.properties.setProperty("::pentaho-reporting::hostname", hostName);
        }
    }

    public String getDatabaseType() {
        return this.properties.getProperty("::pentaho-reporting::database-type");
    }

    public void setDatabaseType(String databaseType) {
        if (databaseType == null) {
            this.properties.remove("::pentaho-reporting::database-type");
        } else {
            this.properties.setProperty("::pentaho-reporting::database-type", databaseType);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

