/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.states.LengthLimitingTableModel;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;

public class JdbcPreviewWorker
implements PreviewWorker {
    private DataFactory dataFactory;
    private String query;
    private int queryTimeout;
    private int queryLimit;
    private ReportDataFactoryException exception;
    private TableModel tableModel;
    private ReportParameterDefinition reportParameters;

    public JdbcPreviewWorker(DataFactory dataFactory, String query, int queryTimeout, int queryLimit, ReportParameterDefinition reportParameters) {
        this.query = query;
        this.queryTimeout = queryTimeout;
        this.queryLimit = queryLimit;
        this.dataFactory = dataFactory;
        this.reportParameters = reportParameters;
    }

    public ReportDataFactoryException getException() {
        return this.exception;
    }

    public TableModel getResultTableModel() {
        return this.tableModel;
    }

    public void close() {
        if (this.tableModel instanceof CloseableTableModel) {
            CloseableTableModel ct = (CloseableTableModel)this.tableModel;
            ct.close();
        }
        this.dataFactory.close();
    }

    private ParameterDataRow normalizeParameters(ReportParameterDefinition reportParameters) {
        ParameterDefinitionEntry[] params = reportParameters.getParameterDefinitions();
        String[] namesParams = new String[params.length];
        Object[] objParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof AbstractParameter)) continue;
            AbstractParameter currentParam = (AbstractParameter)params[i];
            namesParams[i] = currentParam.getName();
            objParams[i] = currentParam.getDefaultValue();
        }
        return new ParameterDataRow(namesParams, objParams);
    }

    public void cancelProcessing(CancelEvent event) {
        this.dataFactory.cancelRunningQuery();
    }

    public void run() {
        try {
            ParameterDataRow paramDataRow = new ParameterDataRow();
            if (this.reportParameters != null) {
                paramDataRow = this.normalizeParameters(this.reportParameters);
            }
            this.tableModel = this.dataFactory.queryData(this.query, (DataRow)new QueryDataRowWrapper((DataRow)paramDataRow, this.queryLimit, this.queryTimeout));
            if (this.queryLimit > 0) {
                this.tableModel = new LengthLimitingTableModel(this.tableModel, this.queryLimit);
            }
        }
        catch (ReportDataFactoryException e) {
            this.exception = e;
        }
    }
}

