/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.ui.datasources.jdbc.Messages;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinitionManager;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;

public class NamedDataSourceDialogModel
implements DataSourceDialogModel {
    public static final String QUERY_SELECTED = "querySelected";
    public static final String CONNECTION_SELECTED = "connectionSelected";
    private PropertyChangeSupport propertyChangeSupport;
    private DefaultComboBoxModel connections;
    private DataSetComboBoxModel<String> queries;
    private boolean previewPossible;
    private boolean connectionSelected;
    private boolean querySelected;
    private JdbcConnectionDefinitionManager connectionDefinitionManager;
    private String jdbcUserField;
    private String jdbcPasswordField;
    private JTextField schemaFileNameField;

    public NamedDataSourceDialogModel() {
        this(new JdbcConnectionDefinitionManager());
    }

    public NamedDataSourceDialogModel(JdbcConnectionDefinitionManager connectionDefinitionManager) {
        this.connectionDefinitionManager = connectionDefinitionManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.connections = new DefaultComboBoxModel();
        this.connections.addListDataListener(new PreviewPossibleUpdateHandler());
        this.queries = new DataSetComboBoxModel();
        this.queries.addListDataListener((ListDataListener)new PreviewPossibleUpdateHandler());
    }

    public void clear() {
        this.queries.removeAllElements();
        this.connections.removeAllElements();
        this.setJdbcPasswordField(null);
        this.setJdbcUserField(null);
        this.setPreviewPossible(false);
        JdbcConnectionDefinition[] jdbcConnectionDefinitions = this.connectionDefinitionManager.getSources();
        for (int i = 0; i < jdbcConnectionDefinitions.length; ++i) {
            JdbcConnectionDefinition definition = jdbcConnectionDefinitions[i];
            this.connections.addElement(definition);
        }
        this.connections.setSelectedItem(null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public DataSetComboBoxModel<String> getQueries() {
        return this.queries;
    }

    @Override
    public DefaultComboBoxModel getConnections() {
        return this.connections;
    }

    @Override
    public void addConnection(JdbcConnectionDefinition definition) {
        if (this.connections.getIndexOf(definition) == -1) {
            this.connections.addElement(definition);
        }
    }

    @Override
    public void removeConnection(JdbcConnectionDefinition definition) {
        this.connections.removeElement(definition);
    }

    @Override
    public void editConnection(JdbcConnectionDefinition oldConnection, JdbcConnectionDefinition newConnection) {
        if (oldConnection == null) {
            if (newConnection != null) {
                this.addConnection(newConnection);
            }
            return;
        }
        if (newConnection == null) {
            this.removeConnection(oldConnection);
            return;
        }
        int index = this.connections.getIndexOf(oldConnection);
        if (index == -1) {
            this.connections.addElement(newConnection);
        } else {
            this.connections.insertElementAt(newConnection, index);
        }
        this.connections.removeElement(oldConnection);
    }

    public boolean isPreviewPossible() {
        return this.previewPossible;
    }

    public void setPreviewPossible(boolean previewPossible) {
        boolean oldPreviewPossible = this.previewPossible;
        this.previewPossible = previewPossible;
        this.propertyChangeSupport.firePropertyChange("previewPossible", oldPreviewPossible, previewPossible);
    }

    @Override
    public boolean isConnectionSelected() {
        return this.connectionSelected;
    }

    public void setConnectionSelected(boolean connectionSelected) {
        this.connectionSelected = connectionSelected;
        this.propertyChangeSupport.firePropertyChange(CONNECTION_SELECTED, !connectionSelected, connectionSelected);
    }

    public boolean isQuerySelected() {
        return this.querySelected;
    }

    public void setQuerySelected(boolean querySelected) {
        this.querySelected = querySelected;
        this.propertyChangeSupport.firePropertyChange(QUERY_SELECTED, !querySelected, querySelected);
    }

    public void addQuery(String queryName, String query, String scriptLanguage, String script) {
        this.queries.addElement((Object)new DataSetQuery(queryName, (Object)query, scriptLanguage, script));
    }

    @Override
    public JdbcConnectionDefinitionManager getConnectionDefinitionManager() {
        return this.connectionDefinitionManager;
    }

    @Override
    public String getJdbcUserField() {
        return this.jdbcUserField;
    }

    @Override
    public void setJdbcUserField(String jdbcUserField) {
        String oldUser = this.jdbcUserField;
        this.jdbcUserField = jdbcUserField;
        this.propertyChangeSupport.firePropertyChange("jdbcUserField", oldUser, jdbcUserField);
    }

    @Override
    public String getJdbcPasswordField() {
        return this.jdbcPasswordField;
    }

    @Override
    public void setJdbcPasswordField(String jdbcPasswordField) {
        String oldPassword = this.jdbcPasswordField;
        this.jdbcPasswordField = jdbcPasswordField;
        this.propertyChangeSupport.firePropertyChange("jdbcPasswordField", oldPassword, jdbcPasswordField);
    }

    public JTextField getSchemaFileNameField() {
        return this.schemaFileNameField;
    }

    public void setSchemaFileNameField(JTextField schemaFileNameField) {
        this.schemaFileNameField = schemaFileNameField;
    }

    public void setSelectedQuery(String selectedQueryName) {
        if (this.queries == null || this.queries.getSize() == 0) {
            return;
        }
        if (selectedQueryName == null) {
            this.queries.setSelectedItem((Object)this.getFirstQueryName());
            this.setQuerySelected(this.getFirstQueryName() != null);
            this.setPreviewPossible(this.getFirstQueryName() != null);
            return;
        }
        for (int i = 0; i < this.queries.getSize(); ++i) {
            DataSetQuery q = (DataSetQuery)this.queries.getElementAt(i);
            if (!selectedQueryName.equals(q.getQueryName())) continue;
            this.queries.setSelectedItem((Object)q);
            this.setQuerySelected(true);
            this.setPreviewPossible(true);
            return;
        }
    }

    public DataSetQuery getFirstQueryName() {
        DataSetComboBoxModel<String> dataSetQueries = this.getQueries();
        if (dataSetQueries != null && dataSetQueries.getSize() > 0) {
            return dataSetQueries.getQuery(0);
        }
        return null;
    }

    public String generateQueryName() {
        String queryName = Messages.getString("JdbcDataSourceDialog.Query", new Object[0]);
        DataSetComboBoxModel<String> queries = this.getQueries();
        for (int i = 1; i < 1000; ++i) {
            String newQuery = queryName + " " + i;
            if (queries.getIndexForQuery(newQuery) != -1) continue;
            return newQuery;
        }
        return queryName;
    }

    private class PreviewPossibleUpdateHandler
    implements ListDataListener {
        private PreviewPossibleUpdateHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            DefaultComboBoxModel connections = NamedDataSourceDialogModel.this.getConnections();
            DataSetComboBoxModel<String> queries = NamedDataSourceDialogModel.this.getQueries();
            NamedDataSourceDialogModel.this.setConnectionSelected(connections.getSelectedItem() != null);
            NamedDataSourceDialogModel.this.setQuerySelected(queries.getSelectedItem() != null);
            if (connections.getSelectedItem() == null) {
                NamedDataSourceDialogModel.this.setPreviewPossible(false);
                return;
            }
            if (queries.getSelectedItem() == null) {
                NamedDataSourceDialogModel.this.setPreviewPossible(false);
                return;
            }
            DataSetQuery o = (DataSetQuery)queries.getSelectedItem();
            if (o == null || StringUtils.isEmpty((String)o.getQueryName())) {
                NamedDataSourceDialogModel.this.setPreviewPossible(false);
                return;
            }
            NamedDataSourceDialogModel.this.setPreviewPossible(true);
        }
    }
}

