/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinitionManager;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;

public class SimpleDataSourceDialogModel
implements DataSourceDialogModel {
    private PropertyChangeSupport propertyChangeSupport;
    private DefaultComboBoxModel connections;
    private boolean previewPossible;
    private boolean connectionSelected;
    private JdbcConnectionDefinitionManager connectionDefinitionManager;
    private String jdbcUserField;
    private String jdbcPasswordField;

    public SimpleDataSourceDialogModel() {
        this(new JdbcConnectionDefinitionManager());
    }

    public SimpleDataSourceDialogModel(JdbcConnectionDefinitionManager connectionDefinitionManager) {
        this.connectionDefinitionManager = connectionDefinitionManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.connections = new DefaultComboBoxModel();
        this.connections.addListDataListener(new PreviewPossibleUpdateHandler());
    }

    public void clear() {
        this.connections.removeAllElements();
        this.setJdbcPasswordField(null);
        this.setJdbcUserField(null);
        this.setPreviewPossible(false);
        JdbcConnectionDefinition[] jdbcConnectionDefinitions = this.connectionDefinitionManager.getSources();
        for (int i = 0; i < jdbcConnectionDefinitions.length; ++i) {
            JdbcConnectionDefinition definition = jdbcConnectionDefinitions[i];
            this.connections.addElement(definition);
        }
        this.connections.setSelectedItem(null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public DefaultComboBoxModel getConnections() {
        return this.connections;
    }

    @Override
    public void addConnection(JdbcConnectionDefinition definition) {
        if (this.connections.getIndexOf(definition) == -1) {
            this.connections.addElement(definition);
        }
    }

    @Override
    public void editConnection(JdbcConnectionDefinition oldConnection, JdbcConnectionDefinition newConnection) {
        if (oldConnection == null) {
            if (newConnection != null) {
                this.addConnection(newConnection);
            }
            return;
        }
        if (newConnection == null) {
            this.removeConnection(oldConnection);
            return;
        }
        int index = this.connections.getIndexOf(oldConnection);
        if (index == -1) {
            this.connections.addElement(newConnection);
        } else {
            this.connections.insertElementAt(newConnection, index);
        }
        this.connections.removeElement(oldConnection);
    }

    @Override
    public void removeConnection(JdbcConnectionDefinition definition) {
        this.connections.removeElement(definition);
    }

    public boolean isPreviewPossible() {
        return this.previewPossible;
    }

    public void setPreviewPossible(boolean previewPossible) {
        boolean oldPreviewPossible = this.previewPossible;
        this.previewPossible = previewPossible;
        this.propertyChangeSupport.firePropertyChange("previewPossible", oldPreviewPossible, previewPossible);
    }

    @Override
    public boolean isConnectionSelected() {
        return this.connectionSelected;
    }

    public void setConnectionSelected(boolean connectionSelected) {
        boolean oldConnectionSelected = this.connectionSelected;
        this.connectionSelected = connectionSelected;
        this.propertyChangeSupport.firePropertyChange("connectionSelected", oldConnectionSelected, connectionSelected);
    }

    @Override
    public JdbcConnectionDefinitionManager getConnectionDefinitionManager() {
        return this.connectionDefinitionManager;
    }

    @Override
    public String getJdbcUserField() {
        return this.jdbcUserField;
    }

    @Override
    public void setJdbcUserField(String jdbcUserField) {
        String oldUser = this.jdbcUserField;
        this.jdbcUserField = jdbcUserField;
        this.propertyChangeSupport.firePropertyChange("jdbcUserField", oldUser, jdbcUserField);
    }

    @Override
    public String getJdbcPasswordField() {
        return this.jdbcPasswordField;
    }

    @Override
    public void setJdbcPasswordField(String jdbcPasswordField) {
        String oldPassword = this.jdbcPasswordField;
        this.jdbcPasswordField = jdbcPasswordField;
        this.propertyChangeSupport.firePropertyChange("jdbcPasswordField", oldPassword, jdbcPasswordField);
    }

    private class PreviewPossibleUpdateHandler
    implements ListDataListener {
        private PreviewPossibleUpdateHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            SimpleDataSourceDialogModel.this.setConnectionSelected(SimpleDataSourceDialogModel.this.getConnections().getSelectedItem() != null);
            if (SimpleDataSourceDialogModel.this.getConnections().getSelectedItem() == null) {
                SimpleDataSourceDialogModel.this.setPreviewPossible(false);
                return;
            }
            SimpleDataSourceDialogModel.this.setPreviewPossible(true);
        }
    }
}

