/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.launcher.config;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.commons.launcher.util.StringUtil;

public class Parameters {
    private final List<String> classpath;
    private final List<String> libraries;
    private final String mainClass;
    private final int parsedArgs;

    public Parameters(String mainClass, List<String> libraries, List<String> classpath, int parsedArgs) {
        this.mainClass = mainClass;
        this.libraries = Collections.unmodifiableList(new ArrayList<String>(libraries));
        this.classpath = Collections.unmodifiableList(new ArrayList<String>(classpath));
        this.parsedArgs = parsedArgs;
    }

    public static Parameters fromArgs(String[] args, PrintStream outputPrintStream) {
        String mainClass = null;
        ArrayList<String> libraries = new ArrayList<String>();
        ArrayList<String> classpath = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-main".equals(arg)) {
                if (++i == args.length) {
                    outputPrintStream.println("Argument parse error: '-main' needs an parameter");
                    System.exit(1);
                }
                mainClass = args[i];
                continue;
            }
            if ("-lib".equals(arg)) {
                if (++i == args.length) {
                    outputPrintStream.println("Argument parse error: '-lib' needs an parameter");
                    System.exit(1);
                }
                libraries.addAll(StringUtil.parsePath(args[i], File.pathSeparator));
                continue;
            }
            if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                if (++i == args.length) {
                    outputPrintStream.println("Argument parse error: '-cp' needs an parameter");
                    System.exit(1);
                }
                classpath.addAll(StringUtil.parsePath(args[i], File.pathSeparator));
                continue;
            }
            if ("--".equals(arg)) {
                return new Parameters(mainClass, libraries, classpath, i + 1);
            }
            return new Parameters(mainClass, libraries, classpath, i);
        }
        return new Parameters(mainClass, libraries, classpath, args.length);
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public int getParsedArgs() {
        return this.parsedArgs;
    }
}

