/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TezJobExecHelper {
    private static final Log LOG = LogFactory.getLog((String)TezJobExecHelper.class.getName());
    private static final Method KILL_RUNNING_TEZ_JOBS;

    public static void killRunningJobs() {
        try {
            if (KILL_RUNNING_TEZ_JOBS != null) {
                KILL_RUNNING_TEZ_JOBS.invoke(null, null);
            } else {
                LOG.warn((Object)"Unable to find tez method for killing jobs");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not stop tez dags: ", (Throwable)e);
        }
    }

    static {
        Method method = null;
        try {
            Class.forName("org.apache.tez.dag.api.DAG");
            ClassLoader classLoader = TezJobExecHelper.class.getClassLoader();
            method = classLoader.loadClass("org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor").getDeclaredMethod("killRunningJobs", new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting tez method", (Throwable)e);
        }
        KILL_RUNNING_TEZ_JOBS = method;
    }
}

