/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.MapRecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ObjectCache;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordProcessor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class TezProcessor
extends AbstractLogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(TezProcessor.class);
    protected boolean isMap = false;
    protected RecordProcessor rproc = null;
    protected JobConf jobConf;
    private static final String CLASS_NAME = TezProcessor.class.getName();
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    protected ProcessorContext processorContext;
    protected static final NumberFormat taskIdFormat = NumberFormat.getInstance();
    protected static final NumberFormat jobIdFormat = NumberFormat.getInstance();

    public TezProcessor(ProcessorContext context) {
        super(context);
        ObjectCache.setupObjectRegistry(context.getObjectRegistry());
    }

    public void close() throws IOException {
    }

    public void handleEvents(List<Event> arg0) {
    }

    public void initialize() throws IOException {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezInitializeProcessor");
        Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.jobConf = new JobConf(conf);
        this.processorContext = this.getContext();
        this.setupMRLegacyConfigs(this.processorContext);
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezInitializeProcessor");
    }

    private void setupMRLegacyConfigs(ProcessorContext processorContext) {
        StringBuilder taskAttemptIdBuilder = new StringBuilder("attempt_");
        taskAttemptIdBuilder.append(processorContext.getApplicationId().getClusterTimestamp()).append("_").append(jobIdFormat.format(processorContext.getApplicationId().getId())).append("_");
        if (this.isMap) {
            taskAttemptIdBuilder.append("m_");
        } else {
            taskAttemptIdBuilder.append("r_");
        }
        taskAttemptIdBuilder.append(taskIdFormat.format(processorContext.getTaskIndex())).append("_").append(processorContext.getTaskAttemptNumber());
        String taskAttemptIdStr = taskAttemptIdBuilder.toString();
        this.jobConf.set("mapred.task.id", taskAttemptIdStr);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptIdStr);
        this.jobConf.setInt("mapred.task.partition", processorContext.getTaskIndex());
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezRunProcessor");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running task: " + this.getContext().getUniqueIdentifier()));
        }
        this.rproc = this.isMap ? new MapRecordProcessor(this.jobConf, this.getContext()) : new ReduceRecordProcessor(this.jobConf, this.getContext());
        this.initializeAndRunProcessor(inputs, outputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeAndRunProcessor(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        Throwable originalThrowable = null;
        try {
            MRTaskReporter mrReporter = new MRTaskReporter(this.getContext());
            this.rproc.init(mrReporter, inputs, outputs);
            this.rproc.run();
            this.perfLogger.PerfLogEnd(CLASS_NAME, "TezRunProcessor");
        }
        catch (Throwable t) {
            originalThrowable = t;
        }
        finally {
            block15: {
                if (originalThrowable != null && originalThrowable instanceof Error) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)originalThrowable));
                    throw new RuntimeException(originalThrowable);
                }
                try {
                    if (this.rproc != null) {
                        this.rproc.close();
                    }
                }
                catch (Throwable t) {
                    if (originalThrowable != null) break block15;
                    originalThrowable = t;
                }
            }
            if (originalThrowable != null) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)originalThrowable));
                throw new RuntimeException(originalThrowable);
            }
        }
    }

    static {
        taskIdFormat.setGroupingUsed(false);
        taskIdFormat.setMinimumIntegerDigits(6);
        jobIdFormat.setGroupingUsed(false);
        jobIdFormat.setMinimumIntegerDigits(4);
    }

    static class TezKVOutputCollector
    implements OutputCollector {
        private KeyValueWriter writer;
        private final LogicalOutput output;

        TezKVOutputCollector(LogicalOutput logicalOutput) {
            this.output = logicalOutput;
        }

        void initialize() throws Exception {
            this.writer = (KeyValueWriter)this.output.getWriter();
        }

        public void collect(Object key, Object value) throws IOException {
            this.writer.write(key, value);
        }
    }
}

