/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcTail;
import org.apache.hadoop.hive.ql.io.orc.OrcUtils;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.SchemaEvolution;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.StripeStatistics;
import org.apache.hadoop.hive.ql.io.orc.TypeDescription;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowReader;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class OrcInputFormat
implements InputFormat<NullWritable, OrcStruct>,
InputFormatChecker,
VectorizedInputFormatInterface,
SelfDescribingInputFormatInterface,
AcidInputFormat<NullWritable, OrcStruct>,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final Log LOG = LogFactory.getLog(OrcInputFormat.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    static final String MIN_SPLIT_SIZE = SHIMS.getHadoopConfNames().get("MAPREDMINSPLITSIZE");
    static final String MAX_SPLIT_SIZE = SHIMS.getHadoopConfNames().get("MAPREDMAXSPLITSIZE");
    private static final long DEFAULT_MIN_SPLIT_SIZE = 0x1000000L;
    private static final long DEFAULT_MAX_SPLIT_SIZE = 0x10000000L;
    private static final int DEFAULT_ETL_FILE_THRESHOLD = 100;
    private static final int DEFAULT_CACHE_INITIAL_CAPACITY = 1024;
    private static final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private static final String CLASS_NAME = ReaderImpl.class.getName();
    private static final double MIN_INCLUDED_LOCATION = 0.8;
    private static boolean SCHEMA_TYPES_IS_ORIGINAL = true;

    @Override
    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return conf.get("hive.doing.acid") != null || AcidUtils.isAcid(path, conf);
    }

    public boolean isAcidRead(Configuration conf, InputSplit inputSplit) {
        if (!(inputSplit instanceof OrcSplit)) {
            return false;
        }
        return HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
    }

    private static int getRootColumn(boolean isOriginal) {
        return isOriginal ? 0 : 6;
    }

    public static void raiseAcidTablesMustBeReadWithAcidReaderException(Configuration conf) throws IOException {
        String hiveInputFormat = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEINPUTFORMAT);
        if (hiveInputFormat.equals(HiveInputFormat.class.getName())) {
            throw new IOException(ErrorMsg.ACID_TABLES_MUST_BE_READ_WITH_ACID_READER.getErrorCodedMsg());
        }
        throw new IOException(ErrorMsg.ACID_TABLES_MUST_BE_READ_WITH_HIVEINPUTFORMAT.getErrorCodedMsg());
    }

    public static RecordReader createReaderFromFile(Reader file, Configuration conf, long offset, long length) throws IOException {
        boolean isTransactionalTableScan = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
        if (isTransactionalTableScan) {
            OrcInputFormat.raiseAcidTablesMustBeReadWithAcidReaderException(conf);
        }
        TypeDescription schema = OrcUtils.getDesiredRowTypeDescr(conf, false);
        Reader.Options options = new Reader.Options().range(offset, length);
        options.schema(schema);
        boolean isOriginal = OrcInputFormat.isOriginal(file);
        if (schema == null) {
            schema = file.getSchema();
        }
        List<OrcProto.Type> types = OrcUtils.getOrcTypes(schema);
        options.include(OrcInputFormat.genIncludedColumns(schema, conf));
        OrcInputFormat.setSearchArgument(options, types, conf, isOriginal);
        return file.rowsOptions(options);
    }

    public static boolean isOriginal(Reader file) {
        return !file.hasMetadataValue("hive.acid.key.index");
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId, int rootColumn) {
        result[typeId - rootColumn] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            OrcInputFormat.includeColumnRecursive(types, result, type.getSubtypes(i), rootColumn);
        }
    }

    public static boolean[] genIncludedColumns(TypeDescription readerSchema, List<Integer> included) {
        boolean[] result = new boolean[readerSchema.getMaximumId() + 1];
        result[0] = true;
        List<TypeDescription> children = readerSchema.getChildren();
        for (int columnNumber = 0; columnNumber < children.size(); ++columnNumber) {
            if (!included.contains(columnNumber)) continue;
            TypeDescription child = children.get(columnNumber);
            for (int col = child.getId(); col <= child.getMaximumId(); ++col) {
                result[col] = true;
            }
        }
        return result;
    }

    public static boolean[] genIncludedColumns(TypeDescription readerSchema, Configuration conf) {
        if (!ColumnProjectionUtils.isReadAllColumns(conf)) {
            List<Integer> included = ColumnProjectionUtils.getReadColumnIDs(conf);
            return OrcInputFormat.genIncludedColumns(readerSchema, included);
        }
        return null;
    }

    public static String[] getSargColumnNames(String[] originalColumnNames, List<OrcProto.Type> types, boolean[] includedColumns, boolean isOriginal) {
        int rootColumn = OrcInputFormat.getRootColumn(isOriginal);
        String[] columnNames = new String[types.size() - rootColumn];
        int i = 0;
        for (int columnId : types.get(rootColumn).getSubtypesList()) {
            if (includedColumns != null && !includedColumns[columnId - rootColumn]) continue;
            columnNames[columnId - rootColumn] = originalColumnNames[i++];
        }
        return columnNames;
    }

    static void setSearchArgument(Reader.Options options, List<OrcProto.Type> types, Configuration conf, boolean isOriginal) {
        OrcInputFormat.setSearchArgument(options, types, conf, isOriginal, true);
    }

    static void setSearchArgument(Reader.Options options, List<OrcProto.Type> types, Configuration conf, boolean isOriginal, boolean doLogSarg) {
        String columnNamesString = conf.get("hive.io.file.readcolumn.names");
        if (columnNamesString == null) {
            LOG.debug((Object)"No ORC pushdown predicate - no column names");
            options.searchArgument(null, null);
            return;
        }
        SearchArgument sarg = SearchArgumentFactory.createFromConf(conf);
        if (sarg == null) {
            LOG.debug((Object)"No ORC pushdown predicate");
            options.searchArgument(null, null);
            return;
        }
        if (doLogSarg && LOG.isInfoEnabled()) {
            LOG.info((Object)("ORC pushdown predicate: " + sarg));
        }
        options.searchArgument(sarg, OrcInputFormat.getSargColumnNames(columnNamesString.split(","), types, options.getInclude(), isOriginal));
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
        if (Utilities.isVectorMode(conf)) {
            return new VectorizedOrcInputFormat().validateInput(fs, conf, files);
        }
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            if (file.getLen() == 0L) {
                return false;
            }
            try {
                OrcFile.createReader(file.getPath(), OrcFile.readerOptions(conf).filesystem(fs).maxLength(file.getLen()));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    static Path[] getInputPaths(Configuration conf) throws IOException {
        String dirs = conf.get("mapred.input.dir");
        if (dirs == null) {
            throw new IOException("Configuration mapred.input.dir is not defined.");
        }
        String[] list = StringUtils.split((String)dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString((String)list[i]));
        }
        return result;
    }

    static List<OrcSplit> generateSplitsInfo(Configuration conf) throws IOException {
        return OrcInputFormat.generateSplitsInfo(conf, -1);
    }

    static List<OrcSplit> generateSplitsInfo(Configuration conf, int numSplits) throws IOException {
        Context context = new Context(conf, numSplits);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ORC pushdown predicate: " + SearchArgumentFactory.createFromConf(conf)));
        }
        ArrayList<OrcSplit> splits = Lists.newArrayList();
        ArrayList<Future<?>> pathFutures = Lists.newArrayList();
        ArrayList<Future<?>> splitFutures = Lists.newArrayList();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        boolean isTransactionalTableScan = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
        boolean isSchemaEvolution = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
        TypeDescription readerSchema = OrcUtils.getDesiredRowTypeDescr(conf, isTransactionalTableScan);
        List<OrcProto.Type> readerTypes = null;
        if (readerSchema != null) {
            readerTypes = OrcUtils.getOrcTypes(readerSchema);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generate splits schema evolution property " + isSchemaEvolution + " reader schema " + (readerSchema == null ? "NULL" : readerSchema.toString()) + " transactional scan property " + isTransactionalTableScan));
        }
        for (Path dir : OrcInputFormat.getInputPaths(conf)) {
            FileSystem fs = dir.getFileSystem(conf);
            FileGenerator fileGenerator = new FileGenerator(context, fs, dir, readerTypes, ugi);
            pathFutures.add(Context.threadPool.submit(fileGenerator));
        }
        try {
            for (Future future : pathFutures) {
                SplitStrategy splitStrategy = (SplitStrategy)future.get();
                if (isDebugEnabled) {
                    LOG.debug((Object)splitStrategy);
                }
                if (splitStrategy instanceof ETLSplitStrategy) {
                    List splitInfos = splitStrategy.getSplits();
                    for (SplitInfo splitInfo : splitInfos) {
                        splitFutures.add(Context.threadPool.submit(new SplitGenerator(splitInfo, ugi)));
                    }
                    continue;
                }
                splits.addAll(splitStrategy.getSplits());
            }
            for (Future future : splitFutures) {
                splits.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            OrcInputFormat.cancelFutures(pathFutures);
            OrcInputFormat.cancelFutures(splitFutures);
            throw new RuntimeException("serious problem", e);
        }
        if (context.cacheStripeDetails) {
            LOG.info((Object)("FooterCacheHitRatio: " + context.cacheHitCounter.get() + "/" + context.numFilesCounter.get()));
        }
        if (isDebugEnabled) {
            for (OrcSplit orcSplit : splits) {
                LOG.debug((Object)(orcSplit + " projected_columns_uncompressed_size: " + orcSplit.getColumnarProjectionSize()));
            }
        }
        return splits;
    }

    private static void cancelFutures(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            future.cancel(true);
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        perfLogger.PerfLogBegin(CLASS_NAME, "OrcGetSplits");
        List<OrcSplit> result = OrcInputFormat.generateSplitsInfo((Configuration)job, numSplits);
        perfLogger.PerfLogEnd(CLASS_NAME, "OrcGetSplits");
        return result.toArray(new InputSplit[result.size()]);
    }

    private org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> createVectorizedReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        return new VectorizedOrcInputFormat().getRecordReader(split, conf, reporter);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        boolean vectorMode = Utilities.isVectorMode((Configuration)conf);
        boolean isAcidRead = this.isAcidRead((Configuration)conf, inputSplit);
        if (!isAcidRead) {
            if (vectorMode) {
                return this.createVectorizedReader(inputSplit, conf, reporter);
            }
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf);
            if (inputSplit instanceof OrcSplit) {
                OrcSplit split = (OrcSplit)inputSplit;
                readerOptions.maxLength(split.getFileLength()).orcTail(split.getOrcTail());
            }
            return new OrcRecordReader(OrcFile.createReader(((FileSplit)inputSplit).getPath(), readerOptions), (Configuration)conf, (FileSplit)inputSplit);
        }
        reporter.setStatus(inputSplit.toString());
        AcidInputFormat.Options options = new AcidInputFormat.Options((Configuration)conf).reporter(reporter);
        AcidInputFormat.RowReader<OrcStruct> inner = this.getReader(inputSplit, options);
        if (vectorMode) {
            return new VectorizedOrcAcidRowReader(inner, (Configuration)conf, Utilities.getMapWork((Configuration)conf).getVectorizedRowBatchCtx(), (FileSplit)inputSplit);
        }
        return new NullKeyRecordReader(inner, (Configuration)conf);
    }

    @Override
    public AcidInputFormat.RowReader<OrcStruct> getReader(InputSplit inputSplit, AcidInputFormat.Options options) throws IOException {
        Reader reader;
        int bucket;
        OrcSplit split = (OrcSplit)inputSplit;
        Path path = split.getPath();
        Path root = split.hasBase() ? (split.isOriginal() ? path.getParent() : path.getParent().getParent()) : path;
        Path[] deltas = AcidUtils.deserializeDeltas(root, split.getDeltas());
        Configuration conf = options.getConfiguration();
        TypeDescription schema = OrcUtils.getDesiredRowTypeDescr(conf, true);
        Reader.Options readOptions = new Reader.Options().schema(schema);
        readOptions.range(split.getStart(), split.getLength());
        final List<OrcProto.Type> schemaTypes = OrcUtils.getOrcTypes(schema);
        readOptions.include(OrcInputFormat.genIncludedColumns(schema, conf));
        OrcInputFormat.setSearchArgument(readOptions, schemaTypes, conf, SCHEMA_TYPES_IS_ORIGINAL);
        if (split.hasBase()) {
            bucket = AcidUtils.parseBaseBucketFilename(split.getPath(), conf).getBucket();
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(conf).maxLength(split.getFileLength());
            if (split.hasFooter()) {
                readerOptions.orcTail(split.getOrcTail());
            }
            reader = OrcFile.createReader(path, readerOptions);
        } else {
            bucket = (int)split.getStart();
            reader = null;
        }
        String txnString = conf.get("hive.txn.valid.txns");
        ValidReadTxnList validTxnList = txnString == null ? new ValidReadTxnList() : new ValidReadTxnList(txnString);
        final OrcRawRecordMerger records = new OrcRawRecordMerger(conf, true, reader, split.isOriginal(), bucket, validTxnList, readOptions, deltas);
        return new AcidInputFormat.RowReader<OrcStruct>(){
            OrcStruct innerRecord;
            {
                this.innerRecord = records.createValue();
            }

            @Override
            public ObjectInspector getObjectInspector() {
                return OrcStruct.createObjectInspector(0, schemaTypes);
            }

            public boolean next(RecordIdentifier recordIdentifier, OrcStruct orcStruct) throws IOException {
                boolean result;
                while ((result = records.next(recordIdentifier, this.innerRecord)) && OrcRecordUpdater.getOperation(this.innerRecord) == 2) {
                }
                if (result) {
                    orcStruct.linkFields(OrcRecordUpdater.getRow(this.innerRecord));
                }
                return result;
            }

            public RecordIdentifier createKey() {
                return records.createKey();
            }

            public OrcStruct createValue() {
                return new OrcStruct(records.getColumns());
            }

            public long getPos() throws IOException {
                return records.getPos();
            }

            public void close() throws IOException {
                records.close();
            }

            public float getProgress() throws IOException {
                return records.getProgress();
            }
        };
    }

    static Path findOriginalBucket(FileSystem fs, Path directory, int bucket) throws IOException {
        for (FileStatus stat : fs.listStatus(directory)) {
            String name = stat.getPath().getName();
            String numberPart = name.substring(0, name.indexOf(95));
            if (!org.apache.commons.lang3.StringUtils.isNumeric(numberPart) || Integer.parseInt(numberPart) != bucket) continue;
            return stat.getPath();
        }
        throw new IllegalArgumentException("Can't find bucket " + bucket + " in " + directory);
    }

    @Override
    public AcidInputFormat.RawReader<OrcStruct> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidTxnList validTxnList, Path baseDirectory, Path[] deltaDirectory) throws IOException {
        Reader reader = null;
        boolean isOriginal = false;
        if (baseDirectory != null) {
            Path bucketFile;
            if (baseDirectory.getName().startsWith("base_")) {
                bucketFile = AcidUtils.createBucketFile(baseDirectory, bucket);
            } else {
                isOriginal = true;
                bucketFile = OrcInputFormat.findOriginalBucket(baseDirectory.getFileSystem(conf), baseDirectory, bucket);
            }
            reader = OrcFile.createReader(bucketFile, OrcFile.readerOptions(conf));
        }
        return new OrcRawRecordMerger(conf, collapseEvents, reader, isOriginal, bucket, validTxnList, new Reader.Options(), deltaDirectory);
    }

    public static final class NullKeyRecordReader
    implements AcidInputFormat.AcidRecordReader<NullWritable, OrcStruct> {
        private final RecordIdentifier id;
        private final AcidInputFormat.RowReader<OrcStruct> inner;

        @Override
        public RecordIdentifier getRecordIdentifier() {
            return this.id;
        }

        private NullKeyRecordReader(AcidInputFormat.RowReader<OrcStruct> inner, Configuration conf) {
            this.inner = inner;
            this.id = (RecordIdentifier)inner.createKey();
        }

        public boolean next(NullWritable nullWritable, OrcStruct orcStruct) throws IOException {
            return this.inner.next(this.id, orcStruct);
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return (OrcStruct)this.inner.createValue();
        }

        public long getPos() throws IOException {
            return this.inner.getPos();
        }

        public void close() throws IOException {
            this.inner.close();
        }

        public float getProgress() throws IOException {
            return this.inner.getProgress();
        }
    }

    static final class SplitGenerator
    implements Callable<List<OrcSplit>> {
        private final Context context;
        private final FileSystem fs;
        private final FileStatus file;
        private final long blockSize;
        private final TreeMap<Long, BlockLocation> locations;
        private OrcTail orcTail;
        private List<OrcProto.Type> readerTypes;
        private List<StripeInformation> stripes;
        private List<StripeStatistics> stripeStats;
        private List<OrcProto.Type> fileTypes;
        private boolean[] included;
        private boolean[] readerIncluded;
        private final boolean isOriginal;
        private final List<AcidInputFormat.DeltaMetaData> deltas;
        private final boolean hasBase;
        private OrcFile.WriterVersion writerVersion;
        private long projColsUncompressedSize;
        private List<OrcSplit> deltaSplits;
        private final UserGroupInformation ugi;
        private SchemaEvolution evolution;

        public SplitGenerator(SplitInfo splitInfo, UserGroupInformation ugi) throws IOException {
            this.context = splitInfo.context;
            this.fs = splitInfo.fs;
            this.file = splitInfo.file;
            this.blockSize = this.file.getBlockSize();
            this.orcTail = splitInfo.orcTail;
            this.readerTypes = splitInfo.readerTypes;
            this.locations = SHIMS.getLocationsWithOffset(this.fs, this.file);
            this.isOriginal = splitInfo.isOriginal;
            this.deltas = splitInfo.deltas;
            this.hasBase = splitInfo.hasBase;
            this.projColsUncompressedSize = -1L;
            this.deltaSplits = splitInfo.getSplits();
            this.ugi = ugi;
        }

        Path getPath() {
            return this.file.getPath();
        }

        public String toString() {
            return "splitter(" + this.file.getPath() + ")";
        }

        static long getOverlap(long offset1, long length1, long offset2, long length2) {
            long end1 = offset1 + length1;
            long end2 = offset2 + length2;
            if (end2 <= offset1 || end1 <= offset2) {
                return 0L;
            }
            return Math.min(end1, end2) - Math.max(offset1, offset2);
        }

        OrcSplit createSplit(long offset, long length, OrcTail orcTail) throws IOException {
            String[] hosts;
            Map.Entry<Long, BlockLocation> startEntry = this.locations.floorEntry(offset);
            BlockLocation start = startEntry.getValue();
            if (offset + length <= start.getOffset() + start.getLength()) {
                hosts = start.getHosts();
            } else {
                Map.Entry<Long, BlockLocation> endEntry = this.locations.floorEntry(offset + length);
                BlockLocation end = endEntry.getValue();
                NavigableMap<Long, BlockLocation> navigableMap = this.locations.subMap(startEntry.getKey(), true, endEntry.getKey(), true);
                HashMap<String, LongWritable> sizes = new HashMap<String, LongWritable>();
                long maxSize = 0L;
                for (BlockLocation block : navigableMap.values()) {
                    long overlap = SplitGenerator.getOverlap(offset, length, block.getOffset(), block.getLength());
                    if (overlap > 0L) {
                        for (String host : block.getHosts()) {
                            LongWritable val = (LongWritable)sizes.get(host);
                            if (val == null) {
                                val = new LongWritable();
                                sizes.put(host, val);
                            }
                            val.set(val.get() + overlap);
                            maxSize = Math.max(maxSize, val.get());
                        }
                        continue;
                    }
                    throw new IOException("File " + this.file.getPath().toString() + " should have had overlap on block starting at " + block.getOffset());
                }
                long threshold = (long)((double)maxSize * 0.8);
                ArrayList<String> hostList = new ArrayList<String>();
                for (BlockLocation block : navigableMap.values()) {
                    for (String host : block.getHosts()) {
                        if (!sizes.containsKey(host)) continue;
                        if (((LongWritable)sizes.get(host)).get() >= threshold) {
                            hostList.add(host);
                        }
                        sizes.remove(host);
                    }
                }
                hosts = new String[hostList.size()];
                hostList.toArray(hosts);
            }
            long fileLen = this.file.getLen();
            double splitRatio = (double)length / (double)fileLen;
            long scaledProjSize = this.projColsUncompressedSize > 0L ? (long)(splitRatio * (double)this.projColsUncompressedSize) : fileLen;
            return new OrcSplit(this.file.getPath(), offset, length, hosts, orcTail, this.isOriginal, this.hasBase, this.deltas, scaledProjSize, fileLen);
        }

        @Override
        public List<OrcSplit> call() throws IOException {
            if (this.ugi == null) {
                return this.callInternal();
            }
            try {
                return (List)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<OrcSplit>>(){

                    @Override
                    public List<OrcSplit> run() throws Exception {
                        return SplitGenerator.this.callInternal();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        private List<OrcSplit> callInternal() throws IOException {
            this.populateAndCacheStripeDetails();
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            boolean[] includeStripe = null;
            if (this.deltas.isEmpty()) {
                Reader.Options options = new Reader.Options();
                options.include(this.readerIncluded);
                OrcInputFormat.setSearchArgument(options, this.readerTypes == null ? this.fileTypes : this.readerTypes, this.context.conf, this.isOriginal, false);
                if (options.getSearchArgument() != null && this.writerVersion != OrcFile.WriterVersion.ORIGINAL) {
                    if (this.evolution.hasConversion()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Skipping split elimination for " + this.file.getPath() + " since the schema has data type conversion"));
                        }
                    } else {
                        SearchArgument sarg = options.getSearchArgument();
                        List<PredicateLeaf> sargLeaves = sarg.getLeaves();
                        int[] filterColumns = RecordReaderImpl.mapSargColumns(sargLeaves, this.evolution);
                        if (this.stripeStats != null) {
                            includeStripe = new boolean[this.stripes.size()];
                            for (int i = 0; i < this.stripes.size(); ++i) {
                                boolean bl = includeStripe[i] = i >= this.stripeStats.size() || this.isStripeSatisfyPredicate(this.stripeStats.get(i), sarg, filterColumns);
                                if (!LOG.isDebugEnabled() || includeStripe[i]) continue;
                                LOG.debug((Object)("Eliminating ORC stripe-" + i + " of file '" + this.file.getPath() + "'  as it did not satisfy " + "predicate condition."));
                            }
                        }
                    }
                }
            }
            if (includeStripe == null) {
                includeStripe = new boolean[this.stripes.size()];
                Arrays.fill(includeStripe, true);
            }
            long currentOffset = -1L;
            long currentLength = 0L;
            int idx = -1;
            for (StripeInformation stripe : this.stripes) {
                if (!includeStripe[++idx]) {
                    if (currentOffset == -1L) continue;
                    splits.add(this.createSplit(currentOffset, currentLength, this.orcTail));
                    currentOffset = -1L;
                    continue;
                }
                if (currentOffset != -1L && currentLength > this.context.minSize && currentOffset / this.blockSize != stripe.getOffset() / this.blockSize) {
                    splits.add(this.createSplit(currentOffset, currentLength, this.orcTail));
                    currentOffset = -1L;
                }
                if (currentOffset == -1L) {
                    currentOffset = stripe.getOffset();
                    currentLength = stripe.getLength();
                } else {
                    currentLength = stripe.getOffset() + stripe.getLength() - currentOffset;
                }
                if (currentLength < this.context.maxSize) continue;
                splits.add(this.createSplit(currentOffset, currentLength, this.orcTail));
                currentOffset = -1L;
            }
            if (currentOffset != -1L) {
                splits.add(this.createSplit(currentOffset, currentLength, this.orcTail));
            }
            splits.addAll(this.deltaSplits);
            return splits;
        }

        private void populateAndCacheStripeDetails() throws IOException {
            boolean[] fileIncluded;
            if (this.orcTail == null) {
                Reader orcReader = OrcFile.createReader(this.file.getPath(), OrcFile.readerOptions(this.context.conf).filesystem(this.fs).maxLength(this.file.getLen()));
                this.orcTail = new OrcTail(orcReader.getFileTail(), orcReader.getSerializedFileFooter(), this.file.getModificationTime());
                if (this.context.cacheStripeDetails) {
                    SplitGenerator splitGenerator = this;
                    Context.footerCache.put(this.file.getPath(), this.orcTail);
                }
            }
            this.stripes = this.orcTail.getStripes();
            this.stripeStats = this.orcTail.getStripeStatistics();
            this.fileTypes = this.orcTail.getTypes();
            TypeDescription fileSchema = OrcUtils.convertTypeFromProtobuf(this.fileTypes, 0);
            if (this.readerTypes == null) {
                this.readerIncluded = OrcInputFormat.genIncludedColumns(fileSchema, this.context.conf);
                this.evolution = new SchemaEvolution(fileSchema, this.readerIncluded);
            } else {
                TypeDescription readerSchema = OrcUtils.convertTypeFromProtobuf(this.readerTypes, 0);
                this.readerIncluded = OrcInputFormat.genIncludedColumns(readerSchema, this.context.conf);
                this.evolution = new SchemaEvolution(fileSchema, readerSchema, this.readerIncluded);
                if (!this.isOriginal) {
                    this.readerTypes = OrcUtils.getOrcTypes(this.evolution.getReaderSchema());
                }
            }
            this.writerVersion = this.orcTail.getWriterVersion();
            List<OrcProto.ColumnStatistics> fileColStats = this.orcTail.getFooter().getStatisticsList();
            if (this.readerTypes == null) {
                fileIncluded = this.readerIncluded;
            } else {
                fileIncluded = new boolean[this.fileTypes.size()];
                int readerSchemaSize = this.readerTypes.size();
                for (int i = 0; i < readerSchemaSize; ++i) {
                    TypeDescription fileType = this.evolution.getFileType(i);
                    if (fileType == null) continue;
                    fileIncluded[fileType.getId()] = true;
                }
            }
            this.projColsUncompressedSize = this.computeProjectionSize(this.fileTypes, fileColStats, fileIncluded);
            if (!this.context.footerInSplits) {
                this.orcTail = null;
            }
        }

        private long computeProjectionSize(List<OrcProto.Type> fileTypes, List<OrcProto.ColumnStatistics> stats, boolean[] fileIncluded) {
            ArrayList<Integer> internalColIds = Lists.newArrayList();
            if (fileIncluded == null) {
                for (int i = 0; i < fileTypes.size(); ++i) {
                    internalColIds.add(i);
                }
            } else {
                for (int i = 0; i < fileIncluded.length; ++i) {
                    if (!fileIncluded[i]) continue;
                    internalColIds.add(i);
                }
            }
            return ReaderImpl.getRawDataSizeFromColIndices(internalColIds, fileTypes, stats);
        }

        private boolean isStripeSatisfyPredicate(StripeStatistics stripeStatistics, SearchArgument sarg, int[] filterColumns) {
            List<PredicateLeaf> predLeaves = sarg.getLeaves();
            SearchArgument.TruthValue[] truthValues = new SearchArgument.TruthValue[predLeaves.size()];
            for (int pred = 0; pred < truthValues.length; ++pred) {
                if (filterColumns[pred] != -1) {
                    ColumnStatistics stats = stripeStatistics.getColumnStatistics()[filterColumns[pred]];
                    truthValues[pred] = RecordReaderImpl.evaluatePredicate(stats, predLeaves.get(pred), null);
                    continue;
                }
                truthValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
            }
            return sarg.evaluate(truthValues).isNeeded();
        }
    }

    static final class FileGenerator
    implements Callable<SplitStrategy> {
        private final Context context;
        private final FileSystem fs;
        private final Path dir;
        private final List<OrcProto.Type> readerTypes;
        private final UserGroupInformation ugi;

        FileGenerator(Context context, FileSystem fs, Path dir, List<OrcProto.Type> readerTypes, UserGroupInformation ugi) {
            this.context = context;
            this.fs = fs;
            this.dir = dir;
            this.readerTypes = readerTypes;
            this.ugi = ugi;
        }

        @Override
        public SplitStrategy call() throws IOException {
            if (this.ugi == null) {
                return this.callInternal();
            }
            try {
                return (SplitStrategy)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SplitStrategy>(){

                    @Override
                    public SplitStrategy run() throws Exception {
                        return FileGenerator.this.callInternal();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        private SplitStrategy callInternal() throws IOException {
            SplitStrategy<OrcSplit> splitStrategy;
            boolean isOriginal;
            AcidUtils.Directory dirInfo = AcidUtils.getAcidState(this.dir, this.context.conf, this.context.transactionList, true);
            List<AcidInputFormat.DeltaMetaData> deltas = AcidUtils.serializeDeltas(dirInfo.getCurrentDirectories());
            Path base = dirInfo.getBaseDirectory();
            List<FileStatus> original = dirInfo.getOriginalFiles();
            boolean[] covered = new boolean[this.context.numBuckets];
            boolean bl = isOriginal = base == null;
            if (base != null || !original.isEmpty()) {
                List<FileStatus> children = original;
                if (base != null) {
                    children = SHIMS.listLocatedStatus(this.fs, base, AcidUtils.hiddenFileFilter);
                }
                long totalFileSize = 0L;
                for (FileStatus child : children) {
                    totalFileSize += child.getLen();
                    AcidOutputFormat.Options opts = AcidUtils.parseBaseBucketFilename(child.getPath(), this.context.conf);
                    int b = opts.getBucket();
                    if (b < 0 || b >= covered.length) continue;
                    covered[b] = true;
                }
                int numFiles = children.size();
                long avgFileSize = totalFileSize / (long)numFiles;
                int totalFiles = this.context.numFilesCounter.addAndGet(numFiles);
                switch (this.context.splitStrategyKind) {
                    case BI: {
                        splitStrategy = new BISplitStrategy(this.context, this.fs, this.dir, children, this.readerTypes, isOriginal, deltas, covered);
                        break;
                    }
                    case ETL: {
                        splitStrategy = new ETLSplitStrategy(this.context, this.fs, this.dir, children, this.readerTypes, isOriginal, deltas, covered);
                        break;
                    }
                    default: {
                        if (avgFileSize > this.context.maxSize || totalFiles <= this.context.etlFileThreshold) {
                            splitStrategy = new ETLSplitStrategy(this.context, this.fs, this.dir, children, this.readerTypes, isOriginal, deltas, covered);
                            break;
                        }
                        splitStrategy = new BISplitStrategy(this.context, this.fs, this.dir, children, this.readerTypes, isOriginal, deltas, covered);
                        break;
                    }
                }
            } else {
                splitStrategy = new ACIDSplitStrategy(this.dir, this.context.numBuckets, deltas, covered);
            }
            return splitStrategy;
        }
    }

    static class ACIDSplitStrategy
    implements SplitStrategy<OrcSplit> {
        Path dir;
        List<AcidInputFormat.DeltaMetaData> deltas;
        boolean[] covered;
        int numBuckets;

        public ACIDSplitStrategy(Path dir, int numBuckets, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered) {
            this.dir = dir;
            this.numBuckets = numBuckets;
            this.deltas = deltas;
            this.covered = covered;
        }

        @Override
        public List<OrcSplit> getSplits() throws IOException {
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            if (!this.deltas.isEmpty()) {
                for (int b = 0; b < this.numBuckets; ++b) {
                    if (this.covered[b]) continue;
                    splits.add(new OrcSplit(this.dir, b, 0L, new String[0], null, false, false, this.deltas, -1L, -1L));
                }
            }
            return splits;
        }

        public String toString() {
            return ACIDSplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class BISplitStrategy
    extends ACIDSplitStrategy {
        List<FileStatus> fileStatuses;
        boolean isOriginal;
        List<AcidInputFormat.DeltaMetaData> deltas;
        FileSystem fs;
        Path dir;

        public BISplitStrategy(Context context, FileSystem fs, Path dir, List<FileStatus> fileStatuses, List<OrcProto.Type> readerTypes, boolean isOriginal, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered) {
            super(dir, context.numBuckets, deltas, covered);
            this.fileStatuses = fileStatuses;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.fs = fs;
            this.dir = dir;
        }

        @Override
        public List<OrcSplit> getSplits() throws IOException {
            ArrayList<OrcSplit> splits = Lists.newArrayList();
            for (FileStatus fileStatus : this.fileStatuses) {
                if (fileStatus.getLen() == 0L) continue;
                TreeMap<Long, BlockLocation> blockOffsets = SHIMS.getLocationsWithOffset(this.fs, fileStatus);
                for (Map.Entry<Long, BlockLocation> entry : blockOffsets.entrySet()) {
                    OrcSplit orcSplit = new OrcSplit(fileStatus.getPath(), entry.getKey(), entry.getValue().getLength(), entry.getValue().getHosts(), null, this.isOriginal, true, this.deltas, -1L, fileStatus.getLen());
                    splits.add(orcSplit);
                }
            }
            splits.addAll(super.getSplits());
            return splits;
        }

        @Override
        public String toString() {
            return BISplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class ETLSplitStrategy
    implements SplitStrategy<SplitInfo> {
        Context context;
        FileSystem fs;
        List<FileStatus> files;
        List<OrcProto.Type> readerTypes;
        boolean isOriginal;
        List<AcidInputFormat.DeltaMetaData> deltas;
        Path dir;
        boolean[] covered;

        public ETLSplitStrategy(Context context, FileSystem fs, Path dir, List<FileStatus> children, List<OrcProto.Type> readerTypes, boolean isOriginal, List<AcidInputFormat.DeltaMetaData> deltas, boolean[] covered) {
            this.context = context;
            this.dir = dir;
            this.fs = fs;
            this.files = children;
            this.readerTypes = readerTypes;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.covered = covered;
        }

        private OrcTail verifyCachedOrcTail(FileStatus file) {
            this.context.numFilesCounter.incrementAndGet();
            OrcTail orcTail = (OrcTail)Context.footerCache.getIfPresent(file.getPath());
            if (orcTail != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Info cached for path: " + file.getPath()));
                }
                if (orcTail.getFileModificationTime() == file.getModificationTime() && orcTail.getFileLength() == file.getLen()) {
                    this.context.cacheHitCounter.incrementAndGet();
                    return orcTail;
                }
                Context.footerCache.invalidate(file.getPath());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Meta-Info for : " + file.getPath() + " changed. CachedModificationTime: " + orcTail.getFileModificationTime() + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + orcTail.getFileLength() + ", CurrentLength: " + file.getLen()));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Info not cached for path: " + file.getPath()));
            }
            return null;
        }

        @Override
        public List<SplitInfo> getSplits() throws IOException {
            ArrayList<SplitInfo> result = Lists.newArrayList();
            for (FileStatus file : this.files) {
                OrcTail orcTail = null;
                if (this.context.cacheStripeDetails) {
                    orcTail = this.verifyCachedOrcTail(file);
                }
                if (file.getLen() <= 0L) continue;
                result.add(new SplitInfo(this.context, this.fs, file, orcTail, this.readerTypes, this.isOriginal, this.deltas, true, this.dir, this.covered));
            }
            return result;
        }

        public String toString() {
            return ETLSplitStrategy.class.getSimpleName() + " strategy for " + this.dir;
        }
    }

    static final class SplitInfo
    extends ACIDSplitStrategy {
        private final Context context;
        private final FileSystem fs;
        private final FileStatus file;
        private final OrcTail orcTail;
        private final List<OrcProto.Type> readerTypes;
        private final boolean isOriginal;
        private final List<AcidInputFormat.DeltaMetaData> deltas;
        private final boolean hasBase;

        SplitInfo(Context context, FileSystem fs, FileStatus file, OrcTail orcTail, List<OrcProto.Type> readerTypes, boolean isOriginal, List<AcidInputFormat.DeltaMetaData> deltas, boolean hasBase, Path dir, boolean[] covered) throws IOException {
            super(dir, context.numBuckets, deltas, covered);
            this.context = context;
            this.fs = fs;
            this.file = file;
            this.orcTail = orcTail;
            this.readerTypes = readerTypes;
            this.isOriginal = isOriginal;
            this.deltas = deltas;
            this.hasBase = hasBase;
        }
    }

    static interface SplitStrategy<T> {
        public List<T> getSplits() throws IOException;
    }

    static class Context {
        private final Configuration conf;
        private static Cache<Path, OrcTail> footerCache;
        private static ExecutorService threadPool;
        private final int numBuckets;
        private final long maxSize;
        private final long minSize;
        private final boolean footerInSplits;
        private final boolean cacheStripeDetails;
        private final boolean forceThreadpool;
        private final int etlFileThreshold;
        private final AtomicInteger cacheHitCounter = new AtomicInteger(0);
        private final AtomicInteger numFilesCounter = new AtomicInteger(0);
        private ValidTxnList transactionList;
        private SplitStrategyKind splitStrategyKind;

        Context(Configuration conf) {
            this(conf, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(Configuration conf, int minSplits) {
            this.conf = conf;
            this.minSize = conf.getLong(MIN_SPLIT_SIZE, 0x1000000L);
            this.maxSize = conf.getLong(MAX_SPLIT_SIZE, 0x10000000L);
            this.forceThreadpool = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_IN_TEST);
            String ss = conf.get(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname);
            if (ss == null || ss.equals(SplitStrategyKind.HYBRID.name())) {
                this.splitStrategyKind = SplitStrategyKind.HYBRID;
            } else {
                LOG.info((Object)("Enforcing " + ss + " ORC split strategy"));
                this.splitStrategyKind = SplitStrategyKind.valueOf(ss);
            }
            this.footerInSplits = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_INCLUDE_FILE_FOOTER_IN_SPLITS);
            this.numBuckets = Math.max(conf.getInt("bucket_count", 0), 0);
            LOG.debug((Object)("Number of buckets specified by conf file is " + this.numBuckets));
            int cacheStripeDetailsSize = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_SIZE);
            int numThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ORC_COMPUTE_SPLITS_NUM_THREADS);
            boolean useSoftReference = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_CACHE_USE_SOFT_REFERENCES);
            this.cacheStripeDetails = cacheStripeDetailsSize > 0;
            this.etlFileThreshold = minSplits <= 0 ? 100 : minSplits;
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                if (threadPool == null) {
                    threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ORC_GET_SPLITS #%d").build());
                }
                if (footerCache == null && this.cacheStripeDetails) {
                    CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(numThreads).maximumSize(cacheStripeDetailsSize);
                    if (useSoftReference) {
                        builder = builder.softValues();
                    }
                    footerCache = builder.build();
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                String value = conf.get("hive.txn.valid.txns");
                this.transactionList = value == null ? new ValidReadTxnList() : new ValidReadTxnList(value);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        static int getCurrentThreadPoolSize() {
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return threadPool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)threadPool).getPoolSize() : (threadPool == null ? 0 : -1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        static void resetThreadPool() {
            Class<Context> clazz = Context.class;
            synchronized (Context.class) {
                threadPool = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        static {
            threadPool = null;
        }
    }

    private static class OrcRecordReader
    implements org.apache.hadoop.mapred.RecordReader<NullWritable, OrcStruct>,
    StatsProvidingRecordReader {
        private final RecordReader reader;
        private final long offset;
        private final long length;
        private final int numColumns;
        private float progress = 0.0f;
        private final Reader file;
        private final SerDeStats stats;

        OrcRecordReader(Reader file, Configuration conf, FileSplit split) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            this.file = file;
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            this.offset = split.getStart();
            this.length = split.getLength();
            this.reader = OrcInputFormat.createReaderFromFile(file, conf, this.offset, this.length);
            this.stats = new SerDeStats();
        }

        public boolean next(NullWritable key, OrcStruct value) throws IOException {
            if (this.reader.hasNext()) {
                this.reader.next(value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public OrcStruct createValue() {
            return new OrcStruct(this.numColumns);
        }

        public long getPos() throws IOException {
            return this.offset + (long)(this.progress * (float)this.length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return this.progress;
        }

        @Override
        public SerDeStats getStats() {
            this.stats.setRawDataSize(this.file.getRawDataSize());
            this.stats.setRowCount(this.file.getNumberOfRows());
            return this.stats;
        }
    }

    static enum SplitStrategyKind {
        HYBRID,
        BI,
        ETL;

    }
}

