/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.Progressable;

public class OrcRecordUpdater
implements RecordUpdater {
    private static final Log LOG = LogFactory.getLog(OrcRecordUpdater.class);
    public static final String ACID_KEY_INDEX_NAME = "hive.acid.key.index";
    public static final String ACID_FORMAT = "_orc_acid_version";
    public static final String ACID_STATS = "hive.acid.stats";
    public static final int ORC_ACID_VERSION = 0;
    static final int INSERT_OPERATION = 0;
    static final int UPDATE_OPERATION = 1;
    static final int DELETE_OPERATION = 2;
    static final int OPERATION = 0;
    static final int ORIGINAL_TRANSACTION = 1;
    static final int BUCKET = 2;
    static final int ROW_ID = 3;
    static final int CURRENT_TRANSACTION = 4;
    static final int ROW = 5;
    static final int FIELDS = 6;
    static final int DELTA_BUFFER_SIZE = 16384;
    static final long DELTA_STRIPE_SIZE = 0x1000000L;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final AcidOutputFormat.Options options;
    private final Path path;
    private final FileSystem fs;
    private Writer writer;
    private final FSDataOutputStream flushLengths;
    private final OrcStruct item;
    private final IntWritable operation;
    private final LongWritable currentTransaction;
    private final LongWritable originalTransaction;
    private final IntWritable bucket;
    private final LongWritable rowId;
    private long insertedRows;
    private long rowIdOffset;
    private long rowCountDelta;
    private final KeyIndexBuilder indexBuilder;
    private StructField recIdField;
    private StructField rowIdField;
    private StructField originalTxnField;
    private StructObjectInspector rowInspector;
    private StructObjectInspector recIdInspector;
    private LongObjectInspector rowIdInspector;
    private LongObjectInspector origTxnInspector;
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final CharsetDecoder utf8Decoder = utf8.newDecoder();

    public static Path getSideFile(Path main) {
        return new Path(main + "_flush_length");
    }

    static int getOperation(OrcStruct struct) {
        return ((IntWritable)struct.getFieldValue(0)).get();
    }

    static long getCurrentTransaction(OrcStruct struct) {
        return ((LongWritable)struct.getFieldValue(4)).get();
    }

    static long getOriginalTransaction(OrcStruct struct) {
        return ((LongWritable)struct.getFieldValue(1)).get();
    }

    static int getBucket(OrcStruct struct) {
        return ((IntWritable)struct.getFieldValue(2)).get();
    }

    static long getRowId(OrcStruct struct) {
        return ((LongWritable)struct.getFieldValue(3)).get();
    }

    static OrcStruct getRow(OrcStruct struct) {
        if (struct == null) {
            return null;
        }
        return (OrcStruct)struct.getFieldValue(5);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.path + "]";
    }

    static StructObjectInspector createEventSchema(ObjectInspector rowInspector) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        fields.add(new OrcStruct.Field("operation", PrimitiveObjectInspectorFactory.writableIntObjectInspector, 0));
        fields.add(new OrcStruct.Field("originalTransaction", PrimitiveObjectInspectorFactory.writableLongObjectInspector, 1));
        fields.add(new OrcStruct.Field("bucket", PrimitiveObjectInspectorFactory.writableIntObjectInspector, 2));
        fields.add(new OrcStruct.Field("rowId", PrimitiveObjectInspectorFactory.writableLongObjectInspector, 3));
        fields.add(new OrcStruct.Field("currentTransaction", PrimitiveObjectInspectorFactory.writableLongObjectInspector, 4));
        fields.add(new OrcStruct.Field("row", rowInspector, 5));
        return new OrcStruct.OrcStructInspector(fields);
    }

    public static List<String> getAcidEventFields() {
        return Lists.newArrayList("operation", "originalTransaction", "bucket", "rowId", "currentTransaction", "row");
    }

    OrcRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
        FileSystem fs;
        block22: {
            this.operation = new IntWritable();
            this.currentTransaction = new LongWritable(-1L);
            this.originalTransaction = new LongWritable(-1L);
            this.bucket = new IntWritable();
            this.rowId = new LongWritable();
            this.insertedRows = 0L;
            this.rowIdOffset = 0L;
            this.rowCountDelta = 0L;
            this.indexBuilder = new KeyIndexBuilder();
            this.recIdField = null;
            this.rowIdField = null;
            this.originalTxnField = null;
            this.options = options;
            this.bucket.set(options.getBucket());
            this.path = AcidUtils.createFilename(path, options);
            fs = options.getFilesystem();
            if (fs == null) {
                fs = path.getFileSystem(options.getConfiguration());
            }
            this.fs = fs;
            Path formatFile = new Path(path, ACID_FORMAT);
            if (!fs.exists(formatFile)) {
                try (FSDataOutputStream strm = fs.create(formatFile, false);){
                    strm.writeInt(0);
                }
                catch (IOException ioe) {
                    if (!LOG.isDebugEnabled()) break block22;
                    LOG.debug((Object)("Failed to create " + path + "/" + ACID_FORMAT + " with " + ioe));
                }
            }
        }
        this.flushLengths = options.getMinimumTransactionId() != options.getMaximumTransactionId() && !options.isWritingBase() ? fs.create(OrcRecordUpdater.getSideFile(this.path), true, 8, (Progressable)options.getReporter()) : null;
        OrcFile.WriterOptions writerOptions = null;
        if (options.isWritingBase()) {
            if (options instanceof OrcOptions) {
                writerOptions = ((OrcOptions)options).getOrcOptions();
            }
            if (writerOptions == null) {
                writerOptions = OrcFile.writerOptions(options.getTableProperties(), options.getConfiguration());
            }
        } else {
            AcidOutputFormat.Options optionsCloneForDelta = options.clone();
            if (optionsCloneForDelta instanceof OrcOptions) {
                writerOptions = ((OrcOptions)optionsCloneForDelta).getOrcOptions();
            }
            if (writerOptions == null) {
                writerOptions = OrcFile.writerOptions(optionsCloneForDelta.getTableProperties(), optionsCloneForDelta.getConfiguration());
            }
            int baseBufferSizeValue = writerOptions.getBufferSize();
            long baseStripeSizeValue = writerOptions.getStripeSize();
            int ratio = HiveConf.getIntVar(options.getConfiguration(), HiveConf.ConfVars.HIVE_ORC_BASE_DELTA_RATIO);
            writerOptions.bufferSize(baseBufferSizeValue / ratio);
            writerOptions.stripeSize(baseStripeSizeValue / (long)ratio);
            writerOptions.blockPadding(false);
        }
        writerOptions.fileSystem(fs).callback(this.indexBuilder);
        this.rowInspector = (StructObjectInspector)options.getInspector();
        writerOptions.inspector(OrcRecordUpdater.createEventSchema(this.findRecId(options.getInspector(), options.getRecordIdColumn())));
        this.writer = OrcFile.createWriter(this.path, writerOptions);
        this.item = new OrcStruct(6);
        this.item.setFieldValue(0, this.operation);
        this.item.setFieldValue(4, this.currentTransaction);
        this.item.setFieldValue(1, this.originalTransaction);
        this.item.setFieldValue(2, this.bucket);
        this.item.setFieldValue(3, this.rowId);
    }

    private long findRowIdOffsetForInsert() throws IOException {
        if (this.options.getStatementId() <= 0) {
            return 0L;
        }
        long totalInserts = 0L;
        for (int pastStmt = this.options.getStatementId() - 1; pastStmt >= 0; --pastStmt) {
            Path matchingBucket = AcidUtils.createFilename(this.options.getFinalDestination(), this.options.clone().statementId(pastStmt));
            if (!this.fs.exists(matchingBucket)) continue;
            Reader reader = OrcFile.createReader(matchingBucket, OrcFile.readerOptions(this.options.getConfiguration()));
            AcidStats acidStats = OrcRecordUpdater.parseAcidStats(reader);
            if (acidStats.inserts <= 0L) continue;
            totalInserts += acidStats.inserts;
        }
        return totalInserts;
    }

    private ObjectInspector findRecId(ObjectInspector inspector, int rowIdColNum) {
        if (!(inspector instanceof StructObjectInspector)) {
            throw new RuntimeException("Serious problem, expected a StructObjectInspector, but got a " + inspector.getClass().getName());
        }
        if (rowIdColNum < 0) {
            return inspector;
        }
        RecIdStrippingObjectInspector newInspector = new RecIdStrippingObjectInspector(inspector, rowIdColNum);
        this.recIdField = newInspector.getRecId();
        List<? extends StructField> fields = ((StructObjectInspector)this.recIdField.getFieldObjectInspector()).getAllStructFieldRefs();
        this.originalTxnField = fields.get(0);
        this.origTxnInspector = (LongObjectInspector)this.originalTxnField.getFieldObjectInspector();
        this.rowIdField = fields.get(2);
        this.rowIdInspector = (LongObjectInspector)this.rowIdField.getFieldObjectInspector();
        this.recIdInspector = (StructObjectInspector)this.recIdField.getFieldObjectInspector();
        return newInspector;
    }

    private void addEvent(int operation, long currentTransaction, long rowId, Object row) throws IOException {
        this.operation.set(operation);
        this.currentTransaction.set(currentTransaction);
        long originalTransaction = currentTransaction;
        if (operation == 2 || operation == 1) {
            Object rowIdValue = this.rowInspector.getStructFieldData(row, this.recIdField);
            originalTransaction = this.origTxnInspector.get(this.recIdInspector.getStructFieldData(rowIdValue, this.originalTxnField));
            rowId = this.rowIdInspector.get(this.recIdInspector.getStructFieldData(rowIdValue, this.rowIdField));
        } else if (operation == 0) {
            rowId += this.rowIdOffset;
        }
        this.rowId.set(rowId);
        this.originalTransaction.set(originalTransaction);
        this.item.setFieldValue(5, operation == 2 ? null : row);
        this.indexBuilder.addKey(operation, originalTransaction, this.bucket.get(), rowId);
        this.writer.addRow(this.item);
    }

    @Override
    public void insert(long currentTransaction, Object row) throws IOException {
        if (this.currentTransaction.get() != currentTransaction) {
            this.insertedRows = 0L;
            this.rowIdOffset = this.findRowIdOffsetForInsert();
        }
        this.addEvent(0, currentTransaction, this.insertedRows++, row);
        ++this.rowCountDelta;
    }

    @Override
    public void update(long currentTransaction, Object row) throws IOException {
        if (this.currentTransaction.get() != currentTransaction) {
            this.insertedRows = 0L;
        }
        this.addEvent(1, currentTransaction, -1L, row);
    }

    @Override
    public void delete(long currentTransaction, Object row) throws IOException {
        if (this.currentTransaction.get() != currentTransaction) {
            this.insertedRows = 0L;
        }
        this.addEvent(2, currentTransaction, -1L, row);
        --this.rowCountDelta;
    }

    @Override
    public void flush() throws IOException {
        if (this.flushLengths == null) {
            throw new IllegalStateException("Attempting to flush a RecordUpdater on " + this.path + " with a single transaction.");
        }
        long len = this.writer.writeIntermediateFooter();
        this.flushLengths.writeLong(len);
        OrcInputFormat.SHIMS.hflush(this.flushLengths);
    }

    @Override
    public void close(boolean abort) throws IOException {
        if (abort) {
            if (this.flushLengths == null) {
                this.fs.delete(this.path, false);
            }
        } else if (this.writer != null) {
            this.writer.close();
        }
        if (this.flushLengths != null) {
            this.flushLengths.close();
            this.fs.delete(OrcRecordUpdater.getSideFile(this.path), false);
        }
        this.writer = null;
    }

    @Override
    public SerDeStats getStats() {
        SerDeStats stats = new SerDeStats();
        stats.setRowCount(this.rowCountDelta);
        return stats;
    }

    @VisibleForTesting
    Writer getWriter() {
        return this.writer;
    }

    static RecordIdentifier[] parseKeyIndex(Reader reader) {
        String[] stripes;
        try {
            ByteBuffer val = reader.getMetadataValue(ACID_KEY_INDEX_NAME).duplicate();
            stripes = utf8Decoder.decode(val).toString().split(";");
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Bad string encoding for hive.acid.key.index", e);
        }
        RecordIdentifier[] result = new RecordIdentifier[stripes.length];
        for (int i = 0; i < stripes.length; ++i) {
            if (stripes[i].length() == 0) continue;
            String[] parts = stripes[i].split(",");
            result[i] = new RecordIdentifier();
            result[i].setValues(Long.parseLong(parts[0]), Integer.parseInt(parts[1]), Long.parseLong(parts[2]));
        }
        return result;
    }

    static AcidStats parseAcidStats(Reader reader) {
        if (reader.hasMetadataValue(ACID_STATS)) {
            String statsSerialized;
            try {
                ByteBuffer val = reader.getMetadataValue(ACID_STATS).duplicate();
                statsSerialized = utf8Decoder.decode(val).toString();
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("Bad string encoding for hive.acid.stats", e);
            }
            return new AcidStats(statsSerialized);
        }
        return null;
    }

    private static class RecIdStrippingObjectInspector
    extends StructObjectInspector {
        private StructObjectInspector wrapped;
        List<StructField> fields;
        StructField recId;

        RecIdStrippingObjectInspector(ObjectInspector oi, int rowIdColNum) {
            if (!(oi instanceof StructObjectInspector)) {
                throw new RuntimeException("Serious problem, expected a StructObjectInspector, but got a " + oi.getClass().getName());
            }
            this.wrapped = (StructObjectInspector)oi;
            List<? extends StructField> wrappedFields = this.wrapped.getAllStructFieldRefs();
            this.fields = new ArrayList<StructField>(this.wrapped.getAllStructFieldRefs().size());
            for (int i = 0; i < wrappedFields.size(); ++i) {
                if (i == rowIdColNum) {
                    this.recId = wrappedFields.get(i);
                    continue;
                }
                this.fields.add(wrappedFields.get(i));
            }
        }

        @Override
        public List<? extends StructField> getAllStructFieldRefs() {
            return this.fields;
        }

        @Override
        public StructField getStructFieldRef(String fieldName) {
            return this.wrapped.getStructFieldRef(fieldName);
        }

        @Override
        public Object getStructFieldData(Object data, StructField fieldRef) {
            return this.wrapped.getStructFieldData(data, fieldRef);
        }

        @Override
        public List<Object> getStructFieldsDataAsList(Object data) {
            return this.wrapped.getStructFieldsDataAsList(data);
        }

        @Override
        public String getTypeName() {
            return this.wrapped.getTypeName();
        }

        @Override
        public ObjectInspector.Category getCategory() {
            return this.wrapped.getCategory();
        }

        StructField getRecId() {
            return this.recId;
        }
    }

    static class KeyIndexBuilder
    implements OrcFile.WriterCallback {
        StringBuilder lastKey = new StringBuilder();
        long lastTransaction;
        int lastBucket;
        long lastRowId;
        AcidStats acidStats = new AcidStats();

        KeyIndexBuilder() {
        }

        @Override
        public void preStripeWrite(OrcFile.WriterContext context) throws IOException {
            this.lastKey.append(this.lastTransaction);
            this.lastKey.append(',');
            this.lastKey.append(this.lastBucket);
            this.lastKey.append(',');
            this.lastKey.append(this.lastRowId);
            this.lastKey.append(';');
        }

        @Override
        public void preFooterWrite(OrcFile.WriterContext context) throws IOException {
            context.getWriter().addUserMetadata(OrcRecordUpdater.ACID_KEY_INDEX_NAME, UTF8.encode(this.lastKey.toString()));
            context.getWriter().addUserMetadata(OrcRecordUpdater.ACID_STATS, UTF8.encode(this.acidStats.serialize()));
        }

        void addKey(int op, long transaction, int bucket, long rowId) {
            switch (op) {
                case 0: {
                    ++this.acidStats.inserts;
                    break;
                }
                case 1: {
                    ++this.acidStats.updates;
                    break;
                }
                case 2: {
                    ++this.acidStats.deletes;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation " + op);
                }
            }
            this.lastTransaction = transaction;
            this.lastBucket = bucket;
            this.lastRowId = rowId;
        }
    }

    public static class OrcOptions
    extends AcidOutputFormat.Options {
        OrcFile.WriterOptions orcOptions = null;

        public OrcOptions(Configuration conf) {
            super(conf);
        }

        public OrcOptions orcOptions(OrcFile.WriterOptions opts) {
            this.orcOptions = opts;
            return this;
        }

        public OrcFile.WriterOptions getOrcOptions() {
            return this.orcOptions;
        }
    }

    static class AcidStats {
        long inserts;
        long updates;
        long deletes;

        AcidStats() {
        }

        AcidStats(String serialized) {
            String[] parts = serialized.split(",");
            this.inserts = Long.parseLong(parts[0]);
            this.updates = Long.parseLong(parts[1]);
            this.deletes = Long.parseLong(parts[2]);
        }

        String serialize() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.inserts);
            builder.append(",");
            builder.append(this.updates);
            builder.append(",");
            builder.append(this.deletes);
            return builder.toString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(" inserts: ").append(this.inserts);
            builder.append(" updates: ").append(this.updates);
            builder.append(" deletes: ").append(this.deletes);
            return builder.toString();
        }
    }
}

