/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.parquet.LeafFilterFactory;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class ParquetFilterPredicateConverter {
    private static final Log LOG = LogFactory.getLog(ParquetFilterPredicateConverter.class);

    public static FilterPredicate toFilterPredicate(SearchArgument sarg) {
        return ParquetFilterPredicateConverter.toFilterPredicate(sarg, null);
    }

    public static FilterPredicate toFilterPredicate(SearchArgument sarg, MessageType schema) {
        HashSet<String> columns = null;
        if (schema != null) {
            columns = new HashSet<String>();
            for (Type field : schema.getFields()) {
                columns.add(field.getName());
            }
        }
        return ParquetFilterPredicateConverter.translate(sarg.getExpression(), sarg.getLeaves(), columns);
    }

    private static FilterPredicate translate(ExpressionTree root, List<PredicateLeaf> leaves, Set<String> columns) {
        FilterPredicate p = null;
        switch (root.getOperator()) {
            case OR: {
                for (ExpressionTree child : root.getChildren()) {
                    if (p == null) {
                        p = ParquetFilterPredicateConverter.translate(child, leaves, columns);
                        continue;
                    }
                    FilterPredicate right = ParquetFilterPredicateConverter.translate(child, leaves, columns);
                    if (right == null) continue;
                    p = FilterApi.or(p, right);
                }
                return p;
            }
            case AND: {
                for (ExpressionTree child : root.getChildren()) {
                    if (p == null) {
                        p = ParquetFilterPredicateConverter.translate(child, leaves, columns);
                        continue;
                    }
                    FilterPredicate right = ParquetFilterPredicateConverter.translate(child, leaves, columns);
                    if (right == null) continue;
                    p = FilterApi.and(p, right);
                }
                return p;
            }
            case NOT: {
                FilterPredicate op = ParquetFilterPredicateConverter.translate(root.getChildren().get(0), leaves, columns);
                if (op != null) {
                    return FilterApi.not(op);
                }
                return null;
            }
            case LEAF: {
                PredicateLeaf leaf = leaves.get(root.getLeaf());
                if (columns == null || columns.contains(leaf.getColumnName())) {
                    return ParquetFilterPredicateConverter.buildFilterPredicateFromPredicateLeaf(leaf);
                }
                return null;
            }
            case CONSTANT: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)root.getOperator()));
    }

    private static FilterPredicate buildFilterPredicateFromPredicateLeaf(PredicateLeaf leaf) {
        LeafFilterFactory leafFilterFactory = new LeafFilterFactory();
        try {
            FilterPredicateLeafBuilder builder = leafFilterFactory.getLeafFilterBuilderByType(leaf.getType());
            if (builder == null) {
                return null;
            }
            if (ParquetFilterPredicateConverter.isMultiLiteralsOperator(leaf.getOperator())) {
                return builder.buildPredicate(leaf.getOperator(), leaf.getLiteralList(), leaf.getColumnName());
            }
            return builder.buildPredict(leaf.getOperator(), leaf.getLiteral(), leaf.getColumnName());
        }
        catch (Exception e) {
            LOG.error((Object)("fail to build predicate filter leaf with errors" + e), (Throwable)e);
            return null;
        }
    }

    private static boolean isMultiLiteralsOperator(PredicateLeaf.Operator op) {
        return op == PredicateLeaf.Operator.IN || op == PredicateLeaf.Operator.BETWEEN;
    }
}

