/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.mapred.InputFormat;

public class GenMRTableScan1
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        TableScanOperator op = (TableScanOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        Class<? extends InputFormat> inputFormat = ((TableScanDesc)op.getConf()).getTableMetadata().getInputFormatClass();
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        MapredWork currWork = GenMapRedUtils.getMapRedWork(parseCtx);
        MapRedTask currTask = (MapRedTask)TaskFactory.get(currWork, parseCtx.getConf(), new Task[0]);
        TableScanOperator currTopOp = op;
        ctx.setCurrTask(currTask);
        ctx.setCurrTopOp(currTopOp);
        for (String alias : parseCtx.getTopOps().keySet()) {
            Operator<? extends OperatorDesc> currOp = parseCtx.getTopOps().get(alias);
            if (currOp != op) continue;
            String currAliasId = alias;
            ctx.setCurrAliasId(currAliasId);
            mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(currTask, currAliasId));
            if (parseCtx.getQueryProperties().isAnalyzeCommand()) {
                boolean partialScan = parseCtx.getQueryProperties().isPartialScanAnalyzeCommand();
                boolean noScan = parseCtx.getQueryProperties().isNoScanAnalyzeCommand();
                if (inputFormat.equals(OrcInputFormat.class)) {
                    StatsNoJobWork snjWork = new StatsNoJobWork(((TableScanDesc)op.getConf()).getTableMetadata().getTableSpec());
                    snjWork.setStatsReliable(parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                    Set<Partition> confirmedParts = GenMapRedUtils.getConfirmedPartitionsForScan(op);
                    if (confirmedParts.size() > 0) {
                        Table source = ((TableScanDesc)op.getConf()).getTableMetadata();
                        List<String> partCols = GenMapRedUtils.getPartitionColumns(op);
                        PrunedPartitionList partList = new PrunedPartitionList(source, confirmedParts, partCols, false);
                        snjWork.setPrunedPartitionList(partList);
                    }
                    Task<StatsNoJobWork> snjTask = TaskFactory.get(snjWork, parseCtx.getConf(), new Task[0]);
                    ctx.setCurrTask(snjTask);
                    ctx.setCurrTopOp(null);
                    ctx.getRootTasks().clear();
                    ctx.getRootTasks().add(snjTask);
                } else {
                    Set<Partition> confirmedPartns;
                    StatsWork statsWork = new StatsWork(((TableScanDesc)op.getConf()).getTableMetadata().getTableSpec());
                    statsWork.setAggKey(((TableScanDesc)op.getConf()).getStatsAggPrefix());
                    statsWork.setStatsTmpDir(((TableScanDesc)op.getConf()).getTmpStatsDir());
                    statsWork.setSourceTask(currTask);
                    statsWork.setStatsReliable(parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                    Task<StatsWork> statsTask = TaskFactory.get(statsWork, parseCtx.getConf(), new Task[0]);
                    currTask.addDependentTask(statsTask);
                    if (!ctx.getRootTasks().contains(currTask)) {
                        ctx.getRootTasks().add(currTask);
                    }
                    if (noScan) {
                        statsTask.setParentTasks(null);
                        statsWork.setNoScanAnalyzeCommand(true);
                        ctx.getRootTasks().remove(currTask);
                        ctx.getRootTasks().add(statsTask);
                    }
                    if (partialScan) {
                        this.handlePartialScanCommand(op, ctx, parseCtx, currTask, statsWork, statsTask);
                    }
                    currWork.getMapWork().setGatheringStats(true);
                    if (currWork.getReduceWork() != null) {
                        currWork.getReduceWork().setGatheringStats(true);
                    }
                    if ((confirmedPartns = GenMapRedUtils.getConfirmedPartitionsForScan(op)).size() > 0) {
                        Table source = ((TableScanDesc)op.getConf()).getTableMetadata();
                        List<String> partCols = GenMapRedUtils.getPartitionColumns(op);
                        PrunedPartitionList partList = new PrunedPartitionList(source, confirmedPartns, partCols, false);
                        GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, ctx, partList);
                    } else {
                        GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, ctx);
                    }
                }
            }
            return true;
        }
        assert (false);
        return null;
    }

    private void handlePartialScanCommand(TableScanOperator op, GenMRProcContext ctx, ParseContext parseCtx, Task<? extends Serializable> currTask, StatsWork statsWork, Task<StatsWork> statsTask) throws SemanticException {
        String aggregationKey = ((TableScanDesc)op.getConf()).getStatsAggPrefix();
        StringBuffer aggregationKeyBuffer = new StringBuffer(aggregationKey);
        List<Path> inputPaths = GenMapRedUtils.getInputPathsForPartialScan(op, aggregationKeyBuffer);
        aggregationKey = aggregationKeyBuffer.toString();
        PartialScanWork scanWork = new PartialScanWork(inputPaths);
        scanWork.setMapperCannotSpanPartns(true);
        scanWork.setAggKey(aggregationKey);
        scanWork.setStatsTmpDir(((TableScanDesc)op.getConf()).getTmpStatsDir(), parseCtx.getConf());
        statsWork.setPartialScanAnalyzeCommand(true);
        DriverContext driverCxt = new DriverContext();
        Task<PartialScanWork> psTask = TaskFactory.get(scanWork, parseCtx.getConf(), new Task[0]);
        psTask.initialize(parseCtx.getConf(), null, driverCxt);
        psTask.setWork(scanWork);
        ctx.getRootTasks().remove(currTask);
        ctx.getRootTasks().add(psTask);
        psTask.addDependentTask(statsTask);
        ArrayList<Task<? extends Serializable>> parentTasks = new ArrayList<Task<? extends Serializable>>();
        parentTasks.add(psTask);
        statsTask.setParentTasks(parentTasks);
    }
}

