/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;

public class ExportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private ReplicationSpec replicationSpec;

    public ExportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        BaseSemanticAnalyzer.TableSpec ts;
        Tree tableTree = ast.getChild(0);
        Tree toTree = ast.getChild(1);
        this.replicationSpec = ast.getChildCount() > 2 ? new ReplicationSpec((ASTNode)ast.getChild(2)) : new ReplicationSpec();
        String tmpPath = ExportSemanticAnalyzer.stripQuotes(toTree.getText());
        URI toURI = EximUtil.getValidatedURI(this.conf, tmpPath);
        try {
            ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, (ASTNode)tableTree, false, true);
        }
        catch (SemanticException sme) {
            if (this.replicationSpec.isInReplicationScope() && (sme.getCause() instanceof InvalidTableException || sme instanceof Table.ValidationFailureSemanticException)) {
                ts = null;
            }
            throw sme;
        }
        ExportSemanticAnalyzer.prepareExport(ast, toURI, ts, this.replicationSpec, this.db, this.conf, this.ctx, this.rootTasks, this.inputs, this.outputs, this.LOG);
    }

    public static void prepareExport(ASTNode ast, URI toURI, BaseSemanticAnalyzer.TableSpec ts, ReplicationSpec replicationSpec, Hive db, HiveConf conf, Context ctx, List<Task<? extends Serializable>> rootTasks, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs, Logger LOG) throws SemanticException {
        if (ts != null) {
            try {
                EximUtil.validateTable(ts.tableHandle);
                if (replicationSpec.isInReplicationScope() && ts.tableHandle.isTemporary()) {
                    ts = null;
                } else if (ts.tableHandle.isView()) {
                    replicationSpec.setIsMetadataOnly(true);
                }
            }
            catch (SemanticException e) {
                if (replicationSpec.isInReplicationScope()) {
                    ts = null;
                }
                throw e;
            }
        }
        try {
            FileSystem fs = FileSystem.get((URI)toURI, (Configuration)conf);
            Path toPath = new Path(toURI.getScheme(), toURI.getAuthority(), toURI.getPath());
            try {
                FileStatus tgt = fs.getFileStatus(toPath);
                if (!tgt.isDir()) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "Target is not a directory : " + toURI));
                }
                FileStatus[] files = fs.listStatus(toPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (files != null && files.length != 0) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "Target is not an empty directory : " + toURI));
                }
            }
            catch (FileNotFoundException tgt) {}
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast), e);
        }
        PartitionIterable partitions = null;
        try {
            replicationSpec.setCurrentReplicationState(String.valueOf(db.getMSC().getCurrentNotificationEventId().getEventId()));
            partitions = ts != null && ts.tableHandle.isPartitioned() ? (ts.specType == BaseSemanticAnalyzer.TableSpec.SpecType.TABLE_ONLY ? (replicationSpec.isMetadataOnly() ? null : new PartitionIterable(db, ts.tableHandle, null, conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX))) : new PartitionIterable(ts.partitions)) : null;
            Path path = new Path(ctx.getLocalTmpPath(), "_metadata");
            EximUtil.createExportDump((FileSystem)FileSystem.getLocal((Configuration)conf), path, ts != null ? ts.tableHandle : null, partitions, replicationSpec);
            Task<?> rTask = ReplCopyTask.getDumpCopyTask(replicationSpec, path, new Path(toURI), conf);
            rootTasks.add(rTask);
            LOG.debug("_metadata file written into " + path.toString() + " and then copied to " + toURI.toString());
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.IO_ERROR.getMsg("Exception while writing out the local file"), e);
        }
        if (!replicationSpec.isMetadataOnly() && ts != null) {
            Path parentPath = new Path(toURI);
            if (ts.tableHandle.isPartitioned()) {
                for (Partition partition : partitions) {
                    Path fromPath = partition.getDataLocation();
                    Path toPartPath = new Path(parentPath, partition.getName());
                    Task<?> rTask = ReplCopyTask.getDumpCopyTask(replicationSpec, fromPath, toPartPath, conf);
                    rootTasks.add(rTask);
                    inputs.add(new ReadEntity(partition));
                }
            } else {
                Path fromPath = ts.tableHandle.getDataLocation();
                Path toDataPath = new Path(parentPath, "data");
                Task<?> rTask = ReplCopyTask.getDumpCopyTask(replicationSpec, fromPath, toDataPath, conf);
                rootTasks.add(rTask);
                inputs.add(new ReadEntity(ts.tableHandle));
            }
            outputs.add(ExportSemanticAnalyzer.toWriteEntity(parentPath, conf));
        }
    }
}

