/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_COORD_JOB", query="update CoordinatorJobBean w set w.appName = :appName, w.appPath = :appPath,w.concurrency = :concurrency, w.conf = :conf, w.externalId = :externalId, w.frequency = :frequency, w.lastActionNumber = :lastActionNumber, w.timeOut = :timeOut, w.timeZone = :timeZone, w.createdTimestamp = :createdTime, w.endTimestamp = :endTime, w.execution = :execution, w.jobXml = :jobXml, w.lastActionTimestamp = :lastAction, w.lastModifiedTimestamp = :lastModifiedTime, w.nextMaterializedTimestamp = :nextMaterializedTime, w.origJobXml = :origJobXml, w.slaXml=:slaXml, w.startTimestamp = :startTime, w.statusStr = :status, w.timeUnitStr = :timeUnit, w.appNamespace = :appNamespace, w.bundleId = :bundleId, w.matThrottling = :matThrottling  where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_STATUS", query="update CoordinatorJobBean w set w.statusStr =:status, w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_PENDING", query="update CoordinatorJobBean w set w.pending = :pending, w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_BUNDLEID", query="update CoordinatorJobBean w set w.bundleId = :bundleId where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_APPNAMESPACE", query="update CoordinatorJobBean w set w.appNamespace = :appNamespace where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_STATUS_PENDING", query="update CoordinatorJobBean w set w.statusStr = :status, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_BUNDLEID_APPNAMESPACE_PAUSETIME", query="update CoordinatorJobBean w set w.bundleId = :bundleId, w.appNamespace = :appNamespace, w.pauseTimestamp = :pauseTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_STATUS_MODTIME", query="update CoordinatorJobBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_STATUS_PENDING_MODTIME", query="update CoordinatorJobBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_LAST_MODIFIED_TIME", query="update CoordinatorJobBean w set w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_STATUS_PENDING_TIME", query="update CoordinatorJobBean w set w.statusStr = :status, w.pending = :pending, w.doneMaterialization = :doneMaterialization, w.lastModifiedTimestamp = :lastModifiedTime, w.suspendedTimestamp = :suspendedTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_MATERIALIZE", query="update CoordinatorJobBean w set w.statusStr = :status, w.pending = :pending, w.doneMaterialization = :doneMaterialization, w.lastActionTimestamp = :lastActionTime, w.lastActionNumber = :lastActionNumber, w.nextMaterializedTimestamp = :nextMatdTime where w.id = :id"), @NamedQuery(name="UPDATE_COORD_JOB_CHANGE", query="update CoordinatorJobBean w set w.endTimestamp = :endTime, w.statusStr = :status, w.pending = :pending, w.doneMaterialization = :doneMaterialization, w.concurrency = :concurrency, w.pauseTimestamp = :pauseTime, w.lastActionNumber = :lastActionNumber, w.lastActionTimestamp = :lastActionTime, w.nextMaterializedTimestamp = :nextMatdTime, w.lastModifiedTimestamp = :lastModifiedTime where w.id = :id"), @NamedQuery(name="DELETE_COORD_JOB", query="delete from CoordinatorJobBean w where w.id IN (:id)"), @NamedQuery(name="GET_COORD_JOBS", query="select OBJECT(w) from CoordinatorJobBean w"), @NamedQuery(name="GET_COORD_JOB", query="select OBJECT(w) from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_USER_APPNAME", query="select w.user, w.appName from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_INPUT_CHECK", query="select w.user, w.appName, w.statusStr, w.appNamespace, w.execution, w.frequency, w.timeUnitStr, w.timeZone, w.startTimestamp, w.endTimestamp, w.jobXml from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_ACTION_READY", query="select w.id, w.user, w.group, w.appName, w.statusStr, w.execution, w.concurrency, w.frequency, w.timeUnitStr, w.timeZone, w.startTimestamp, w.endTimestamp, w.jobXml from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_ACTION_KILL", query="select w.id, w.user, w.group, w.appName, w.statusStr from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_MATERIALIZE", query="select w.id, w.user, w.group, w.appName, w.statusStr, w.frequency, w.matThrottling, w.timeOut, w.timeZone, w.startTimestamp, w.endTimestamp, w.pauseTimestamp, w.nextMaterializedTimestamp, w.lastActionTimestamp, w.lastActionNumber, w.doneMaterialization, w.bundleId, w.conf, w.jobXml, w.appNamespace, w.timeUnitStr, w.execution from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_SUSPEND_KILL", query="select w.id, w.user, w.group, w.appName, w.statusStr, w.bundleId, w.appNamespace, w.doneMaterialization from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOBS_PENDING", query="select OBJECT(w) from CoordinatorJobBean w where w.pending = 1 order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_CHANGED", query="select OBJECT(w) from CoordinatorJobBean w where w.pending = 1 AND w.doneMaterialization = 1 AND w.lastModifiedTimestamp >= :lastModifiedTime"), @NamedQuery(name="GET_COORD_JOBS_COUNT", query="select count(w) from CoordinatorJobBean w"), @NamedQuery(name="GET_COORD_JOBS_COLUMNS", query="select w.id, w.appName, w.statusStr, w.user, w.group, w.startTimestamp, w.endTimestamp, w.appPath, w.concurrency, w.frequency, w.lastActionTimestamp, w.nextMaterializedTimestamp, w.createdTimestamp, w.timeUnitStr, w.timeZone, w.timeOut from CoordinatorJobBean w order by w.createdTimestamp desc"), @NamedQuery(name="GET_COORD_JOBS_OLDER_THAN", query="select OBJECT(w) from CoordinatorJobBean w where w.startTimestamp <= :matTime AND (w.statusStr = 'PREP' OR w.statusStr = 'RUNNING' or w.statusStr = 'RUNNINGWITHERROR') AND (w.nextMaterializedTimestamp < :matTime OR w.nextMaterializedTimestamp IS NULL) AND (w.nextMaterializedTimestamp IS NULL OR (w.endTimestamp > w.nextMaterializedTimestamp AND (w.pauseTimestamp IS NULL OR w.pauseTimestamp > w.nextMaterializedTimestamp))) order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_OLDER_FOR_MATERILZATION", query="select w.id from CoordinatorJobBean w where w.startTimestamp <= :matTime AND (w.statusStr = 'PREP' OR w.statusStr = 'RUNNING' or w.statusStr = 'RUNNINGWITHERROR') AND (w.nextMaterializedTimestamp < :matTime OR w.nextMaterializedTimestamp IS NULL) AND (w.nextMaterializedTimestamp IS NULL OR (w.endTimestamp > w.nextMaterializedTimestamp AND (w.pauseTimestamp IS NULL OR w.pauseTimestamp > w.nextMaterializedTimestamp))) and w.matThrottling > ( select count(a.jobId) from CoordinatorActionBean a where a.jobId = w.id and a.statusStr = 'WAITING') order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_OLDER_THAN_STATUS", query="select OBJECT(w) from CoordinatorJobBean w where w.statusStr = :status AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COMPLETED_COORD_JOBS_OLDER_THAN_STATUS", query="select OBJECT(w) from CoordinatorJobBean w where ( w.statusStr = 'SUCCEEDED' OR w.statusStr = 'FAILED' or w.statusStr = 'KILLED') AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COMPLETED_COORD_JOBS_WITH_NO_PARENT_OLDER_THAN_STATUS", query="select w.id from CoordinatorJobBean w where ( w.statusStr = 'SUCCEEDED' OR w.statusStr = 'FAILED' or w.statusStr = 'KILLED' or w.statusStr = 'DONEWITHERROR') AND w.lastModifiedTimestamp <= :lastModTime and w.bundleId is null order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_UNPAUSED", query="select OBJECT(w) from CoordinatorJobBean w where w.statusStr = 'RUNNING' OR w.statusStr = 'RUNNINGWITHERROR' OR w.statusStr = 'PREP' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_PAUSED", query="select OBJECT(w) from CoordinatorJobBean w where w.statusStr = 'PAUSED' OR w.statusStr = 'PAUSEDWITHERROR' OR w.statusStr = 'PREPPAUSED' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_FOR_BUNDLE", query="select OBJECT(w) from CoordinatorJobBean w where w.bundleId = :bundleId order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COORD_JOBS_WITH_PARENT_ID", query="select w.id from CoordinatorJobBean w where w.bundleId = :parentId"), @NamedQuery(name="GET_COORD_COUNT_WITH_PARENT_ID_NOT_READY_FOR_PURGE", query="select count(w) from CoordinatorJobBean w where w.bundleId = :parentId and (w.statusStr NOT IN ('SUCCEEDED', 'FAILED', 'KILLED', 'DONEWITHERROR') OR w.lastModifiedTimestamp >= :lastModTime)"), @NamedQuery(name="GET_COORD_JOB_FOR_USER_APPNAME", query="select w.user, w.appName from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_FOR_USER", query="select w.user from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_STATUS", query="select w.statusStr from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_JOB_STATUS_PARENTID", query="select w.statusStr, w.bundleId from CoordinatorJobBean w where w.id = :id"), @NamedQuery(name="GET_COORD_IDS_FOR_STATUS_TRANSIT", query="select DISTINCT w.id from CoordinatorActionBean a, CoordinatorJobBean w where w.id = a.jobId and a.lastModifiedTimestamp >= :lastModifiedTime and (w.statusStr IN ('PAUSED', 'RUNNING', 'RUNNINGWITHERROR', 'PAUSEDWITHERROR') or w.pending = 1)  and w.statusStr <> 'IGNORED'")})
@NamedNativeQueries(value={@NamedNativeQuery(name="GET_COORD_FOR_ABANDONEDCHECK", query="select w.id, w.USER_NAME, w.group_name, w.APP_NAME from coord_jobs w where ( w.STATUS = 'RUNNING' or w.STATUS = 'RUNNINGWITHERROR' ) and w.start_time < ?2 and w.created_time < ?2 and w.id in (select failedJobs.job_id from (select a.job_id from coord_actions a where ( a.STATUS = 'FAILED' or a.STATUS = 'TIMEDOUT'  or a.STATUS = 'SUSPENDED') group by a.job_id having count(*) >= ?1 ) failedJobs LEFT OUTER JOIN (select b.job_id from coord_actions b where b.STATUS = 'SUCCEEDED' group by b.job_id having count(*) > 0 ) successJobs   on  failedJobs.job_id = successJobs.job_id where successJobs.job_id is null )")})
@Table(name="COORD_JOBS")
public class CoordinatorJobBean
implements Writable,
CoordinatorJob,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="app_path")
    private String appPath = null;
    @Basic
    @Column(name="app_name")
    private String appName = null;
    @Basic
    @Column(name="external_id")
    private String externalId = null;
    @Basic
    @Column(name="conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob conf = null;
    @Basic
    @Column(name="frequency")
    private String frequency = "0";
    @Basic
    @Column(name="time_zone")
    private String timeZone = null;
    @Basic
    @Column(name="concurrency")
    private int concurrency = 0;
    @Basic
    @Column(name="mat_throttling")
    private int matThrottling = 0;
    @Basic
    @Column(name="time_out")
    private int timeOut = 0;
    @Basic
    @Column(name="last_action_number")
    private int lastActionNumber;
    @Basic
    @Column(name="user_name")
    private String user = null;
    @Basic
    @Column(name="group_name")
    private String group = null;
    @Basic
    @Index
    @Column(name="bundle_id")
    private String bundleId = null;
    @Transient
    private String consoleUrl;
    @Transient
    private List<CoordinatorActionBean> actions;
    @Transient
    private int numActions = 0;
    @Basic
    @Index
    @Column(name="status")
    private String statusStr = Job.Status.PREP.toString();
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Index
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Column(name="pause_time")
    private Timestamp pauseTimestamp = null;
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Column(name="time_unit")
    private String timeUnitStr = CoordinatorJob.Timeunit.NONE.toString();
    @Basic
    @Column(name="execution")
    private String execution = CoordinatorJob.Execution.FIFO.toString();
    @Basic
    @Column(name="last_action")
    private Timestamp lastActionTimestamp = null;
    @Basic
    @Index
    @Column(name="next_matd_time")
    private Timestamp nextMaterializedTimestamp = null;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Index
    @Column(name="suspended_time")
    private Timestamp suspendedTimestamp = null;
    @Basic
    @Column(name="job_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob jobXml = null;
    @Basic
    @Column(name="orig_job_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob origJobXml = null;
    @Basic
    @Column(name="sla_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob slaXml = null;
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Column(name="done_materialization")
    private int doneMaterialization = 0;
    @Basic
    @Column(name="app_namespace")
    private String appNamespace = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$StringBlob;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$CoordinatorJobBean;
    private transient Object pcDetachedState;

    public Timestamp getStartTimestamp() {
        return CoordinatorJobBean.pcGetstartTimestamp(this);
    }

    public void setStartTimestamp(Timestamp startTimestamp) {
        CoordinatorJobBean.pcSetstartTimestamp(this, startTimestamp);
    }

    public Timestamp getEndTimestamp() {
        return CoordinatorJobBean.pcGetendTimestamp(this);
    }

    public void setEndTimestamp(Timestamp endTimestamp) {
        CoordinatorJobBean.pcSetendTimestamp(this, endTimestamp);
    }

    public Timestamp getNextMaterializedTimestamp() {
        return CoordinatorJobBean.pcGetnextMaterializedTimestamp(this);
    }

    public void setNextMaterializedTimestamp(Timestamp nextMaterializedTimestamp) {
        CoordinatorJobBean.pcSetnextMaterializedTimestamp(this, nextMaterializedTimestamp);
    }

    public Timestamp getLastModifiedTimestamp() {
        return CoordinatorJobBean.pcGetlastModifiedTimestamp(this);
    }

    public void setLastModifiedTimestamp(Timestamp lastModifiedTimestamp) {
        CoordinatorJobBean.pcSetlastModifiedTimestamp(this, lastModifiedTimestamp);
    }

    public Timestamp getSuspendedTimestamp() {
        return CoordinatorJobBean.pcGetsuspendedTimestamp(this);
    }

    public void setSuspendedTimestamp(Timestamp suspendedTimestamp) {
        CoordinatorJobBean.pcSetsuspendedTimestamp(this, suspendedTimestamp);
    }

    public String getJobXml() {
        return CoordinatorJobBean.pcGetjobXml(this) == null ? null : CoordinatorJobBean.pcGetjobXml(this).getString();
    }

    public void setJobXml(String jobXml) {
        if (CoordinatorJobBean.pcGetjobXml(this) == null) {
            CoordinatorJobBean.pcSetjobXml(this, new StringBlob(jobXml));
        } else {
            CoordinatorJobBean.pcGetjobXml(this).setString(jobXml);
        }
    }

    public void setJobXmlBlob(StringBlob jobXmlBlob) {
        CoordinatorJobBean.pcSetjobXml(this, jobXmlBlob);
    }

    public StringBlob getJobXmlBlob() {
        return CoordinatorJobBean.pcGetjobXml(this);
    }

    public String getOrigJobXml() {
        return CoordinatorJobBean.pcGetorigJobXml(this) == null ? null : CoordinatorJobBean.pcGetorigJobXml(this).getString();
    }

    public void setOrigJobXml(String origJobXml) {
        if (CoordinatorJobBean.pcGetorigJobXml(this) == null) {
            CoordinatorJobBean.pcSetorigJobXml(this, new StringBlob(origJobXml));
        } else {
            CoordinatorJobBean.pcGetorigJobXml(this).setString(origJobXml);
        }
    }

    public void setOrigJobXmlBlob(StringBlob origJobXml) {
        CoordinatorJobBean.pcSetorigJobXml(this, origJobXml);
    }

    public StringBlob getOrigJobXmlBlob() {
        return CoordinatorJobBean.pcGetorigJobXml(this);
    }

    public String getSlaXml() {
        return CoordinatorJobBean.pcGetslaXml(this) == null ? null : CoordinatorJobBean.pcGetslaXml(this).getString();
    }

    public void setSlaXml(String slaXml) {
        if (CoordinatorJobBean.pcGetslaXml(this) == null) {
            CoordinatorJobBean.pcSetslaXml(this, new StringBlob(slaXml));
        } else {
            CoordinatorJobBean.pcGetslaXml(this).setString(slaXml);
        }
    }

    public void setSlaXmlBlob(StringBlob slaXml) {
        CoordinatorJobBean.pcSetslaXml(this, slaXml);
    }

    public StringBlob getSlaXmlBlob() {
        return CoordinatorJobBean.pcGetslaXml(this);
    }

    public void setLastActionTimestamp(Timestamp lastActionTimestamp) {
        CoordinatorJobBean.pcSetlastActionTimestamp(this, lastActionTimestamp);
    }

    public boolean isPending() {
        return CoordinatorJobBean.pcGetpending(this) == 1;
    }

    public void setDoneMaterialization() {
        CoordinatorJobBean.pcSetdoneMaterialization(this, 1);
    }

    public void setDoneMaterialization(int i) {
        CoordinatorJobBean.pcSetdoneMaterialization(this, i);
    }

    public void resetDoneMaterialization() {
        CoordinatorJobBean.pcSetdoneMaterialization(this, 0);
    }

    public boolean isDoneMaterialization() {
        return CoordinatorJobBean.pcGetdoneMaterialization(this) == 1;
    }

    public String getAppNamespace() {
        return CoordinatorJobBean.pcGetappNamespace(this);
    }

    public void setAppNamespace(String appNamespace) {
        CoordinatorJobBean.pcSetappNamespace(this, appNamespace);
    }

    public CoordinatorJobBean() {
        this.actions = new ArrayList<CoordinatorActionBean>();
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getAppPath());
        WritableUtils.writeStr(dataOutput, this.getAppName());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        WritableUtils.writeStr(dataOutput, this.getFrequency());
        WritableUtils.writeStr(dataOutput, this.getTimeUnit().toString());
        WritableUtils.writeStr(dataOutput, this.getTimeZone());
        dataOutput.writeInt(this.getConcurrency());
        WritableUtils.writeStr(dataOutput, this.getExecutionOrder().toString());
        dataOutput.writeLong(this.getLastActionTime() != null ? this.getLastActionTime().getTime() : -1L);
        dataOutput.writeLong(this.getNextMaterializedTime() != null ? this.getNextMaterializedTime().getTime() : -1L);
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getUser());
        WritableUtils.writeStr(dataOutput, this.getGroup());
        WritableUtils.writeStr(dataOutput, this.getExternalId());
        dataOutput.writeInt(this.getTimeout());
        dataOutput.writeInt(this.getMatThrottling());
        if (this.isPending()) {
            dataOutput.writeInt(1);
        } else {
            dataOutput.writeInt(0);
        }
        if (this.isDoneMaterialization()) {
            dataOutput.writeInt(1);
        } else {
            dataOutput.writeInt(0);
        }
        WritableUtils.writeStr(dataOutput, this.getAppNamespace());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setAppPath(WritableUtils.readStr(dataInput));
        this.setAppName(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(Job.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setFrequency(WritableUtils.readStr(dataInput));
        this.setTimeUnit(CoordinatorJob.Timeunit.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setTimeZone(WritableUtils.readStr(dataInput));
        this.setConcurrency(dataInput.readInt());
        this.setExecutionOrder(CoordinatorJob.Execution.valueOf((String)WritableUtils.readStr(dataInput)));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setLastActionTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setNextMaterializedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setStartTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        this.setUser(WritableUtils.readStr(dataInput));
        this.setGroup(WritableUtils.readStr(dataInput));
        this.setExternalId(WritableUtils.readStr(dataInput));
        this.setTimeout(dataInput.readInt());
        this.setMatThrottling(dataInput.readInt());
        d = dataInput.readInt();
        if (d == 1L) {
            this.setPending();
        }
        if ((d = (long)dataInput.readInt()) == 1L) {
            this.setDoneMaterialization();
        }
        this.setAppNamespace(WritableUtils.readStr(dataInput));
    }

    public boolean isTerminalStatus() {
        boolean isTerminal = false;
        switch (this.getStatus()) {
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: 
            case DONEWITHERROR: 
            case IGNORED: {
                isTerminal = true;
                break;
            }
            default: {
                isTerminal = false;
            }
        }
        return isTerminal;
    }

    public Job.Status getStatus() {
        return Job.Status.valueOf((String)CoordinatorJobBean.pcGetstatusStr(this));
    }

    public String getStatusStr() {
        return CoordinatorJobBean.pcGetstatusStr(this);
    }

    public void setStatusStr(String status) {
        CoordinatorJobBean.pcSetstatusStr(this, status);
    }

    public void setStatus(Job.Status val) {
        CoordinatorJobBean.pcSetstatusStr(this, val.toString());
    }

    public String getTimeUnitStr() {
        return CoordinatorJobBean.pcGettimeUnitStr(this);
    }

    public void setTimeUnitStr(String timeunit) {
        CoordinatorJobBean.pcSettimeUnitStr(this, timeunit);
    }

    public void setTimeUnit(CoordinatorJob.Timeunit timeUnit) {
        CoordinatorJobBean.pcSettimeUnitStr(this, timeUnit.toString());
    }

    public CoordinatorJob.Timeunit getTimeUnit() {
        return CoordinatorJob.Timeunit.valueOf((String)CoordinatorJobBean.pcGettimeUnitStr(this));
    }

    public void setExecutionOrder(CoordinatorJob.Execution order) {
        CoordinatorJobBean.pcSetexecution(this, order.toString());
    }

    public CoordinatorJob.Execution getExecutionOrder() {
        return CoordinatorJob.Execution.valueOf((String)CoordinatorJobBean.pcGetexecution(this));
    }

    public void setExecution(String order) {
        CoordinatorJobBean.pcSetexecution(this, order);
    }

    public String getExecution() {
        return CoordinatorJobBean.pcGetexecution(this);
    }

    public void setLastActionTime(Date lastAction) {
        CoordinatorJobBean.pcSetlastActionTimestamp(this, DateUtils.convertDateToTimestamp(lastAction));
    }

    public Date getLastActionTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetlastActionTimestamp(this));
    }

    public Timestamp getLastActionTimestamp() {
        return CoordinatorJobBean.pcGetlastActionTimestamp(this);
    }

    public void setNextMaterializedTime(Date nextMaterializedTime) {
        CoordinatorJobBean.pcSetnextMaterializedTimestamp(this, DateUtils.convertDateToTimestamp(nextMaterializedTime));
    }

    public Date getNextMaterializedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetnextMaterializedTimestamp(this));
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        CoordinatorJobBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetlastModifiedTimestamp(this));
    }

    public void setSuspendedTime(Date suspendedTime) {
        CoordinatorJobBean.pcSetsuspendedTimestamp(this, DateUtils.convertDateToTimestamp(suspendedTime));
    }

    public Date getSuspendedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetsuspendedTimestamp(this));
    }

    public void setStartTime(Date startTime) {
        CoordinatorJobBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    public Date getStartTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetstartTimestamp(this));
    }

    public void setEndTime(Date endTime) {
        CoordinatorJobBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    public void setPauseTime(Date pauseTime) {
        CoordinatorJobBean.pcSetpauseTimestamp(this, DateUtils.convertDateToTimestamp(pauseTime));
    }

    public Date getEndTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetendTimestamp(this));
    }

    public Date getPauseTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetpauseTimestamp(this));
    }

    public Timestamp getPauseTimestamp() {
        return CoordinatorJobBean.pcGetpauseTimestamp(this);
    }

    public void setCreatedTime(Date createTime) {
        CoordinatorJobBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createTime));
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(CoordinatorJobBean.pcGetcreatedTimestamp(this));
    }

    public Timestamp getCreatedTimestamp() {
        return CoordinatorJobBean.pcGetcreatedTimestamp(this);
    }

    public String getAppPath() {
        return CoordinatorJobBean.pcGetappPath(this);
    }

    public void setAppPath(String appPath) {
        CoordinatorJobBean.pcSetappPath(this, appPath);
    }

    public String getAppName() {
        return CoordinatorJobBean.pcGetappName(this);
    }

    public void setAppName(String appName) {
        CoordinatorJobBean.pcSetappName(this, appName);
    }

    public String getId() {
        return CoordinatorJobBean.pcGetid(this);
    }

    public void setId(String id) {
        CoordinatorJobBean.pcSetid(this, id);
    }

    public void setExternalId(String externalId) {
        CoordinatorJobBean.pcSetexternalId(this, externalId);
    }

    public String getExternalId() {
        return CoordinatorJobBean.pcGetexternalId(this);
    }

    public String getConf() {
        return CoordinatorJobBean.pcGetconf(this) == null ? null : CoordinatorJobBean.pcGetconf(this).getString();
    }

    public void setConf(String conf) {
        if (CoordinatorJobBean.pcGetconf(this) == null) {
            CoordinatorJobBean.pcSetconf(this, new StringBlob(conf));
        } else {
            CoordinatorJobBean.pcGetconf(this).setString(conf);
        }
    }

    public void setConfBlob(StringBlob conf) {
        CoordinatorJobBean.pcSetconf(this, conf);
    }

    public StringBlob getConfBlob() {
        return CoordinatorJobBean.pcGetconf(this);
    }

    public void setFrequency(String frequency) {
        CoordinatorJobBean.pcSetfrequency(this, frequency);
    }

    public String getFrequency() {
        return CoordinatorJobBean.pcGetfrequency(this);
    }

    public void setTimeZone(String timeZone) {
        CoordinatorJobBean.pcSettimeZone(this, timeZone);
    }

    public String getTimeZone() {
        return CoordinatorJobBean.pcGettimeZone(this);
    }

    public void setConcurrency(int concurrency) {
        CoordinatorJobBean.pcSetconcurrency(this, concurrency);
    }

    public int getConcurrency() {
        return CoordinatorJobBean.pcGetconcurrency(this);
    }

    public int getMatThrottling() {
        return CoordinatorJobBean.pcGetmatThrottling(this);
    }

    public void setMatThrottling(int matThrottling) {
        CoordinatorJobBean.pcSetmatThrottling(this, matThrottling);
    }

    public void setTimeout(int timeOut) {
        CoordinatorJobBean.pcSettimeOut(this, timeOut);
    }

    public int getTimeout() {
        return CoordinatorJobBean.pcGettimeOut(this);
    }

    public String getUser() {
        return CoordinatorJobBean.pcGetuser(this);
    }

    public void setUser(String user) {
        CoordinatorJobBean.pcSetuser(this, user);
    }

    public String getGroup() {
        return CoordinatorJobBean.pcGetgroup(this);
    }

    public String getAcl() {
        return this.getGroup();
    }

    public void setGroup(String group) {
        CoordinatorJobBean.pcSetgroup(this, group);
    }

    public String getBundleId() {
        return CoordinatorJobBean.pcGetbundleId(this);
    }

    public void setBundleId(String bundleId) {
        CoordinatorJobBean.pcSetbundleId(this, bundleId);
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public String toString() {
        return MessageFormat.format("Coordinator application id[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public void setActions(List<CoordinatorActionBean> nodes) {
        this.actions = nodes != null ? nodes : new ArrayList();
    }

    public List<CoordinatorAction> getActions() {
        return this.actions;
    }

    public static JSONArray toJSONArray(List<CoordinatorJobBean> applications, String timeZoneId) {
        JSONArray array = new JSONArray();
        if (applications != null) {
            for (CoordinatorJobBean application : applications) {
                array.add((Object)application.toJSONObject(timeZoneId));
            }
        }
        return array;
    }

    public int getLastActionNumber() {
        return CoordinatorJobBean.pcGetlastActionNumber(this);
    }

    public void setLastActionNumber(int lastActionNumber) {
        CoordinatorJobBean.pcSetlastActionNumber(this, lastActionNumber);
    }

    public void setPending() {
        CoordinatorJobBean.pcSetpending(this, 1);
    }

    public void resetPending() {
        CoordinatorJobBean.pcSetpending(this, 0);
    }

    public int getNumActions() {
        return this.numActions;
    }

    public void setNumActions(int numAction) {
        this.numActions = numAction;
    }

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"coordJobPath", (Object)this.getAppPath());
        json.put((Object)"coordJobName", (Object)this.getAppName());
        json.put((Object)"coordJobId", (Object)this.getId());
        json.put((Object)"coordExternalId", (Object)this.getExternalId());
        json.put((Object)"bundleId", (Object)this.getBundleId());
        json.put((Object)"conf", (Object)this.getConf());
        json.put((Object)"status", (Object)this.getStatus().toString());
        json.put((Object)"executionPolicy", (Object)this.getExecutionOrder().toString());
        json.put((Object)"frequency", (Object)this.getFrequency());
        json.put((Object)"timeUnit", (Object)this.getTimeUnit().toString());
        json.put((Object)"timeZone", (Object)this.getTimeZone());
        json.put((Object)"concurrency", (Object)this.getConcurrency());
        json.put((Object)"timeOut", (Object)this.getTimeout());
        json.put((Object)"lastAction", (Object)JsonUtils.formatDateRfc822((Date)this.getLastActionTime(), (String)timeZoneId));
        json.put((Object)"nextMaterializedTime", (Object)JsonUtils.formatDateRfc822((Date)this.getNextMaterializedTime(), (String)timeZoneId));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"pauseTime", (Object)JsonUtils.formatDateRfc822((Date)this.getPauseTime(), (String)timeZoneId));
        json.put((Object)"user", (Object)this.getUser());
        json.put((Object)"group", (Object)this.getGroup());
        json.put((Object)"acl", (Object)this.getAcl());
        json.put((Object)"consoleUrl", (Object)this.getConsoleUrl());
        json.put((Object)"mat_throttling", (Object)this.getMatThrottling());
        json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(this.actions, timeZoneId));
        json.put((Object)"toString", (Object)this.toString());
        json.put((Object)"total", (Object)this.numActions);
        return json;
    }

    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static {
        pcFieldNames = new String[]{"appName", "appNamespace", "appPath", "bundleId", "concurrency", "conf", "createdTimestamp", "doneMaterialization", "endTimestamp", "execution", "externalId", "frequency", "group", "id", "jobXml", "lastActionNumber", "lastActionTimestamp", "lastModifiedTimestamp", "matThrottling", "nextMaterializedTimestamp", "origJobXml", "pauseTimestamp", "pending", "slaXml", "startTimestamp", "statusStr", "suspendedTimestamp", "timeOut", "timeUnitStr", "timeZone", "user"};
        Class[] classArray = new Class[31];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[4] = Integer.TYPE;
        Class clazz2 = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[5] = clazz2;
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[6] = clazz3;
        classArray[7] = Integer.TYPE;
        classArray[8] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[14] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[15] = Integer.TYPE;
        classArray[16] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[17] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[18] = Integer.TYPE;
        classArray[19] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[20] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[21] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[22] = Integer.TYPE;
        classArray[23] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = CoordinatorJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[24] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[25] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[26] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = CoordinatorJobBean.class$("java.sql.Timestamp"));
        classArray[27] = Integer.TYPE;
        classArray[28] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[29] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        classArray[30] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CoordinatorJobBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 10, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$CoordinatorJobBean != null ? class$Lorg$apache$oozie$CoordinatorJobBean : (class$Lorg$apache$oozie$CoordinatorJobBean = CoordinatorJobBean.class$("org.apache.oozie.CoordinatorJobBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"CoordinatorJobBean", (PersistenceCapable)new CoordinatorJobBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.appName = null;
        this.appNamespace = null;
        this.appPath = null;
        this.bundleId = null;
        this.concurrency = 0;
        this.conf = null;
        this.createdTimestamp = null;
        this.doneMaterialization = 0;
        this.endTimestamp = null;
        this.execution = null;
        this.externalId = null;
        this.frequency = null;
        this.group = null;
        this.id = null;
        this.jobXml = null;
        this.lastActionNumber = 0;
        this.lastActionTimestamp = null;
        this.lastModifiedTimestamp = null;
        this.matThrottling = 0;
        this.nextMaterializedTimestamp = null;
        this.origJobXml = null;
        this.pauseTimestamp = null;
        this.pending = 0;
        this.slaXml = null;
        this.startTimestamp = null;
        this.statusStr = null;
        this.suspendedTimestamp = null;
        this.timeOut = 0;
        this.timeUnitStr = null;
        this.timeZone = null;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        CoordinatorJobBean coordinatorJobBean = new CoordinatorJobBean();
        if (bl) {
            coordinatorJobBean.pcClearFields();
        }
        coordinatorJobBean.pcStateManager = stateManager;
        coordinatorJobBean.pcCopyKeyFieldsFromObjectId(object);
        return coordinatorJobBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        CoordinatorJobBean coordinatorJobBean = new CoordinatorJobBean();
        if (bl) {
            coordinatorJobBean.pcClearFields();
        }
        coordinatorJobBean.pcStateManager = stateManager;
        return coordinatorJobBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 31;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.appNamespace = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.appPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.bundleId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.concurrency = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.conf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.doneMaterialization = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.execution = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.frequency = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.group = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.jobXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.lastActionNumber = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.lastActionTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.matThrottling = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.nextMaterializedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.origJobXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.pauseTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.slaXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.statusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.suspendedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.timeOut = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 28: {
                this.timeUnitStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 29: {
                this.timeZone = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 30: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appNamespace);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appPath);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.bundleId);
                return;
            }
            case 4: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.concurrency);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.conf);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 7: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.doneMaterialization);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.execution);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.frequency);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.group);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.jobXml);
                return;
            }
            case 15: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.lastActionNumber);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastActionTimestamp);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 18: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.matThrottling);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.nextMaterializedTimestamp);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.origJobXml);
                return;
            }
            case 21: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pauseTimestamp);
                return;
            }
            case 22: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 23: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.slaXml);
                return;
            }
            case 24: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 25: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.statusStr);
                return;
            }
            case 26: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspendedTimestamp);
                return;
            }
            case 27: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.timeOut);
                return;
            }
            case 28: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeUnitStr);
                return;
            }
            case 29: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeZone);
                return;
            }
            case 30: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(CoordinatorJobBean coordinatorJobBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = coordinatorJobBean.appName;
                return;
            }
            case 1: {
                this.appNamespace = coordinatorJobBean.appNamespace;
                return;
            }
            case 2: {
                this.appPath = coordinatorJobBean.appPath;
                return;
            }
            case 3: {
                this.bundleId = coordinatorJobBean.bundleId;
                return;
            }
            case 4: {
                this.concurrency = coordinatorJobBean.concurrency;
                return;
            }
            case 5: {
                this.conf = coordinatorJobBean.conf;
                return;
            }
            case 6: {
                this.createdTimestamp = coordinatorJobBean.createdTimestamp;
                return;
            }
            case 7: {
                this.doneMaterialization = coordinatorJobBean.doneMaterialization;
                return;
            }
            case 8: {
                this.endTimestamp = coordinatorJobBean.endTimestamp;
                return;
            }
            case 9: {
                this.execution = coordinatorJobBean.execution;
                return;
            }
            case 10: {
                this.externalId = coordinatorJobBean.externalId;
                return;
            }
            case 11: {
                this.frequency = coordinatorJobBean.frequency;
                return;
            }
            case 12: {
                this.group = coordinatorJobBean.group;
                return;
            }
            case 13: {
                this.id = coordinatorJobBean.id;
                return;
            }
            case 14: {
                this.jobXml = coordinatorJobBean.jobXml;
                return;
            }
            case 15: {
                this.lastActionNumber = coordinatorJobBean.lastActionNumber;
                return;
            }
            case 16: {
                this.lastActionTimestamp = coordinatorJobBean.lastActionTimestamp;
                return;
            }
            case 17: {
                this.lastModifiedTimestamp = coordinatorJobBean.lastModifiedTimestamp;
                return;
            }
            case 18: {
                this.matThrottling = coordinatorJobBean.matThrottling;
                return;
            }
            case 19: {
                this.nextMaterializedTimestamp = coordinatorJobBean.nextMaterializedTimestamp;
                return;
            }
            case 20: {
                this.origJobXml = coordinatorJobBean.origJobXml;
                return;
            }
            case 21: {
                this.pauseTimestamp = coordinatorJobBean.pauseTimestamp;
                return;
            }
            case 22: {
                this.pending = coordinatorJobBean.pending;
                return;
            }
            case 23: {
                this.slaXml = coordinatorJobBean.slaXml;
                return;
            }
            case 24: {
                this.startTimestamp = coordinatorJobBean.startTimestamp;
                return;
            }
            case 25: {
                this.statusStr = coordinatorJobBean.statusStr;
                return;
            }
            case 26: {
                this.suspendedTimestamp = coordinatorJobBean.suspendedTimestamp;
                return;
            }
            case 27: {
                this.timeOut = coordinatorJobBean.timeOut;
                return;
            }
            case 28: {
                this.timeUnitStr = coordinatorJobBean.timeUnitStr;
                return;
            }
            case 29: {
                this.timeZone = coordinatorJobBean.timeZone;
                return;
            }
            case 30: {
                this.user = coordinatorJobBean.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        CoordinatorJobBean coordinatorJobBean = (CoordinatorJobBean)object;
        if (coordinatorJobBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(coordinatorJobBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(13 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$CoordinatorJobBean != null ? class$Lorg$apache$oozie$CoordinatorJobBean : (class$Lorg$apache$oozie$CoordinatorJobBean = CoordinatorJobBean.class$("org.apache.oozie.CoordinatorJobBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$CoordinatorJobBean != null ? class$Lorg$apache$oozie$CoordinatorJobBean : (class$Lorg$apache$oozie$CoordinatorJobBean = CoordinatorJobBean.class$("org.apache.oozie.CoordinatorJobBean"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetappName(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.appName;
        }
        int n = pcInheritedFieldCount + 0;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.appName;
    }

    private static final void pcSetappName(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.appName = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 0, coordinatorJobBean.appName, string, 0);
    }

    private static final String pcGetappNamespace(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.appNamespace;
        }
        int n = pcInheritedFieldCount + 1;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.appNamespace;
    }

    private static final void pcSetappNamespace(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.appNamespace = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 1, coordinatorJobBean.appNamespace, string, 0);
    }

    private static final String pcGetappPath(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.appPath;
        }
        int n = pcInheritedFieldCount + 2;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.appPath;
    }

    private static final void pcSetappPath(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.appPath = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 2, coordinatorJobBean.appPath, string, 0);
    }

    private static final String pcGetbundleId(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.bundleId;
        }
        int n = pcInheritedFieldCount + 3;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.bundleId;
    }

    private static final void pcSetbundleId(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.bundleId = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 3, coordinatorJobBean.bundleId, string, 0);
    }

    private static final int pcGetconcurrency(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.concurrency;
        }
        int n = pcInheritedFieldCount + 4;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.concurrency;
    }

    private static final void pcSetconcurrency(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.concurrency = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 4, coordinatorJobBean.concurrency, n, 0);
    }

    private static final StringBlob pcGetconf(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.conf;
        }
        int n = pcInheritedFieldCount + 5;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.conf;
    }

    private static final void pcSetconf(CoordinatorJobBean coordinatorJobBean, StringBlob stringBlob) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.conf = stringBlob;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 5, (Object)coordinatorJobBean.conf, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetcreatedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 6;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.createdTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 6, (Object)coordinatorJobBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetdoneMaterialization(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.doneMaterialization;
        }
        int n = pcInheritedFieldCount + 7;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.doneMaterialization;
    }

    private static final void pcSetdoneMaterialization(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.doneMaterialization = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 7, coordinatorJobBean.doneMaterialization, n, 0);
    }

    private static final Timestamp pcGetendTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 8;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.endTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 8, (Object)coordinatorJobBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexecution(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.execution;
        }
        int n = pcInheritedFieldCount + 9;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.execution;
    }

    private static final void pcSetexecution(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.execution = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 9, coordinatorJobBean.execution, string, 0);
    }

    private static final String pcGetexternalId(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.externalId;
        }
        int n = pcInheritedFieldCount + 10;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.externalId;
    }

    private static final void pcSetexternalId(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.externalId = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 10, coordinatorJobBean.externalId, string, 0);
    }

    private static final String pcGetfrequency(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.frequency;
        }
        int n = pcInheritedFieldCount + 11;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.frequency;
    }

    private static final void pcSetfrequency(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.frequency = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 11, coordinatorJobBean.frequency, string, 0);
    }

    private static final String pcGetgroup(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.group;
        }
        int n = pcInheritedFieldCount + 12;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.group;
    }

    private static final void pcSetgroup(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.group = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 12, coordinatorJobBean.group, string, 0);
    }

    private static final String pcGetid(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.id;
        }
        int n = pcInheritedFieldCount + 13;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.id;
    }

    private static final void pcSetid(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.id = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 13, coordinatorJobBean.id, string, 0);
    }

    private static final StringBlob pcGetjobXml(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.jobXml;
        }
        int n = pcInheritedFieldCount + 14;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.jobXml;
    }

    private static final void pcSetjobXml(CoordinatorJobBean coordinatorJobBean, StringBlob stringBlob) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.jobXml = stringBlob;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 14, (Object)coordinatorJobBean.jobXml, (Object)stringBlob, 0);
    }

    private static final int pcGetlastActionNumber(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.lastActionNumber;
        }
        int n = pcInheritedFieldCount + 15;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.lastActionNumber;
    }

    private static final void pcSetlastActionNumber(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.lastActionNumber = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 15, coordinatorJobBean.lastActionNumber, n, 0);
    }

    private static final Timestamp pcGetlastActionTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.lastActionTimestamp;
        }
        int n = pcInheritedFieldCount + 16;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.lastActionTimestamp;
    }

    private static final void pcSetlastActionTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.lastActionTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 16, (Object)coordinatorJobBean.lastActionTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 17;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.lastModifiedTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 17, (Object)coordinatorJobBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetmatThrottling(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.matThrottling;
        }
        int n = pcInheritedFieldCount + 18;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.matThrottling;
    }

    private static final void pcSetmatThrottling(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.matThrottling = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 18, coordinatorJobBean.matThrottling, n, 0);
    }

    private static final Timestamp pcGetnextMaterializedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.nextMaterializedTimestamp;
        }
        int n = pcInheritedFieldCount + 19;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.nextMaterializedTimestamp;
    }

    private static final void pcSetnextMaterializedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.nextMaterializedTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 19, (Object)coordinatorJobBean.nextMaterializedTimestamp, (Object)timestamp, 0);
    }

    private static final StringBlob pcGetorigJobXml(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.origJobXml;
        }
        int n = pcInheritedFieldCount + 20;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.origJobXml;
    }

    private static final void pcSetorigJobXml(CoordinatorJobBean coordinatorJobBean, StringBlob stringBlob) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.origJobXml = stringBlob;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 20, (Object)coordinatorJobBean.origJobXml, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetpauseTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.pauseTimestamp;
        }
        int n = pcInheritedFieldCount + 21;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.pauseTimestamp;
    }

    private static final void pcSetpauseTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.pauseTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 21, (Object)coordinatorJobBean.pauseTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.pending;
        }
        int n = pcInheritedFieldCount + 22;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.pending;
    }

    private static final void pcSetpending(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.pending = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 22, coordinatorJobBean.pending, n, 0);
    }

    private static final StringBlob pcGetslaXml(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.slaXml;
        }
        int n = pcInheritedFieldCount + 23;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.slaXml;
    }

    private static final void pcSetslaXml(CoordinatorJobBean coordinatorJobBean, StringBlob stringBlob) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.slaXml = stringBlob;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 23, (Object)coordinatorJobBean.slaXml, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetstartTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 24;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.startTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 24, (Object)coordinatorJobBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatusStr(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.statusStr;
        }
        int n = pcInheritedFieldCount + 25;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.statusStr;
    }

    private static final void pcSetstatusStr(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.statusStr = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 25, coordinatorJobBean.statusStr, string, 0);
    }

    private static final Timestamp pcGetsuspendedTimestamp(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.suspendedTimestamp;
        }
        int n = pcInheritedFieldCount + 26;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.suspendedTimestamp;
    }

    private static final void pcSetsuspendedTimestamp(CoordinatorJobBean coordinatorJobBean, Timestamp timestamp) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.suspendedTimestamp = timestamp;
            return;
        }
        coordinatorJobBean.pcStateManager.settingObjectField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 26, (Object)coordinatorJobBean.suspendedTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGettimeOut(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.timeOut;
        }
        int n = pcInheritedFieldCount + 27;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.timeOut;
    }

    private static final void pcSettimeOut(CoordinatorJobBean coordinatorJobBean, int n) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.timeOut = n;
            return;
        }
        coordinatorJobBean.pcStateManager.settingIntField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 27, coordinatorJobBean.timeOut, n, 0);
    }

    private static final String pcGettimeUnitStr(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.timeUnitStr;
        }
        int n = pcInheritedFieldCount + 28;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.timeUnitStr;
    }

    private static final void pcSettimeUnitStr(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.timeUnitStr = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 28, coordinatorJobBean.timeUnitStr, string, 0);
    }

    private static final String pcGettimeZone(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.timeZone;
        }
        int n = pcInheritedFieldCount + 29;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.timeZone;
    }

    private static final void pcSettimeZone(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.timeZone = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 29, coordinatorJobBean.timeZone, string, 0);
    }

    private static final String pcGetuser(CoordinatorJobBean coordinatorJobBean) {
        if (coordinatorJobBean.pcStateManager == null) {
            return coordinatorJobBean.user;
        }
        int n = pcInheritedFieldCount + 30;
        coordinatorJobBean.pcStateManager.accessingField(n);
        return coordinatorJobBean.user;
    }

    private static final void pcSetuser(CoordinatorJobBean coordinatorJobBean, String string) {
        if (coordinatorJobBean.pcStateManager == null) {
            coordinatorJobBean.user = string;
            return;
        }
        coordinatorJobBean.pcStateManager.settingStringField((PersistenceCapable)coordinatorJobBean, pcInheritedFieldCount + 30, coordinatorJobBean.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

