/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.HCatCredentialHelper;
import org.apache.oozie.util.XLog;

public class HCatCredentials
extends Credentials {
    private static final String HCAT_METASTORE_PRINCIPAL = "hcat.metastore.principal";
    private static final String HCAT_METASTORE_URI = "hcat.metastore.uri";
    private static final String HIVE_METASTORE_PRINCIPAL = "hive.metastore.kerberos.principal";
    private static final String HIVE_METASTORE_URI = "hive.metastore.uris";

    @Override
    public void addtoJobConf(JobConf jobconf, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            String server;
            String principal;
            String string = principal = props.getProperties().get(HCAT_METASTORE_PRINCIPAL) == null ? props.getProperties().get(HIVE_METASTORE_PRINCIPAL) : props.getProperties().get(HCAT_METASTORE_PRINCIPAL);
            if (principal == null || principal.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hcat.metastore.principal is required to get hcat credential");
            }
            String string2 = server = props.getProperties().get(HCAT_METASTORE_URI) == null ? props.getProperties().get(HIVE_METASTORE_URI) : props.getProperties().get(HCAT_METASTORE_URI);
            if (server == null || server.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hcat.metastore.uri is required to get hcat credential");
            }
            HCatCredentialHelper hcch = new HCatCredentialHelper();
            hcch.set(jobconf, principal, server);
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).warn((Object)"Exception in addtoJobConf", e);
            throw e;
        }
    }
}

