/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.command.coord.CoordActionTimeOutXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.dependency.DependencyChecker;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.executor.jpa.CoordActionGetForInputCheckJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.StatusUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class CoordPushDependencyCheckXCommand
extends CoordinatorXCommand<Void> {
    protected String actionId;
    protected JPAService jpaService = null;
    protected CoordinatorActionBean coordAction = null;
    protected CoordinatorJobBean coordJob = null;
    public static final String CONF_COORD_PUSH_CHECK_REQUEUE_INTERVAL = "oozie.service.coord.push.check.requeue.interval";
    private boolean registerForNotification;
    private boolean removeAvailDependencies;

    public CoordPushDependencyCheckXCommand(String actionId) {
        this(actionId, false, true);
    }

    public CoordPushDependencyCheckXCommand(String actionId, boolean registerForNotification) {
        this(actionId, registerForNotification, !registerForNotification);
    }

    public CoordPushDependencyCheckXCommand(String actionId, boolean registerForNotification, boolean removeAvailDependencies) {
        super("coord_push_dep_check", "coord_push_dep_check", 0);
        this.actionId = actionId;
        this.registerForNotification = registerForNotification;
        this.removeAvailDependencies = removeAvailDependencies;
    }

    protected CoordPushDependencyCheckXCommand(String actionName, String actionId) {
        super(actionName, actionName, 0);
        this.actionId = actionId;
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.actionId);
    }

    @Override
    protected Void execute() throws CommandException {
        String pushMissingDeps = this.coordAction.getPushMissingDependencies();
        if (pushMissingDeps == null || pushMissingDeps.length() == 0) {
            this.LOG.info("Nothing to check. Empty push missing dependency");
        } else {
            String[] missingDepsArray = DependencyChecker.dependenciesAsArray(pushMissingDeps);
            this.LOG.info("First Push missing dependency is [{0}] ", missingDepsArray[0]);
            this.LOG.trace("Push missing dependencies are [{0}] ", pushMissingDeps);
            if (this.registerForNotification) {
                this.LOG.debug("Register for notifications is true");
            }
            try {
                XConfiguration actionConf = null;
                try {
                    actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
                }
                catch (IOException e) {
                    throw new CommandException(ErrorCode.E1307, e.getMessage(), e);
                }
                ActionDependency actionDep = DependencyChecker.checkForAvailability(missingDepsArray, (Configuration)actionConf, !this.registerForNotification);
                boolean isChangeInDependency = true;
                boolean timeout = false;
                if (actionDep.getMissingDependencies().size() == 0) {
                    this.onAllPushDependenciesAvailable();
                } else {
                    if (actionDep.getMissingDependencies().size() == missingDepsArray.length) {
                        isChangeInDependency = false;
                    } else {
                        String stillMissingDeps = DependencyChecker.dependenciesAsString(actionDep.getMissingDependencies());
                        this.coordAction.setPushMissingDependencies(stillMissingDeps);
                    }
                    timeout = this.isTimeout();
                    if (timeout) {
                        this.queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                    } else {
                        this.queue(new CoordPushDependencyCheckXCommand(this.coordAction.getId()), this.getCoordPushCheckRequeueInterval());
                    }
                }
                this.updateCoordAction(this.coordAction, isChangeInDependency);
                if (this.registerForNotification) {
                    this.registerForNotification(actionDep.getMissingDependencies(), actionConf);
                }
                if (this.removeAvailDependencies) {
                    this.unregisterAvailableDependencies(actionDep.getAvailableDependencies());
                }
                if (timeout) {
                    CoordPushDependencyCheckXCommand.unregisterMissingDependencies(actionDep.getMissingDependencies(), this.actionId);
                }
            }
            catch (Exception e) {
                CallableQueueService callableQueueService = Services.get().get(CallableQueueService.class);
                if (this.isTimeout()) {
                    this.LOG.debug("Queueing timeout command");
                    callableQueueService.queue(new CoordActionTimeOutXCommand(this.coordAction, this.coordJob.getUser(), this.coordJob.getAppName()));
                    CoordPushDependencyCheckXCommand.unregisterMissingDependencies(Arrays.asList(missingDepsArray), this.actionId);
                } else if (this.coordAction.getMissingDependencies() != null && this.coordAction.getMissingDependencies().length() > 0) {
                    callableQueueService.queue(new CoordPushDependencyCheckXCommand(this.coordAction.getId(), this.registerForNotification, this.removeAvailDependencies), Services.get().getConf().getInt("oozie.service.RecoveryService.coord.older.than", 600) * 1000);
                }
                throw new CommandException(ErrorCode.E1021, e.getMessage(), e);
            }
        }
        return null;
    }

    public long getCoordPushCheckRequeueInterval() {
        long requeueInterval = ConfigurationService.getLong(CONF_COORD_PUSH_CHECK_REQUEUE_INTERVAL);
        return requeueInterval;
    }

    protected boolean isTimeout() {
        long waitingTime = (new Date().getTime() - Math.max(this.coordAction.getNominalTime().getTime(), this.coordAction.getCreatedTime().getTime())) / 60000L;
        int timeOut = this.coordAction.getTimeOut();
        return timeOut >= 0 && waitingTime > (long)timeOut;
    }

    protected void onAllPushDependenciesAvailable() throws CommandException {
        this.coordAction.setPushMissingDependencies("");
        Services.get().get(PartitionDependencyManagerService.class).removeCoordActionWithDependenciesAvailable(this.coordAction.getId());
        if (this.coordAction.getMissingDependencies() == null || this.coordAction.getMissingDependencies().length() == 0) {
            Date currentTime;
            Date nominalTime = this.coordAction.getNominalTime();
            if (nominalTime.compareTo(currentTime = new Date()) > 0) {
                this.LOG.info("[" + this.actionId + "]::ActionInputCheck:: nominal Time is newer than current time. Current=" + DateUtils.formatDateOozieTZ(currentTime) + ", nominal=" + DateUtils.formatDateOozieTZ(nominalTime));
            } else {
                String actionXml = this.resolveCoordConfiguration();
                this.coordAction.setActionXml(actionXml);
                this.coordAction.setStatus(CoordinatorAction.Status.READY);
                this.queue(new CoordActionReadyXCommand(this.coordAction.getJobId()), 100L);
            }
        } else if (this.isTimeout()) {
            this.queue(new CoordActionInputCheckXCommand(this.coordAction.getId(), this.coordAction.getJobId()));
        }
    }

    private String resolveCoordConfiguration() throws CommandException {
        try {
            XConfiguration actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
            StringBuilder actionXml = new StringBuilder(this.coordAction.getActionXml());
            String newActionXml = CoordActionInputCheckXCommand.resolveCoordConfiguration(actionXml, actionConf, this.actionId);
            actionXml.replace(0, actionXml.length(), newActionXml);
            return actionXml.toString();
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1021, e.getMessage(), e);
        }
    }

    protected void updateCoordAction(CoordinatorActionBean coordAction, boolean isChangeInDependency) throws CommandException {
        coordAction.setLastModifiedTime(new Date());
        if (this.jpaService != null) {
            try {
                if (isChangeInDependency) {
                    CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_PUSH_INPUTCHECK, coordAction);
                    if (EventHandlerService.isEnabled() && coordAction.getStatus() != CoordinatorAction.Status.READY) {
                        CoordPushDependencyCheckXCommand.generateEvent(coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), null);
                    }
                } else {
                    CoordActionQueryExecutor.getInstance().executeUpdate(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_MODIFIED_DATE, coordAction);
                }
            }
            catch (JPAExecutorException jex) {
                throw new CommandException(ErrorCode.E1021, jex.getMessage(), jex);
            }
        }
    }

    private void registerForNotification(List<String> missingDeps, Configuration actionConf) {
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        String user = actionConf.get("user.name", "user.name");
        for (String missingDep : missingDeps) {
            try {
                URI missingURI = new URI(missingDep);
                URIHandler handler = uriService.getURIHandler(missingURI);
                handler.registerForNotification(missingURI, actionConf, user, this.actionId);
                this.LOG.debug("Registered uri [{0}] for notifications", missingURI);
            }
            catch (Exception e) {
                this.LOG.warn("Exception while registering uri [{0}] for notifications", missingDep, e);
            }
        }
    }

    private void unregisterAvailableDependencies(List<String> availableDeps) {
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        for (String availableDep : availableDeps) {
            try {
                URI availableURI = new URI(availableDep);
                URIHandler handler = uriService.getURIHandler(availableURI);
                if (handler.unregisterFromNotification(availableURI, this.actionId)) {
                    this.LOG.debug("Successfully unregistered uri [{0}] from notifications", availableURI);
                    continue;
                }
                this.LOG.warn("Unable to unregister uri [{0}] from notifications", availableURI);
            }
            catch (Exception e) {
                this.LOG.warn("Exception while unregistering uri [{0}] from notifications", availableDep, e);
            }
        }
    }

    public static void unregisterMissingDependencies(List<String> missingDeps, String actionId) {
        XLog LOG = XLog.getLog(CoordPushDependencyCheckXCommand.class);
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        for (String missingDep : missingDeps) {
            try {
                URI missingURI = new URI(missingDep);
                URIHandler handler = uriService.getURIHandler(missingURI);
                if (handler.unregisterFromNotification(missingURI, actionId)) {
                    LOG.debug("Successfully unregistered uri [{0}] from notifications", missingURI);
                    continue;
                }
                LOG.warn("Unable to unregister uri [{0}] from notifications", missingURI);
            }
            catch (Exception e) {
                LOG.warn("Exception while unregistering uri [{0}] from notifications", missingDep, e);
            }
        }
    }

    @Override
    public String getEntityKey() {
        return this.actionId.substring(0, this.actionId.indexOf("@"));
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        try {
            this.coordAction = this.jpaService.execute(new CoordActionGetForInputCheckJPAExecutor(this.actionId));
            if (this.coordAction == null) {
                throw new CommandException(ErrorCode.E0605, this.actionId);
            }
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.coordAction.getJobId()));
            LogUtils.setLogInfo(this.coordAction);
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordAction.getStatus() != CoordinatorAction.Status.WAITING) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordPushDependencyCheck:: Ignoring action. Should be in WAITING state, but state=" + this.coordAction.getStatus());
        }
        if (StatusUtils.getStatusForCoordActionInputCheck(this.coordJob)) {
            return;
        }
        if (this.coordJob.getStatus() != Job.Status.RUNNING && this.coordJob.getStatus() != Job.Status.RUNNINGWITHERROR && this.coordJob.getStatus() != Job.Status.PAUSED && this.coordJob.getStatus() != Job.Status.PAUSEDWITHERROR) {
            throw new PreconditionException(ErrorCode.E1100, "[" + this.actionId + "]::CoordPushDependencyCheck:: Ignoring action." + " Coordinator job is not in RUNNING/RUNNINGWITHERROR/PAUSED/PAUSEDWITHERROR state, but state=" + this.coordJob.getStatus());
        }
    }
}

