/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XLog;

public class ELService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.ELService.";
    public static final String CONF_CONSTANTS = "oozie.service.ELService.constants.";
    public static final String CONF_EXT_CONSTANTS = "oozie.service.ELService.ext.constants.";
    public static final String CONF_FUNCTIONS = "oozie.service.ELService.functions.";
    public static final String CONF_EXT_FUNCTIONS = "oozie.service.ELService.ext.functions.";
    public static final String CONF_GROUPS = "oozie.service.ELService.groups";
    private final XLog log = XLog.getLog(this.getClass());
    private HashMap<String, List<ELConstant>> constants;
    private HashMap<String, List<ELFunction>> functions;

    private List<ELConstant> extractConstants(Configuration conf, String key) throws ServiceException {
        ArrayList<ELConstant> list = new ArrayList<ELConstant>();
        if (conf.get(key, "").trim().length() > 0) {
            for (String function : ConfigurationService.getStrings(conf, key)) {
                String[] parts = ELService.parseDefinition(function);
                list.add(new ELConstant(parts[0], parts[1], ELService.findConstant(parts[2], parts[3])));
                this.log.trace("Registered prefix:constant[{0}:{1}] for class#field[{2}#{3}]", parts);
            }
        }
        return list;
    }

    private List<ELFunction> extractFunctions(Configuration conf, String key) throws ServiceException {
        ArrayList<ELFunction> list = new ArrayList<ELFunction>();
        if (conf.get(key, "").trim().length() > 0) {
            for (String function : ConfigurationService.getStrings(conf, key)) {
                String[] parts = ELService.parseDefinition(function);
                list.add(new ELFunction(parts[0], parts[1], ELService.findMethod(parts[2], parts[3])));
                this.log.trace("Registered prefix:constant[{0}:{1}] for class#field[{2}#{3}]", parts);
            }
        }
        return list;
    }

    @Override
    public synchronized void init(Services services) throws ServiceException {
        String[] groupList;
        this.log.trace("Constants and functions registration");
        this.constants = new HashMap();
        this.functions = new HashMap();
        for (String group : groupList = ConfigurationService.getStrings(services.getConf(), CONF_GROUPS)) {
            ArrayList<ELConstant> tmpConstants = new ArrayList<ELConstant>();
            tmpConstants.addAll(this.extractConstants(services.getConf(), CONF_CONSTANTS + group));
            tmpConstants.addAll(this.extractConstants(services.getConf(), CONF_EXT_CONSTANTS + group));
            this.constants.put(group, tmpConstants);
            ArrayList<ELFunction> tmpFunctions = new ArrayList<ELFunction>();
            tmpFunctions.addAll(this.extractFunctions(services.getConf(), CONF_FUNCTIONS + group));
            tmpFunctions.addAll(this.extractFunctions(services.getConf(), CONF_EXT_FUNCTIONS + group));
            this.functions.put(group, tmpFunctions);
        }
    }

    @Override
    public void destroy() {
        this.constants = null;
        this.functions = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ELService.class;
    }

    public ELEvaluator createEvaluator(String group) {
        ELEvaluator.Context context = new ELEvaluator.Context();
        boolean groupDefined = false;
        if (this.constants.containsKey(group)) {
            for (ELConstant constant : this.constants.get(group)) {
                context.setVariable(constant.name, constant.value);
            }
            groupDefined = true;
        }
        if (this.functions.containsKey(group)) {
            for (ELFunction function : this.functions.get(group)) {
                context.addFunction(function.prefix, function.name, function.method);
            }
            groupDefined = true;
        }
        if (!groupDefined) {
            throw new IllegalArgumentException("Group " + group + " is not defined");
        }
        return new ELEvaluator(context);
    }

    private static String[] parseDefinition(String str) throws ServiceException {
        try {
            str = str.trim();
            if (!str.contains(":")) {
                str = ":" + str;
            }
            String[] parts = str.split(":");
            String prefix = parts[0];
            parts = parts[1].split("=");
            String name = parts[0];
            parts = parts[1].split("#");
            String klass = parts[0];
            String method = parts[1];
            return new String[]{prefix, name, klass, method};
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0110, str, ex.getMessage(), ex);
        }
    }

    public static Method findMethod(String className, String methodName) throws ServiceException {
        Method method = null;
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(className);
            for (Method m : klass.getMethods()) {
                if (!m.getName().equals(methodName)) continue;
                method = m;
                break;
            }
            if (method == null) {
                throw new ServiceException(ErrorCode.E0111, className, methodName);
            }
            if ((method.getModifiers() & 9) != 9) {
                throw new ServiceException(ErrorCode.E0112, className, methodName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ErrorCode.E0113, className);
        }
        return method;
    }

    public static Object findConstant(String className, String constantName) throws ServiceException {
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(className);
            Field field = klass.getField(constantName);
            if ((field.getModifiers() & 9) != 9) {
                throw new ServiceException(ErrorCode.E0114, className, constantName);
            }
            return field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new ServiceException(ErrorCode.E0115, className, constantName);
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ErrorCode.E0113, className);
        }
    }

    private static class ELFunction {
        private String prefix;
        private String name;
        private Method method;

        private ELFunction(String prefix, String name, Method method) {
            this.prefix = prefix;
            this.name = name;
            this.method = method;
        }
    }

    private static class ELConstant {
        private String name;
        private Object value;

        private ELConstant(String prefix, String name, Object value) {
            if (prefix.length() > 0) {
                name = prefix + ":" + name;
            }
            this.name = name;
            this.value = value;
        }
    }
}

