/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StringSerializationUtil;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class LiteWorkflowApp
implements Writable,
WorkflowApp {
    public static final int NEW_SERIALIZATION_METHOD_FLAG = -1;
    private String name;
    private String definition;
    private Map<String, NodeDef> nodesMap = new LinkedHashMap<String, NodeDef>();
    private boolean complete = false;

    LiteWorkflowApp() {
    }

    public LiteWorkflowApp(String name, String definition, StartNodeDef startNode) {
        this.name = ParamChecker.notEmpty(name, "name");
        this.definition = ParamChecker.notEmpty(definition, "definition");
        this.nodesMap.put(":start:", startNode);
    }

    public boolean equals(LiteWorkflowApp other) {
        return other != null && this.getClass() == other.getClass() && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public LiteWorkflowApp addNode(NodeDef node) throws WorkflowException {
        ParamChecker.notNull(node, "node");
        if (this.complete) {
            throw new WorkflowException(ErrorCode.E0704, this.name);
        }
        if (this.nodesMap.containsKey(node.getName())) {
            throw new WorkflowException(ErrorCode.E0705, node.getName());
        }
        if (node.getTransitions().contains(node.getName())) {
            throw new WorkflowException(ErrorCode.E0706, node.getName());
        }
        this.nodesMap.put(node.getName(), node);
        if (node instanceof EndNodeDef) {
            this.complete = true;
        }
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    public Collection<NodeDef> getNodeDefs() {
        return Collections.unmodifiableCollection(this.nodesMap.values());
    }

    public NodeDef getNode(String name) {
        return this.nodesMap.get(name);
    }

    public void validateWorkflowIntegrity() {
    }

    public void validateTransition(String name, String transition) {
        ParamChecker.notEmpty(name, "name");
        ParamChecker.notEmpty(transition, "transition");
        NodeDef node = this.getNode(name);
        if (!node.getTransitions().contains(transition)) {
            throw new IllegalArgumentException("invalid transition");
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.name);
        dataOutput.writeInt(-1);
        StringSerializationUtil.writeString(dataOutput, this.definition);
        dataOutput.writeInt(this.nodesMap.size());
        for (NodeDef n : this.getNodeDefs()) {
            dataOutput.writeUTF(n.getClass().getName());
            n.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.name = dataInput.readUTF();
        int definitionListFlag = dataInput.readInt();
        if (definitionListFlag > -1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < definitionListFlag; ++i) {
                sb.append(dataInput.readUTF());
            }
            this.definition = sb.toString();
        } else {
            this.definition = StringSerializationUtil.readString(dataInput);
        }
        int numNodes = dataInput.readInt();
        for (int x = 0; x < numNodes; ++x) {
            try {
                String nodeDefClass = dataInput.readUTF();
                NodeDef node = (NodeDef)ReflectionUtils.newInstance(Class.forName(nodeDefClass), null);
                node.readFields(dataInput);
                this.addNode(node);
                continue;
            }
            catch (WorkflowException ex) {
                throw new IOException(ex);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
    }
}

