/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.encodings.Encoding;

public class Encoding_NotOneByte
implements Encoding {
    String encoding = null;
    char[] charMapping;

    public Encoding_NotOneByte(String encoding) {
        this.encoding = encoding;
    }

    public Encoding_NotOneByte(String encoding, char[] charMapping) {
        this.encoding = encoding;
        this.charMapping = charMapping;
    }

    public byte[] encodeToCharset(String in) {
        byte[] result = null;
        try {
            if (this.charMapping != null) {
                in = new String(this.translate(in.toCharArray()));
            }
            result = in.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public int encodeToCharset(char[] in, int off, int len, byte[] out) {
        byte[] by = null;
        try {
            if (this.charMapping != null) {
                in = this.translate(in);
            }
            by = new String(in).getBytes(this.encoding);
            System.arraycopy(by, 0, out, 0, by.length);
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        return by.length;
    }

    public String decodeFromCharset(byte[] in) {
        String result = null;
        try {
            result = new String(in, this.encoding);
            if (this.charMapping != null) {
                return new String(this.translate(result.toCharArray()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public int decodeFromCharset(byte[] in, int off, int len, char[] out) {
        String str = null;
        try {
            str = new String(in, this.encoding);
            str.getChars(0, str.length(), out, 0);
            if (this.charMapping != null) {
                this.translate(out);
            }
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        return str.length();
    }

    private char[] translate(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.charMapping[chars[i]];
        }
        return chars;
    }
}

