/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.wizard;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.wizard.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.EmbeddedWizard;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;

public class NewWizardReportAction
extends AbstractDesignerContextAction {
    private static final String TRANSLATIONS_PROPERTIES = "translations.properties";

    public NewWizardReportAction() {
        this.putValue("Name", Messages.getString("NewWizardReportAction.MenuTitle", new Object[0]));
        this.putValue("WIZARD.BUTTON.TEXT", Messages.getString("NewWizardReportAction.ButtonTitle", new Object[0]));
        this.putValue("AcceleratorKey", Messages.getOptionalKeyStroke("NewWizardReportAction.Accelerator"));
    }

    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext designerContext = this.getReportDesignerContext();
        if (designerContext == null) {
            return;
        }
        Component parent = designerContext.getView().getParent();
        Window window = this.getWindowAncestor(parent);
        EmbeddedWizard dialog = this.getEmbeddedWizard(window);
        try {
            MasterReport def = this.runDialog(dialog);
            if (def == null) {
                return;
            }
            try {
                MemoryDocumentBundle bundle = (MemoryDocumentBundle)def.getBundle();
                if (!bundle.isEntryExists(TRANSLATIONS_PROPERTIES)) {
                    String defaultMessage = ActionMessages.getString((String)"Translations.DefaultContent", (Object[])new Object[0]);
                    OutputStream outputStream = bundle.createEntry(TRANSLATIONS_PROPERTIES, "text/plain");
                    outputStream.write(defaultMessage.getBytes("ISO-8859-1"));
                    outputStream.close();
                    bundle.getWriteableDocumentMetaData().setEntryAttribute(TRANSLATIONS_PROPERTIES, "sticky", "true");
                }
            }
            catch (Exception ex) {
                DebugLog.log((Object)"Failed to created default translation entry", (Throwable)ex);
            }
            designerContext.addMasterReport(def);
        }
        catch (ReportProcessingException e1) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
        }
    }

    Window getWindowAncestor(Component parent) {
        return LibSwingUtil.getWindowAncestor((Component)parent);
    }

    EmbeddedWizard getEmbeddedWizard(Window window) {
        EmbeddedWizard dialog = window instanceof JDialog ? new EmbeddedWizard((Window)((JDialog)window)) : (window instanceof JFrame ? new EmbeddedWizard((Window)((JFrame)window)) : new EmbeddedWizard());
        return dialog;
    }

    MasterReport runDialog(EmbeddedWizard dialog) throws ReportProcessingException {
        return (MasterReport)dialog.run(null);
    }
}

