/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.manager.resource;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.pentaho.osgi.manager.resource.api.ResourceProvider;

public class ManagedResourceProvider
implements ResourceProvider {
    private BundleContext bundleContext;
    private File managedResourcesFolder;
    public static String MANAGED_RESOURCES_DIR = File.separator + "managed-resources";

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        this.managedResourcesFolder = this.findManagedResourcesFolder();
    }

    @Override
    public File getManagedResourceFolder() {
        return this.managedResourcesFolder;
    }

    @Override
    public File provideFolder(Bundle bundle, String relativePath) {
        File folder = this.getAbsoluteFile(bundle, relativePath);
        return this.validateFolder(folder);
    }

    @Override
    public File provideFolder(String bundleName, String relativePath) {
        File folder = this.getAbsoluteFile(bundleName, relativePath);
        return this.validateFolder(folder);
    }

    @Override
    public File provideFile(Bundle bundle, String relativePath) {
        File file = this.getAbsoluteFile(bundle, relativePath);
        return this.validateFile(file);
    }

    @Override
    public File provideFile(String bundleName, String relativePath) {
        File file = this.getAbsoluteFile(bundleName, relativePath);
        return this.validateFile(file);
    }

    protected File validateFolder(File folder) {
        return folder != null && folder.exists() && folder.isDirectory() ? folder : null;
    }

    protected File validateFile(File file) {
        return file != null && file.exists() && file.isFile() ? file : null;
    }

    protected File findManagedResourcesFolder() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)System.getProperty("karaf.home")) ? 1 : 0) != 0, (Object)"karaf.home system property is not set");
        File root = new File(System.getProperty("karaf.home"));
        return Paths.get(root.getAbsolutePath(), MANAGED_RESOURCES_DIR).toFile();
    }

    protected File getAbsoluteFile(Bundle bundle, String relativePath) {
        return bundle == null ? null : this.getAbsoluteFile(bundle.getSymbolicName(), relativePath);
    }

    protected File getAbsoluteFile(String bundleName, String relativePath) {
        return Paths.get(this.managedResourcesFolder.getPath(), bundleName, relativePath.replace(MANAGED_RESOURCES_DIR, "")).toFile();
    }
}

