/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.xml.PropertyType;
import org.hibernate.validator.xml.ValidationBootstrapParameters;
import org.hibernate.validator.xml.ValidationConfigType;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class ValidationXmlParser {
    private static final Logger log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.0.xsd";

    public final ValidationBootstrapParameters parseValidationXml() {
        ValidationConfigType config = this.getValidationConfig();
        ValidationBootstrapParameters xmlParameters = new ValidationBootstrapParameters();
        if (config != null) {
            this.setProviderClassFromXml(config, xmlParameters);
            this.setMessageInterpolatorFromXml(config, xmlParameters);
            this.setTraversableResolverFromXml(config, xmlParameters);
            this.setConstraintFactoryFromXml(config, xmlParameters);
            this.setMappingStreamsFromXml(config, xmlParameters);
            this.setPropertiesFromXml(config, xmlParameters);
        }
        return xmlParameters;
    }

    private void setConstraintFactoryFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String constraintFactoryClass = config.getConstraintValidatorFactory();
        if (constraintFactoryClass != null) {
            try {
                Class<?> clazz = ReflectionHelper.loadClass(constraintFactoryClass, this.getClass());
                xmlParameters.setConstraintValidatorFactory((ConstraintValidatorFactory)ReflectionHelper.newInstance(clazz, "constraint factory class"));
                log.info("Using {} as constraint factory.", (Object)constraintFactoryClass);
            }
            catch (ValidationException e) {
                throw new ValidationException("Unable to instantiate constraint factory class " + constraintFactoryClass + ".", (Throwable)e);
            }
        }
    }

    private void setPropertiesFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debug("Found property '{}' with value '{}' in validation.xml.", (Object)property.getName(), (Object)property.getValue());
            }
            xmlParameters.addConfigProperty(property.getName(), property.getValue());
        }
    }

    private void setMappingStreamsFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        for (String mappingFileName : config.getConstraintMapping()) {
            InputStream in;
            if (log.isDebugEnabled()) {
                log.debug("Trying to open input stream for {}.", (Object)mappingFileName);
            }
            if ((in = this.getInputStreamForPath(mappingFileName)) == null) {
                throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName + ".");
            }
            xmlParameters.addMapping(in);
        }
    }

    private void setMessageInterpolatorFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String messageInterpolatorClass = config.getMessageInterpolator();
        if (messageInterpolatorClass != null) {
            try {
                Class<?> clazz = ReflectionHelper.loadClass(messageInterpolatorClass, this.getClass());
                xmlParameters.setMessageInterpolator((MessageInterpolator)clazz.newInstance());
                log.info("Using {} as message interpolator.", (Object)messageInterpolatorClass);
            }
            catch (ValidationException e) {
                throw new ValidationException("Unable to instantiate message interpolator class " + messageInterpolatorClass + ".", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ValidationException("Unable to instantiate message interpolator class " + messageInterpolatorClass + ".", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to instantiate message interpolator class " + messageInterpolatorClass + ".", (Throwable)e);
            }
        }
    }

    private void setTraversableResolverFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String traversableResolverClass = config.getTraversableResolver();
        if (traversableResolverClass != null) {
            try {
                Class<?> clazz = ReflectionHelper.loadClass(traversableResolverClass, this.getClass());
                xmlParameters.setTraversableResolver((TraversableResolver)clazz.newInstance());
                log.info("Using {} as traversable resolver.", (Object)traversableResolverClass);
            }
            catch (ValidationException e) {
                throw new ValidationException("Unable to instantiate traversable resolver class " + traversableResolverClass + ".", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ValidationException("Unable to instantiate traversable resolver class " + traversableResolverClass + ".", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to instantiate traversable resolver class " + traversableResolverClass + ".", (Throwable)e);
            }
        }
    }

    private void setProviderClassFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParamters) {
        String providerClassName = config.getDefaultProvider();
        if (providerClassName != null) {
            try {
                xmlParamters.setProviderClass(ReflectionHelper.loadClass(providerClassName, this.getClass()));
                log.info("Using {} as validation provider.", (Object)providerClassName);
            }
            catch (Exception e) {
                throw new ValidationException("Unable to instantiate validation provider class " + providerClassName + ".", (Throwable)e);
            }
        }
    }

    private ValidationConfigType getValidationConfig() {
        ValidationConfigType validationConfig;
        log.debug("Trying to load {} for XML based Validator configuration.", (Object)VALIDATION_XML_FILE);
        InputStream inputStream = this.getInputStreamForPath(VALIDATION_XML_FILE);
        if (inputStream == null) {
            log.debug("No {} found. Using annotation based configuration only", (Object)VALIDATION_XML_FILE);
            return null;
        }
        log.info("{} found. Parsing XML based configuration.", (Object)VALIDATION_XML_FILE);
        Schema schema = this.getValidationConfigurationSchema();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            validationConfig = (ValidationConfigType)root.getValue();
        }
        catch (JAXBException e) {
            log.error("Error parsing {}: {}", (Object)VALIDATION_XML_FILE, (Object)e.getMessage());
            throw new ValidationException("Unable to parse META-INF/validation.xml", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException io) {
                log.warn("Unable to close input stream for META-INF/validation.xml");
            }
        }
        return validationConfig;
    }

    private InputStream getInputStreamForPath(String path) {
        String inputPath = path;
        if (inputPath.startsWith("/")) {
            inputPath = inputPath.substring(1);
        }
        boolean isContextCL = true;
        ClassLoader loader = ReflectionHelper.getClassLoaderFromContext();
        if (loader == null) {
            log.debug("No default context class loader, fall back to Bean Validation's loader");
            loader = ReflectionHelper.getClassLoaderFromClass(ValidationXmlParser.class);
            isContextCL = false;
        }
        InputStream inputStream = loader.getResourceAsStream(inputPath);
        if (isContextCL && inputStream == null) {
            loader = ReflectionHelper.getClassLoaderFromClass(ValidationXmlParser.class);
            inputStream = loader.getResourceAsStream(inputPath);
        }
        return inputStream;
    }

    private Schema getValidationConfigurationSchema() {
        ClassLoader loader = ReflectionHelper.getClassLoaderFromClass(ValidationXmlParser.class);
        URL schemaUrl = loader.getResource(VALIDATION_CONFIGURATION_XSD);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.warn("Unable to create schema for {}: {}", (Object)VALIDATION_CONFIGURATION_XSD, (Object)e.getMessage());
        }
        return schema;
    }
}

