/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eigenbase.xom.MetaGenerator;
import org.eigenbase.xom.XOMException;

public class XOMGenTask
extends Task {
    String modelFileName;
    String destDir;
    String dtdFileName;
    String className;

    public void execute() throws BuildException {
        try {
            if (this.modelFileName == null) {
                throw new BuildException("You must specify model.");
            }
            if (this.className == null) {
                throw new BuildException("You must specify className.");
            }
            File projectBase = this.getProject().getBaseDir();
            File destinationDirectory = this.destDir == null ? projectBase : new File(projectBase, this.destDir);
            if (!destinationDirectory.exists()) {
                throw new BuildException("Destination directory doesn't exist: " + destinationDirectory.toString());
            }
            File modelFile = new File(projectBase, this.modelFileName);
            File classFile = XOMGenTask.classNameToFile(destinationDirectory, this.className);
            File outputDir = classFile.getParentFile();
            File dtdFile = new File(outputDir, this.dtdFileName);
            if (modelFile.exists() && classFile.exists() && dtdFile.exists()) {
                long modelStamp = modelFile.lastModified();
                long classStamp = classFile.lastModified();
                long dtdStamp = dtdFile.lastModified();
                if (classStamp > modelStamp && dtdStamp > modelStamp) {
                    return;
                }
            }
            boolean testMode = false;
            MetaGenerator generator = new MetaGenerator(modelFile.toString(), false, this.className);
            generator.writeFiles(destinationDirectory.toString(), this.dtdFileName);
            generator.writeOutputs();
        }
        catch (XOMException e) {
            throw new BuildException("Generation of model failed: " + e);
        }
        catch (IOException e) {
            throw new BuildException("Generation of model failed: " + e);
        }
    }

    public void setModel(String model) {
        this.modelFileName = model;
    }

    public void setDestdir(String destdir) {
        this.destDir = destdir;
    }

    public void setClassname(String classname) {
        this.className = classname;
    }

    public void setDtdname(String dtdname) {
        this.dtdFileName = dtdname;
    }

    static File classNameToFile(File dir, String className) {
        char fileSep = System.getProperty("file.separator").charAt(0);
        String relativePath = className.replace('.', fileSep) + ".java";
        if (dir == null) {
            return new File(relativePath);
        }
        return new File(dir, relativePath);
    }
}

