/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.InformationSchemaManager;
import com.cloudera.sqoop.mapreduce.JdbcUpsertExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.mapreduce.mysql.MySQLUpsertOutputFormat;
import org.apache.sqoop.util.LoggingUtils;

public class MySQLManager
extends InformationSchemaManager {
    public static final Log LOG = LogFactory.getLog((String)MySQLManager.class.getName());
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static boolean warningPrinted = false;
    private static final String EXPORT_OPERATION = "export";
    private Map<String, String> colTypeNames;
    private static final int YEAR_TYPE_OVERWRITE = 5;

    public MySQLManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
    }

    @Override
    protected void initOptionDefaults() {
        if (this.options.getFetchSize() == null) {
            LOG.info((Object)"Preparing to use a MySQL streaming resultset.");
            String operation = this.options.getToolName();
            if (StringUtils.isNotBlank((String)operation) && operation.equalsIgnoreCase(EXPORT_OPERATION)) {
                this.options.setFetchSize(0);
            } else {
                this.options.setFetchSize(Integer.MIN_VALUE);
            }
        } else if (!this.options.getFetchSize().equals(Integer.MIN_VALUE) && !this.options.getFetchSize().equals(0)) {
            LOG.info((Object)("Argument '--fetch-size " + this.options.getFetchSize() + "' will probably get ignored by MySQL JDBC driver."));
        }
    }

    @Override
    protected String getPrimaryKeyQuery(String tableName) {
        return "SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = (" + this.getSchemaQuery() + ") AND TABLE_NAME = '" + tableName + "' AND COLUMN_KEY = 'PRI'";
    }

    @Override
    protected String getColNamesQuery(String tableName) {
        return "SELECT t.* FROM " + this.escapeTableName(tableName) + " AS t LIMIT 1";
    }

    @Override
    public void importTable(com.cloudera.sqoop.manager.ImportJobContext context) throws IOException, ImportException {
        String connectString;
        if (!warningPrinted && null != (connectString = context.getOptions().getConnectString())) {
            LOG.warn((Object)"It looks like you are importing from mysql.");
            LOG.warn((Object)"This transfer can be faster! Use the --direct");
            LOG.warn((Object)"option to exercise a MySQL-specific fast path.");
            MySQLManager.markWarningPrinted();
        }
        this.checkDateTimeBehavior(context);
        super.importTable(context);
    }

    @Override
    public void upsertTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        LOG.warn((Object)"MySQL Connector upsert functionality is using INSERT ON");
        LOG.warn((Object)"DUPLICATE KEY UPDATE clause that relies on table's unique key.");
        LOG.warn((Object)"Insert/update distinction is therefore independent on column");
        LOG.warn((Object)"names specified in --update-key parameter. Please see MySQL");
        LOG.warn((Object)"documentation for additional limitations.");
        JdbcUpsertExportJob exportJob = new JdbcUpsertExportJob(context, MySQLUpsertOutputFormat.class);
        exportJob.runExport();
    }

    @Override
    public void configureDbOutputColumns(SqoopOptions options) {
        if (options.getUpdateMode() == SqoopOptions.UpdateMode.AllowInsert) {
            return;
        }
        super.configureDbOutputColumns(options);
    }

    protected static void markWarningPrinted() {
        warningPrinted = true;
    }

    private void checkDateTimeBehavior(ImportJobContext context) {
        String ZERO_BEHAVIOR_STR = "zeroDateTimeBehavior";
        String CONVERT_TO_NULL = "=convertToNull";
        String connectStr = context.getOptions().getConnectString();
        if (connectStr.indexOf("jdbc:") != 0) {
            return;
        }
        String uriComponent = connectStr.substring(5);
        try {
            URI uri = new URI(uriComponent);
            String query = uri.getQuery();
            if (null == query) {
                connectStr = connectStr + "?" + "zeroDateTimeBehavior" + "=convertToNull";
                LOG.info((Object)"Setting zero DATETIME behavior to convertToNull (mysql)");
            } else if (query.length() == 0) {
                connectStr = connectStr + "zeroDateTimeBehavior" + "=convertToNull";
                LOG.info((Object)"Setting zero DATETIME behavior to convertToNull (mysql)");
            } else if (query.indexOf("zeroDateTimeBehavior") == -1) {
                if (!connectStr.endsWith("&")) {
                    connectStr = connectStr + "&";
                }
                connectStr = connectStr + "zeroDateTimeBehavior" + "=convertToNull";
                LOG.info((Object)"Setting zero DATETIME behavior to convertToNull (mysql)");
            }
            LOG.debug((Object)("Rewriting connect string to " + connectStr));
            context.getOptions().setConnectString(connectStr);
        }
        catch (URISyntaxException use) {
            LOG.debug((Object)("mysql: Couldn't parse connect str in checkDateTimeBehavior: " + use));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execAndPrint(String s) {
        ResultSet results = null;
        try {
            results = super.execute(s, 0, new Object[0]);
        }
        catch (SQLException sqlE) {
            LoggingUtils.logAll(LOG, "Error executing statement: ", sqlE);
            this.release();
            return;
        }
        try (PrintWriter pw = new PrintWriter(System.out, true);){
            this.formatAndPrintResultSet(results, pw);
        }
    }

    @Override
    public String escapeColName(String colName) {
        if (null == colName) {
            return null;
        }
        return "`" + colName + "`";
    }

    @Override
    public String escapeTableName(String tableName) {
        if (null == tableName) {
            return null;
        }
        return "`" + tableName + "`";
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNamesForProcedure(String procedureName) {
        String[] stringArray;
        ArrayList<String> ret = new ArrayList<String>();
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
        if (null == results) {
            LOG.debug((Object)"Get Procedure Columns returns null");
            return null;
        }
        try {
            while (results.next()) {
                if (results.getInt("COLUMN_TYPE") == 5) continue;
                String name = results.getString("COLUMN_NAME");
                ret.add(name);
            }
            String[] result = ret.toArray(new String[ret.size()]);
            LOG.debug((Object)("getColumnsNamesForProcedure returns " + StringUtils.join(ret, (String)",")));
            stringArray = result;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                this.getConnection().commit();
                throw throwable;
            }
            catch (SQLException e) {
                LoggingUtils.logAll(LOG, "Error reading procedure metadata: ", e);
                throw new RuntimeException("Can't fetch column names for procedure.", e);
            }
        }
        results.close();
        this.getConnection().commit();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getColumnTypesForProcedure(String procedureName) {
        TreeMap<String, Integer> treeMap;
        block8: {
            TreeMap<String, Integer> ret = new TreeMap<String, Integer>();
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
            if (null == results) {
                LOG.debug((Object)"getColumnTypesForProcedure returns null");
                return null;
            }
            try {
                while (results.next()) {
                    if (results.getInt("COLUMN_TYPE") == 5) continue;
                    ret.put(results.getString("COLUMN_NAME"), results.getInt("DATA_TYPE"));
                }
                LOG.debug((Object)("Columns returned = " + StringUtils.join(ret.keySet(), (String)",")));
                LOG.debug((Object)("Types returned = " + StringUtils.join(ret.values(), (String)",")));
                TreeMap<String, Integer> treeMap2 = treeMap = ret.isEmpty() ? null : ret;
                if (results == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (results != null) {
                        results.close();
                    }
                    this.getConnection().commit();
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
                    return null;
                }
            }
            results.close();
        }
        this.getConnection().commit();
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getColumnTypeNamesForProcedure(String procedureName) {
        TreeMap<String, String> treeMap;
        block8: {
            TreeMap<String, String> ret = new TreeMap<String, String>();
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            ResultSet results = metaData.getProcedureColumns(null, null, procedureName, null);
            if (null == results) {
                LOG.debug((Object)"getColumnTypesForProcedure returns null");
                return null;
            }
            try {
                while (results.next()) {
                    if (results.getInt("COLUMN_TYPE") == 5) continue;
                    ret.put(results.getString("COLUMN_NAME"), results.getString("TYPE_NAME"));
                }
                LOG.debug((Object)("Columns returned = " + StringUtils.join(ret.keySet(), (String)",")));
                LOG.debug((Object)("Type names returned = " + StringUtils.join(ret.values(), (String)",")));
                TreeMap<String, String> treeMap2 = treeMap = ret.isEmpty() ? null : ret;
                if (results == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (results != null) {
                        results.close();
                    }
                    this.getConnection().commit();
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    LoggingUtils.logAll(LOG, "Error reading primary key metadata: " + sqlException.toString(), sqlException);
                    return null;
                }
            }
            results.close();
        }
        this.getConnection().commit();
        return treeMap;
    }

    @Override
    protected String getListDatabasesQuery() {
        return "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA";
    }

    @Override
    protected String getSchemaQuery() {
        return "SELECT SCHEMA()";
    }

    private int overrideSqlType(String tableName, String columnName, int sqlType) {
        if (this.colTypeNames == null) {
            this.colTypeNames = this.getColumnTypeNames(tableName, this.options.getCall(), this.options.getSqlQuery());
        }
        if ("YEAR".equalsIgnoreCase(this.colTypeNames.get(columnName))) {
            sqlType = 5;
        }
        return sqlType;
    }

    @Override
    public String toJavaType(String tableName, String columnName, int sqlType) {
        sqlType = this.overrideSqlType(tableName, columnName, sqlType);
        return super.toJavaType(tableName, columnName, sqlType);
    }

    @Override
    public String toHiveType(String tableName, String columnName, int sqlType) {
        sqlType = this.overrideSqlType(tableName, columnName, sqlType);
        return super.toHiveType(tableName, columnName, sqlType);
    }

    @Override
    public Schema.Type toAvroType(String tableName, String columnName, int sqlType) {
        sqlType = this.overrideSqlType(tableName, columnName, sqlType);
        return super.toAvroType(tableName, columnName, sqlType);
    }
}

