/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import com.cloudera.sqoop.util.ExportException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.tool.CodeGenTool;

public class ExportTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)ExportTool.class.getName());
    private CodeGenTool codeGenerator = new CodeGenTool();

    public ExportTool() {
        super("export");
    }

    public List<String> getGeneratedJarFiles() {
        return this.codeGenerator.getGeneratedJarFiles();
    }

    private void exportTable(SqoopOptions options, String tableName) throws ExportException, IOException {
        String jarFile = null;
        jarFile = this.codeGenerator.generateORM(options, tableName);
        ExportJobContext context = new ExportJobContext(tableName, jarFile, options);
        if (options.getUpdateKeyCol() != null) {
            if (options.getUpdateMode() == SqoopOptions.UpdateMode.UpdateOnly) {
                this.manager.updateTable(context);
            } else {
                this.manager.upsertTable(context);
            }
        } else if (options.getCall() != null) {
            this.manager.callTable(context);
        } else {
            this.manager.exportTable(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        if (!this.init(options)) {
            return 1;
        }
        this.codeGenerator.setManager(this.manager);
        if (options.getUpdateKeyCol() != null) {
            this.manager.configureDbOutputColumns(options);
        }
        try {
            this.exportTable(options, options.getTableName());
        }
        catch (IOException ioe) {
            LOG.error((Object)"Encountered IOException running export job: ", (Throwable)ioe);
            this.rethrowIfRequired(options, ioe);
            int n = 1;
            return n;
        }
        catch (ExportException ee) {
            LOG.error((Object)"Error during export: ", (Throwable)ee);
            this.rethrowIfRequired(options, ee);
            int n = 1;
            return n;
        }
        finally {
            this.destroy(options);
        }
        return 0;
    }

    protected RelatedOptions getExportOptions() {
        RelatedOptions exportOpts = new RelatedOptions("Export control arguments");
        OptionBuilder.withDescription((String)"Use direct export fast path");
        OptionBuilder.withLongOpt((String)"direct");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"table-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Table to populate");
        OptionBuilder.withLongOpt((String)"table");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"col,col,col...");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Columns to export to table");
        OptionBuilder.withLongOpt((String)"columns");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set name for generated mapreduce job");
        OptionBuilder.withLongOpt((String)"mapreduce-job-name");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Use 'n' map tasks to export in parallel");
        OptionBuilder.withLongOpt((String)"num-mappers");
        exportOpts.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS source path for the export");
        OptionBuilder.withLongOpt((String)"export-dir");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"key");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Update records by specified key column");
        OptionBuilder.withLongOpt((String)"update-key");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"table-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Intermediate staging table");
        OptionBuilder.withLongOpt((String)"staging-table");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Indicates that any data in staging table can be deleted");
        OptionBuilder.withLongOpt((String)"clear-staging-table");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Indicates underlying statements to be executed in batch mode");
        OptionBuilder.withLongOpt((String)"batch");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"mode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies how updates are performed when new rows are found with non-matching keys in database");
        OptionBuilder.withLongOpt((String)"update-mode");
        exportOpts.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Populate the table using this stored procedure (one call per row)");
        OptionBuilder.withLongOpt((String)"call");
        exportOpts.addOption(OptionBuilder.create());
        this.addValidationOpts(exportOpts);
        return exportOpts;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        toolOptions.addUniqueOptions(this.getExportOptions());
        toolOptions.addUniqueOptions(this.getInputFormatOptions());
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
        RelatedOptions codeGenOpts = this.getCodeGenOpts(false);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Disable code generation; use specified jar");
        OptionBuilder.withLongOpt((String)"jar-file");
        codeGenOpts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(codeGenOpts);
        toolOptions.addUniqueOptions(this.getHCatalogOptions());
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        super.printHelp(toolOptions);
        System.out.println("");
        System.out.println("At minimum, you must specify --connect, --export-dir, and --table");
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        try {
            this.applyCommonOptions(in, out);
            if (in.hasOption("direct")) {
                out.setDirectMode(true);
            }
            if (in.hasOption("batch")) {
                out.setBatchMode(true);
            }
            if (in.hasOption("table")) {
                out.setTableName(in.getOptionValue("table"));
            }
            if (in.hasOption("columns")) {
                String[] cols = in.getOptionValue("columns").split(",");
                for (int i = 0; i < cols.length; ++i) {
                    cols[i] = cols[i].trim();
                }
                out.setColumns(cols);
            }
            if (in.hasOption("num-mappers")) {
                out.setNumMappers(Integer.parseInt(in.getOptionValue("num-mappers")));
            }
            if (in.hasOption("mapreduce-job-name")) {
                out.setMapreduceJobName(in.getOptionValue("mapreduce-job-name"));
            }
            if (in.hasOption("export-dir")) {
                out.setExportDir(in.getOptionValue("export-dir"));
            }
            if (in.hasOption("jar-file")) {
                out.setExistingJarName(in.getOptionValue("jar-file"));
            }
            if (in.hasOption("update-key")) {
                out.setUpdateKeyCol(in.getOptionValue("update-key"));
            }
            if (in.hasOption("staging-table")) {
                out.setStagingTableName(in.getOptionValue("staging-table"));
            }
            if (in.hasOption("clear-staging-table")) {
                out.setClearStagingTable(true);
            }
            if (in.hasOption("call")) {
                out.setCall(in.getOptionValue("call"));
            }
            this.applyValidationOptions(in, out);
            this.applyNewUpdateOptions(in, out);
            this.applyInputFormatOptions(in, out);
            this.applyOutputFormatOptions(in, out);
            this.applyCodeGenOptions(in, out, false);
            this.applyHCatalogOptions(in, out);
        }
        catch (NumberFormatException nfe) {
            throw new SqoopOptions.InvalidOptionsException("Error: expected numeric argument.\nTry --help for usage.");
        }
    }

    protected void validateExportOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getTableName() == null && options.getCall() == null) {
            throw new SqoopOptions.InvalidOptionsException("Export requires a --table or a --call argument.\nTry --help for usage instructions.");
        }
        if (options.getExportDir() == null && options.getHCatTableName() == null) {
            throw new SqoopOptions.InvalidOptionsException("Export requires an --export-dir argument or --hcatalog-table argument.\nTry --help for usage instructions.");
        }
        if (options.getExistingJarName() != null && options.getClassName() == null) {
            throw new SqoopOptions.InvalidOptionsException("Jar specified with --jar-file, but no class specified with --class-name.\nTry --help for usage instructions.");
        }
        if (options.getExistingJarName() != null && options.getUpdateKeyCol() != null) {
            throw new SqoopOptions.InvalidOptionsException("Jar cannot be specified with --jar-file when export is running in update mode.");
        }
        if (options.getStagingTableName() != null && options.getUpdateKeyCol() != null) {
            throw new SqoopOptions.InvalidOptionsException("Staging table cannot be used when export is running in update mode.");
        }
        if (options.getStagingTableName() != null && options.getStagingTableName().equalsIgnoreCase(options.getTableName())) {
            throw new SqoopOptions.InvalidOptionsException("Staging table cannot be the same as the destination table. Name comparison used is case-insensitive.");
        }
        if (options.doClearStagingTable() && options.getStagingTableName() == null) {
            throw new SqoopOptions.InvalidOptionsException("Option to clear the staging table is specified but the staging table name is not.");
        }
        if (options.getCall() != null && options.getStagingTableName() != null) {
            throw new SqoopOptions.InvalidOptionsException("Option the use a staging table is specified as well as a call option.");
        }
        if (options.getCall() != null && options.getUpdateKeyCol() != null) {
            throw new SqoopOptions.InvalidOptionsException("Option to call a stored procedurecan't be used in update mode.");
        }
        if (options.getCall() != null && options.getTableName() != null) {
            throw new SqoopOptions.InvalidOptionsException("Can't specify --call and --table.");
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        options.setExtraArgs(this.getSubcommandArgs(this.extraArguments));
        int dashPos = this.extraArguments.length;
        for (int i = 0; i < this.extraArguments.length; ++i) {
            if (!this.extraArguments[i].equals("--")) continue;
            dashPos = i;
            break;
        }
        if (this.hasUnrecognizedArgs(this.extraArguments, 0, dashPos)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateExportOptions(options);
        this.validateOutputFormatOptions(options);
        this.validateCommonOptions(options);
        this.validateCodeGenOptions(options);
        this.validateHCatalogOptions(options);
        this.vaildateDirectExportOptions(options);
    }

    void vaildateDirectExportOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.isDirect()) {
            this.validateHasDirectConnectorOption(options);
        }
    }

    private void applyNewUpdateOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("update-mode")) {
            String updateTypeStr = in.getOptionValue("update-mode");
            if ("updateonly".equals(updateTypeStr)) {
                out.setUpdateMode(SqoopOptions.UpdateMode.UpdateOnly);
            } else if ("allowinsert".equals(updateTypeStr)) {
                out.setUpdateMode(SqoopOptions.UpdateMode.AllowInsert);
            } else {
                throw new SqoopOptions.InvalidOptionsException("Unknown new update mode: " + updateTypeStr + ". Use 'updateonly' or 'allowinsert'." + "\nTry --help for usage instructions.");
            }
        }
    }
}

