/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.metastore.JobStorage;
import com.cloudera.sqoop.metastore.JobStorageFactory;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;
import org.apache.sqoop.tool.SqoopTool;
import org.apache.sqoop.util.LoggingUtils;

public class JobTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)JobTool.class.getName());
    private static final String DASH_STR = "--";
    private Map<String, String> storageDescriptor;
    private String jobName;
    private JobOp operation;
    private JobStorage storage;

    public JobTool() {
        super("job");
    }

    private String[] getElementsUpToDoubleDash(String[] array) {
        String[] parseableChildArgv = null;
        for (int i = 0; i < array.length; ++i) {
            if (!DASH_STR.equals(array[i])) continue;
            parseableChildArgv = Arrays.copyOfRange(array, 0, i);
            break;
        }
        if (parseableChildArgv == null) {
            parseableChildArgv = array;
        }
        return parseableChildArgv;
    }

    private String[] getElementsAfterDoubleDash(String[] array) {
        String[] extraChildArgv = null;
        for (int i = 0; i < array.length; ++i) {
            if (!DASH_STR.equals(array[i])) continue;
            extraChildArgv = Arrays.copyOfRange(array, i, array.length);
            break;
        }
        return extraChildArgv;
    }

    private int configureChildTool(SqoopOptions childOptions, SqoopTool childTool, String[] childArgv) {
        String[] parseableChildArgv = this.getElementsUpToDoubleDash(childArgv);
        String[] extraChildArgv = this.getElementsAfterDoubleDash(childArgv);
        try {
            childOptions = childTool.parseArguments(parseableChildArgv, null, childOptions, false);
            childTool.appendArgs(extraChildArgv);
            childTool.validateOptions(childOptions);
        }
        catch (ParseException pe) {
            LOG.error((Object)"Error parsing arguments to the job-specific tool: ", (Throwable)pe);
            LOG.error((Object)"See 'sqoop help <tool>' for usage.");
            return 1;
        }
        catch (SqoopOptions.InvalidOptionsException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        return 0;
    }

    private int createJob(SqoopOptions options) throws IOException {
        int dashPos = this.getDashPosition(this.extraArguments);
        int toolArgPos = dashPos + 1;
        if (null == this.extraArguments || toolArgPos < 0 || toolArgPos >= this.extraArguments.length) {
            LOG.error((Object)"No tool specified; cannot create a job.");
            LOG.error((Object)"Use: sqoop job --create <job-name> -- <tool-name> [tool-args]");
            return 1;
        }
        String jobToolName = this.extraArguments[toolArgPos];
        SqoopTool jobTool = SqoopTool.getTool(jobToolName);
        if (null == jobTool) {
            LOG.error((Object)("No such tool available: " + jobToolName));
            return 1;
        }
        SqoopOptions jobOptions = new SqoopOptions();
        jobOptions.setConf(new Configuration(options.getConf()));
        String[] childArgs = Arrays.copyOfRange(this.extraArguments, toolArgPos + 1, this.extraArguments.length);
        int confRet = this.configureChildTool(jobOptions, jobTool, childArgs);
        if (0 != confRet) {
            return confRet;
        }
        JobData jobData = new JobData(jobOptions, (com.cloudera.sqoop.tool.SqoopTool)jobTool);
        this.storage.create(this.jobName, jobData);
        return 0;
    }

    private int listJobs(SqoopOptions opts) throws IOException {
        List<String> jobNames = this.storage.list();
        System.out.println("Available jobs:");
        for (String name : jobNames) {
            System.out.println("  " + name);
        }
        return 0;
    }

    private int deleteJob(SqoopOptions opts) throws IOException {
        this.storage.delete(this.jobName);
        return 0;
    }

    private int execJob(SqoopOptions opts) throws IOException {
        int confRet;
        int dashPos;
        JobData data = this.storage.read(this.jobName);
        if (null == data) {
            LOG.error((Object)("No such job: " + this.jobName));
            return 1;
        }
        SqoopOptions childOpts = data.getSqoopOptions();
        com.cloudera.sqoop.tool.SqoopTool childTool = data.getSqoopTool();
        SqoopOptions clonedOpts = (SqoopOptions)childOpts.clone();
        clonedOpts.setParent(childOpts);
        Object[] childArgv = childOpts.getExtraArgs();
        if (childArgv == null || childArgv.length == 0) {
            childArgv = new String[]{};
        }
        if ((dashPos = this.getDashPosition(this.extraArguments)) < this.extraArguments.length) {
            Object[] extraArgs = Arrays.copyOfRange(this.extraArguments, dashPos + 1, this.extraArguments.length);
            if (childArgv == null || childArgv.length == 0) {
                childArgv = extraArgs;
            } else {
                int dashPos2 = this.getDashPosition((String[])extraArgs);
                if (dashPos2 >= extraArgs.length) {
                    extraArgs = (String[])ArrayUtils.addAll((Object[])extraArgs, (Object[])new String[]{DASH_STR});
                }
                childArgv = (String[])ArrayUtils.addAll((Object[])extraArgs, (Object[])childArgv);
            }
        }
        if (0 != (confRet = this.configureChildTool(clonedOpts, childTool, (String[])childArgv))) {
            return confRet;
        }
        return childTool.run(clonedOpts);
    }

    private int showJob(SqoopOptions opts) throws IOException {
        JobData data = this.storage.read(this.jobName);
        if (null == data) {
            LOG.error((Object)("No such job: " + this.jobName));
            return 1;
        }
        SqoopOptions childOpts = data.getSqoopOptions();
        com.cloudera.sqoop.tool.SqoopTool childTool = data.getSqoopTool();
        System.out.println("Job: " + this.jobName);
        System.out.println("Tool: " + childTool.getToolName());
        System.out.println("Options:");
        System.out.println("----------------------------");
        Properties props = childOpts.writeProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            System.out.println(entry.getKey().toString() + " = " + entry.getValue());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        JobStorageFactory ssf = new JobStorageFactory(options.getConf());
        this.storage = ssf.getJobStorage(this.storageDescriptor);
        if (null == this.storage) {
            LOG.error((Object)"There is no JobStorage implementation available");
            LOG.error((Object)"that can read your specified storage descriptor.");
            LOG.error((Object)"Don't know where to save this job info! You may");
            LOG.error((Object)"need to specify the connect string with --meta-connect.");
            return 1;
        }
        try {
            this.storage.open(this.storageDescriptor);
            switch (this.operation) {
                case JobCreate: {
                    int n = this.createJob(options);
                    return n;
                }
                case JobDelete: {
                    int n = this.deleteJob(options);
                    return n;
                }
                case JobExecute: {
                    int n = this.execJob(options);
                    return n;
                }
                case JobList: {
                    int n = this.listJobs(options);
                    return n;
                }
                case JobShow: {
                    int n = this.showJob(options);
                    return n;
                }
            }
            LOG.error((Object)("Undefined job operation: " + (Object)((Object)this.operation)));
            int n = 1;
            return n;
        }
        catch (IOException ioe) {
            LOG.error((Object)("I/O error performing job operation: " + StringUtils.stringifyException((Throwable)ioe)));
            int n = 1;
            return n;
        }
        finally {
            if (null != this.storage) {
                try {
                    this.storage.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException closing JobStorage: " + StringUtils.stringifyException((Throwable)ioe)));
                }
            }
        }
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getJobOptions());
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("verbose")) {
            LoggingUtils.setDebugLevel();
            LOG.debug((Object)"Enabled debug logging.");
        }
        if (in.hasOption("help")) {
            ToolOptions toolOpts = new ToolOptions();
            this.configureOptions(toolOpts);
            this.printHelp(toolOpts);
            throw new SqoopOptions.InvalidOptionsException("");
        }
        this.storageDescriptor = new TreeMap<String, String>();
        if (in.hasOption("meta-connect")) {
            this.storageDescriptor.put("metastore.connect.string", in.getOptionValue("meta-connect"));
        }
        if (in.hasOption("create")) {
            this.operation = JobOp.JobCreate;
            this.jobName = in.getOptionValue("create");
        } else if (in.hasOption("delete")) {
            this.operation = JobOp.JobDelete;
            this.jobName = in.getOptionValue("delete");
        } else if (in.hasOption("exec")) {
            this.operation = JobOp.JobExecute;
            this.jobName = in.getOptionValue("exec");
        } else if (in.hasOption("list")) {
            this.operation = JobOp.JobList;
        } else if (in.hasOption("show")) {
            this.operation = JobOp.JobShow;
            this.jobName = in.getOptionValue("show");
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (null == this.operation || null == this.jobName && this.operation != JobOp.JobList) {
            throw new SqoopOptions.InvalidOptionsException("No job operation specified\nTry --help for usage instructions.");
        }
        if (this.operation == JobOp.JobCreate && (this.extraArguments == null || this.extraArguments.length == 0)) {
            throw new SqoopOptions.InvalidOptionsException("Expected: -- <tool-name> [tool-args] \nTry --help for usage instructions.");
        }
        int dashPos = this.getDashPosition(this.extraArguments);
        if (this.hasUnrecognizedArgs(this.extraArguments, 0, dashPos)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
    }

    @Override
    public void printHelp(ToolOptions opts) {
        System.out.println("usage: sqoop " + this.getToolName() + " [GENERIC-ARGS] [JOB-ARGS] [-- [<tool-name>] [TOOL-ARGS]]");
        System.out.println("");
        opts.printHelp();
        System.out.println("");
        System.out.println("Generic Hadoop command-line arguments:");
        System.out.println("(must preceed any tool-specific arguments)");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    private static enum JobOp {
        JobCreate,
        JobDelete,
        JobExecute,
        JobList,
        JobShow;

    }
}

