/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;

public class MDRCache {
    private static final ArrayList instances = new ArrayList();
    private final FacilityCache hashOnId = new FacilityCache();
    private final Map hardRef;
    private HashMap newOnes;
    private HashMap dirty;
    private HashMap deleted;
    OverflowHandler handler;
    private static final int threshhold = Integer.getInteger("org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache.threshhold", 1000) * 2;
    private static final boolean CACHE_DEBUG = Boolean.getBoolean("perf.mdr.MDRCache");
    private static int size = 0;
    private static StringBuffer DEBUG_INFO = Boolean.getBoolean("debug.mdr.MDRCache") ? new StringBuffer(20000) : null;
    private static boolean alreadyChecking = false;
    private static final Object LOCK = new Object();
    private int localThreshhold;
    private int lastLocalSize = 0;
    public static final int M_DELETED = 1;
    public static final int M_DIRTY = 2;
    public static final int M_NEW = 4;
    private static int hits;
    private static int misses;
    private static final Comparator mofidComparator;
    static /* synthetic */ Class class$0;

    static {
        mofidComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                MOFID id1 = (MOFID)o1;
                MOFID id2 = (MOFID)o2;
                return (int)(id1.getSerialNumber() - id2.getSerialNumber());
            }
        };
    }

    public MDRCache(int size, OverflowHandler hndlr, int limit, Map hardRef) {
        this(size, hardRef);
        this.handler = hndlr;
        this.localThreshhold = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDRCache(int size, Map hardRef) {
        if (hardRef == null) {
            hardRef = new CacheClass(size);
        }
        this.hardRef = hardRef;
        this.deleted = new HashMap();
        this.dirty = new HashMap();
        this.newOnes = new HashMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            instances.add(this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            instances.remove(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized int getModStatus() {
        return (this.deleted.isEmpty() ? 0 : 1) + (this.dirty.isEmpty() ? 0 : 2) + (this.newOnes.isEmpty() ? 0 : 4);
    }

    public synchronized void put(Object m, Object o) throws StorageException {
        if (this.hashOnId.get(m) == null) {
            this.hashOnId.put(m, o);
        }
        this.makeHardRef(m, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Object get(Object m) {
        Object o = this.hashOnId.get(m);
        if (o != null) {
            this.makeHardRef(m, o);
        }
        if (!CACHE_DEBUG) return o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (o != null) {
                ++hits;
            } else {
                ++misses;
            }
            if ((hits + misses) % 20000 != 0) return o;
            this.showStats(System.err);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return o;
        }
    }

    public synchronized void replace(Object m, Object o) throws StorageException {
        this.removeFromCache(m);
        this.put(m, o);
    }

    public synchronized void remove(Object m) {
        if (!this.removeFromCache(m)) {
            this.deleted.put(m, m);
        }
    }

    private boolean removeFromCache(Object m) {
        this.hashOnId.remove(m);
        boolean wasNew = this.newOnes.remove(m) != null;
        this.dirty.remove(m);
        return wasNew;
    }

    public synchronized void clear() {
        this.hardRef.clear();
        System.gc();
    }

    private void makeHardRef(Object m, Object o) {
        this.hardRef.put(m, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSize() {
        int allChanged = this.newOnes.size() + this.dirty.size();
        int sizeDelta = allChanged - this.lastLocalSize;
        this.lastLocalSize = allChanged;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            size += sizeDelta;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void checkThreshhold() throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [11 : 546->550)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void badKey(Object key) throws StorageException {
        throw new StorageBadRequestException(MessageFormat.format("No object with ID {0}", key));
    }

    public synchronized void setNew(Object key) throws StorageException {
        Object o = this.get(key);
        if (o == null) {
            this.badKey(key);
        }
        this.newOnes.put(key, o);
        if (this.handler != null) {
            this.checkThreshhold();
        }
    }

    public synchronized boolean isNew(Object key) {
        return this.newOnes.get(key) != null;
    }

    public synchronized Iterator iterateActive() {
        return this.hashOnId.keySet().iterator();
    }

    public synchronized Iterator iterateDeleted() {
        return this.deleted.keySet().iterator();
    }

    public synchronized Iterator iterateNew() {
        return this.newOnes.keySet().iterator();
    }

    public int numberNew() {
        return this.newOnes.size();
    }

    public int numberDeleted() {
        return this.deleted.size();
    }

    public synchronized boolean isDeleted(Object key) {
        return this.deleted.get(key) != null;
    }

    public synchronized void setDirty(Object key) throws StorageException {
        Object o = this.get(key);
        if (o == null) {
            this.badKey(key);
        }
        if (this.newOnes.get(key) == null) {
            this.dirty.put(key, o);
            if (this.handler != null) {
                this.checkThreshhold();
            }
        }
    }

    public synchronized Collection getNew() {
        TreeMap result = new TreeMap(mofidComparator);
        result.putAll(this.newOnes);
        this.newOnes.clear();
        return result.entrySet();
    }

    public synchronized Collection getDirty() {
        HashMap result = new HashMap(this.dirty);
        this.dirty.clear();
        return result.entrySet();
    }

    public synchronized Collection getDeleted() {
        ArrayList result = new ArrayList(this.deleted.values());
        this.deleted.clear();
        return result;
    }

    public synchronized void clearLists() {
        this.dirty.clear();
        this.newOnes.clear();
        this.deleted.clear();
    }

    public void showStats(PrintStream strm) {
        this.showStats(new PrintWriter(strm));
    }

    public void showStats(PrintWriter strm) {
        strm.println("MDRCache hits: " + hits + " misses: " + misses + " hit rate: " + 100.0 * (double)hits / (double)(hits + misses));
        strm.flush();
    }

    private static class CacheClass
    implements Map {
        private final Object[] inner;
        private int size;
        private int cursor;

        public CacheClass(int size) {
            this.inner = new Object[size];
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            if (value != this.inner[this.cursor]) {
                ++this.cursor;
                if (this.size < this.inner.length) {
                    ++this.size;
                }
                if (this.cursor >= this.inner.length) {
                    this.cursor = 0;
                }
                this.inner[this.cursor] = value;
            }
            return null;
        }

        public void clear() {
            Arrays.fill(this.inner, null);
            this.cursor = 0;
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface OverflowHandler {
        public void cacheThreshholdReached(MDRCache var1, int var2) throws StorageException;
    }

    private static class FacilityCache
    extends HashMap {
        private final ReferenceQueue queue = new ReferenceQueue();
        private boolean cleaningUp = false;

        private FacilityCache() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void cleanUp() {
            this.cleaningUp = true;
            try {
                CacheReference reference;
                while ((reference = (CacheReference)this.queue.poll()) != null) {
                    Object key = reference.getKey();
                    Reference currentRef = (Reference)super.remove(key);
                    if (currentRef == null || currentRef == reference || currentRef.get() == null) continue;
                    super.put(key, currentRef);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.cleaningUp = false;
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.cleaningUp = false;
                return;
            }
        }

        public Object put(Object key, Object value) {
            this.cleanUp();
            CacheReference result = super.put(key, new CacheReference(key, value, this.queue));
            return null;
        }

        public Object remove(Object key) {
            this.cleanUp();
            Object result = super.remove(key);
            return result == null ? null : ((CacheReference)result).get();
        }

        public Object get(Object key) {
            this.cleanUp();
            Object result = super.get(key);
            return result == null ? null : ((CacheReference)result).get();
        }

        private static class CacheReference
        extends WeakReference {
            private Object key;

            public CacheReference(Object key, Object object, ReferenceQueue q) {
                super(object, q);
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }
        }
    }
}

